# 2024-05-14 Triage Log

A pretty quiet week with only a few PRs being flagged for analysis.
More improvements than regressions this week, and also several nice
binary size reductions caused by generating less LLVM IR.

Triage done by **@kobzol**.
Revision range: [69f53f5e..9105c57b](https://perf.rust-lang.org/?start=69f53f5e5583381267298ac182eb02c7f1b5c1cd&end=9105c57b7f6623310e33f3ee7e48a3114e5190a7&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.9%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.9%  | [0.2%, 2.4%]   | 18    |
| Improvements ✅ <br /> (primary)   | -1.1% | [-2.3%, -0.2%] | 51    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.4%, -0.3%] | 19    |
| All ❌✅ (primary)                 | -0.9% | [-2.3%, 0.9%]  | 59    |


1 Regression, 0 Improvements, 3 Mixed; 0 of them in rollups
75 artifact comparisons made in total

#### Regressions

Do not add leading asterisk in the `PartialEq` [#124157](https://github.com/rust-lang/rust/pull/124157) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5f8c17dcc04a2981268df89874203e9bfea50597&end=cb93c24bf36b3367714516fc2308cf6856916eeb&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.2%, 0.5%] | 9     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.8%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.2%, 0.5%] | 9     |

* Small regression on a few benchmarks caused by a change in code generation of `#[derive(PartialEq)]`,
which leads to more valid code being allowed to compile.
* Marked as triaged.

#### Mixed

Avoid a cast in `ptr::slice_from_raw_parts(_mut)` [#124795](https://github.com/rust-lang/rust/pull/124795) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c3202afa2865ad26ef407544c3768070bfed7bfe&end=ec1b69852f0c24ae833a74303800db2229b6653e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.3%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.2%] | 16    |
| All ❌✅ (primary)                 | -0.3% | [-0.6%, 0.3%]  | 7     |

* A single tiny regression outweighed by several performance wins.
* This PR also reduced binary size nicely.

Avoid `alloca`s in codegen for simple `mir::Aggregate` statements [#123886](https://github.com/rust-lang/rust/pull/123886) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2cce0885840cd171cb3a8677af795d0abd2dc77c&end=6e1d94708a0a4a35ca7e46c6cac98adf62fe800e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.3%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 1.3%]   | 4     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.0%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.1%, -0.4%] | 2     |
| All ❌✅ (primary)                 | -0.2% | [-1.0%, 0.3%]  | 12    |

* The regression was limited to a single primary benchmark, there were more primary benchmark wins.
* Also a nice binary size reduction in debug builds.

Remove `NtIdent` and `NtLifetime` [#124256](https://github.com/rust-lang/rust/pull/124256) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=34582118afaf00b0eb2d209a90b181c7156b501c&end=9105c57b7f6623310e33f3ee7e48a3114e5190a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [1.2%, 2.7%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.0%, -0.1%] | 24    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.1%, -0.3%] | 9     |
| All ❌✅ (primary)                 | -0.7% | [-2.0%, 0.2%]  | 25    |

* Pretty much a pure performance improvement, the instruction count regression on `tt-muncher` was
actually a decent win in cycle count.
