#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum JoiningGroup {
  AfricanFeh, AfricanNoon, AfricanQaf, Ain, Alaph, Alef, Beh, Beth,
  BurushaskiYehBarree, Dal, DalathRish, E, FarsiYeh, Fe, Feh, FinalSemkath, Gaf,
  Gamal, Hah, He, Heh, HehGoal, Heth, Kaf, Kaph, Khaph, KnottedHeh, Lam, Lamadh,
  ManichaeanAleph, ManichaeanAyin, ManichaeanBeth, ManichaeanDaleth,
  ManichaeanDhamedh, ManichaeanFive, ManichaeanGimel, ManichaeanHeth,
  ManichaeanHundred, ManichaeanKaph, ManichaeanLamedh, ManichaeanMem,
  ManichaeanNun, ManichaeanOne, ManichaeanPe, ManichaeanQoph, ManichaeanResh,
  ManichaeanSadhe, ManichaeanSamekh, ManichaeanTaw, ManichaeanTen,
  ManichaeanTeth, ManichaeanThamedh, ManichaeanTwenty, ManichaeanWaw,
  ManichaeanYodh, ManichaeanZayin, Meem, Mim, NoJoiningGroup, Noon, Nun, Nya,
  Pe, Qaf, Qaph, Reh, ReversedPe, RohingyaYeh, Sad, Sadhe, Seen, Semkath, Shin,
  StraightWaw, SwashKaf, SyriacWaw, Tah, Taw, TehMarbuta, TehMarbutaGoal, Teth,
  Waw, Yeh, YehBarree, YehWithTail, Yudh, YudhHe, Zain, Zhain
}

pub static UCD_JOINGRP: &'static [((u8,u8,u8), JoiningGroup)] = &[
  ((0,6,32),JoiningGroup::Yeh), ((0,6,34),JoiningGroup::Alef),
  ((0,6,35),JoiningGroup::Alef), ((0,6,36),JoiningGroup::Waw),
  ((0,6,37),JoiningGroup::Alef), ((0,6,38),JoiningGroup::Yeh),
  ((0,6,39),JoiningGroup::Alef), ((0,6,40),JoiningGroup::Beh),
  ((0,6,41),JoiningGroup::TehMarbuta), ((0,6,42),JoiningGroup::Beh),
  ((0,6,43),JoiningGroup::Beh), ((0,6,44),JoiningGroup::Hah),
  ((0,6,45),JoiningGroup::Hah), ((0,6,46),JoiningGroup::Hah),
  ((0,6,47),JoiningGroup::Dal), ((0,6,48),JoiningGroup::Dal),
  ((0,6,49),JoiningGroup::Reh), ((0,6,50),JoiningGroup::Reh),
  ((0,6,51),JoiningGroup::Seen), ((0,6,52),JoiningGroup::Seen),
  ((0,6,53),JoiningGroup::Sad), ((0,6,54),JoiningGroup::Sad),
  ((0,6,55),JoiningGroup::Tah), ((0,6,56),JoiningGroup::Tah),
  ((0,6,57),JoiningGroup::Ain), ((0,6,58),JoiningGroup::Ain),
  ((0,6,59),JoiningGroup::Gaf), ((0,6,60),JoiningGroup::Gaf),
  ((0,6,61),JoiningGroup::FarsiYeh), ((0,6,62),JoiningGroup::FarsiYeh),
  ((0,6,63),JoiningGroup::FarsiYeh), ((0,6,65),JoiningGroup::Feh),
  ((0,6,66),JoiningGroup::Qaf), ((0,6,67),JoiningGroup::Kaf),
  ((0,6,68),JoiningGroup::Lam), ((0,6,69),JoiningGroup::Meem),
  ((0,6,70),JoiningGroup::Noon), ((0,6,71),JoiningGroup::Heh),
  ((0,6,72),JoiningGroup::Waw), ((0,6,73),JoiningGroup::Yeh),
  ((0,6,74),JoiningGroup::Yeh), ((0,6,110),JoiningGroup::Beh),
  ((0,6,111),JoiningGroup::Qaf), ((0,6,113),JoiningGroup::Alef),
  ((0,6,114),JoiningGroup::Alef), ((0,6,115),JoiningGroup::Alef),
  ((0,6,117),JoiningGroup::Alef), ((0,6,118),JoiningGroup::Waw),
  ((0,6,119),JoiningGroup::Waw), ((0,6,120),JoiningGroup::Yeh),
  ((0,6,121),JoiningGroup::Beh), ((0,6,122),JoiningGroup::Beh),
  ((0,6,123),JoiningGroup::Beh), ((0,6,124),JoiningGroup::Beh),
  ((0,6,125),JoiningGroup::Beh), ((0,6,126),JoiningGroup::Beh),
  ((0,6,127),JoiningGroup::Beh), ((0,6,128),JoiningGroup::Beh),
  ((0,6,129),JoiningGroup::Hah), ((0,6,130),JoiningGroup::Hah),
  ((0,6,131),JoiningGroup::Hah), ((0,6,132),JoiningGroup::Hah),
  ((0,6,133),JoiningGroup::Hah), ((0,6,134),JoiningGroup::Hah),
  ((0,6,135),JoiningGroup::Hah), ((0,6,136),JoiningGroup::Dal),
  ((0,6,137),JoiningGroup::Dal), ((0,6,138),JoiningGroup::Dal),
  ((0,6,139),JoiningGroup::Dal), ((0,6,140),JoiningGroup::Dal),
  ((0,6,141),JoiningGroup::Dal), ((0,6,142),JoiningGroup::Dal),
  ((0,6,143),JoiningGroup::Dal), ((0,6,144),JoiningGroup::Dal),
  ((0,6,145),JoiningGroup::Reh), ((0,6,146),JoiningGroup::Reh),
  ((0,6,147),JoiningGroup::Reh), ((0,6,148),JoiningGroup::Reh),
  ((0,6,149),JoiningGroup::Reh), ((0,6,150),JoiningGroup::Reh),
  ((0,6,151),JoiningGroup::Reh), ((0,6,152),JoiningGroup::Reh),
  ((0,6,153),JoiningGroup::Reh), ((0,6,154),JoiningGroup::Seen),
  ((0,6,155),JoiningGroup::Seen), ((0,6,156),JoiningGroup::Seen),
  ((0,6,157),JoiningGroup::Sad), ((0,6,158),JoiningGroup::Sad),
  ((0,6,159),JoiningGroup::Tah), ((0,6,160),JoiningGroup::Ain),
  ((0,6,161),JoiningGroup::Feh), ((0,6,162),JoiningGroup::Feh),
  ((0,6,163),JoiningGroup::Feh), ((0,6,164),JoiningGroup::Feh),
  ((0,6,165),JoiningGroup::Feh), ((0,6,166),JoiningGroup::Feh),
  ((0,6,167),JoiningGroup::Qaf), ((0,6,168),JoiningGroup::Qaf),
  ((0,6,169),JoiningGroup::Gaf), ((0,6,170),JoiningGroup::SwashKaf),
  ((0,6,171),JoiningGroup::Gaf), ((0,6,172),JoiningGroup::Kaf),
  ((0,6,173),JoiningGroup::Kaf), ((0,6,174),JoiningGroup::Kaf),
  ((0,6,175),JoiningGroup::Gaf), ((0,6,176),JoiningGroup::Gaf),
  ((0,6,177),JoiningGroup::Gaf), ((0,6,178),JoiningGroup::Gaf),
  ((0,6,179),JoiningGroup::Gaf), ((0,6,180),JoiningGroup::Gaf),
  ((0,6,181),JoiningGroup::Lam), ((0,6,182),JoiningGroup::Lam),
  ((0,6,183),JoiningGroup::Lam), ((0,6,184),JoiningGroup::Lam),
  ((0,6,185),JoiningGroup::Noon), ((0,6,186),JoiningGroup::Noon),
  ((0,6,187),JoiningGroup::Noon), ((0,6,188),JoiningGroup::Noon),
  ((0,6,189),JoiningGroup::Nya), ((0,6,190),JoiningGroup::KnottedHeh),
  ((0,6,191),JoiningGroup::Hah), ((0,6,192),JoiningGroup::TehMarbuta),
  ((0,6,193),JoiningGroup::HehGoal), ((0,6,194),JoiningGroup::HehGoal),
  ((0,6,195),JoiningGroup::TehMarbutaGoal), ((0,6,196),JoiningGroup::Waw),
  ((0,6,197),JoiningGroup::Waw), ((0,6,198),JoiningGroup::Waw),
  ((0,6,199),JoiningGroup::Waw), ((0,6,200),JoiningGroup::Waw),
  ((0,6,201),JoiningGroup::Waw), ((0,6,202),JoiningGroup::Waw),
  ((0,6,203),JoiningGroup::Waw), ((0,6,204),JoiningGroup::FarsiYeh),
  ((0,6,205),JoiningGroup::YehWithTail), ((0,6,206),JoiningGroup::FarsiYeh),
  ((0,6,207),JoiningGroup::Waw), ((0,6,208),JoiningGroup::Yeh),
  ((0,6,209),JoiningGroup::Yeh), ((0,6,210),JoiningGroup::YehBarree),
  ((0,6,211),JoiningGroup::YehBarree), ((0,6,213),JoiningGroup::TehMarbuta),
  ((0,6,238),JoiningGroup::Dal), ((0,6,239),JoiningGroup::Reh),
  ((0,6,250),JoiningGroup::Seen), ((0,6,251),JoiningGroup::Sad),
  ((0,6,252),JoiningGroup::Ain), ((0,6,255),JoiningGroup::KnottedHeh),
  ((0,7,16),JoiningGroup::Alaph), ((0,7,18),JoiningGroup::Beth),
  ((0,7,19),JoiningGroup::Gamal), ((0,7,20),JoiningGroup::Gamal),
  ((0,7,21),JoiningGroup::DalathRish), ((0,7,22),JoiningGroup::DalathRish),
  ((0,7,23),JoiningGroup::He), ((0,7,24),JoiningGroup::SyriacWaw),
  ((0,7,25),JoiningGroup::Zain), ((0,7,26),JoiningGroup::Heth),
  ((0,7,27),JoiningGroup::Teth), ((0,7,28),JoiningGroup::Teth),
  ((0,7,29),JoiningGroup::Yudh), ((0,7,30),JoiningGroup::YudhHe),
  ((0,7,31),JoiningGroup::Kaph), ((0,7,32),JoiningGroup::Lamadh),
  ((0,7,33),JoiningGroup::Mim), ((0,7,34),JoiningGroup::Nun),
  ((0,7,35),JoiningGroup::Semkath), ((0,7,36),JoiningGroup::FinalSemkath),
  ((0,7,37),JoiningGroup::E), ((0,7,38),JoiningGroup::Pe),
  ((0,7,39),JoiningGroup::ReversedPe), ((0,7,40),JoiningGroup::Sadhe),
  ((0,7,41),JoiningGroup::Qaph), ((0,7,42),JoiningGroup::DalathRish),
  ((0,7,43),JoiningGroup::Shin), ((0,7,44),JoiningGroup::Taw),
  ((0,7,45),JoiningGroup::Beth), ((0,7,46),JoiningGroup::Gamal),
  ((0,7,47),JoiningGroup::DalathRish), ((0,7,77),JoiningGroup::Zhain),
  ((0,7,78),JoiningGroup::Khaph), ((0,7,79),JoiningGroup::Fe),
  ((0,7,80),JoiningGroup::Beh), ((0,7,81),JoiningGroup::Beh),
  ((0,7,82),JoiningGroup::Beh), ((0,7,83),JoiningGroup::Beh),
  ((0,7,84),JoiningGroup::Beh), ((0,7,85),JoiningGroup::Beh),
  ((0,7,86),JoiningGroup::Beh), ((0,7,87),JoiningGroup::Hah),
  ((0,7,88),JoiningGroup::Hah), ((0,7,89),JoiningGroup::Dal),
  ((0,7,90),JoiningGroup::Dal), ((0,7,91),JoiningGroup::Reh),
  ((0,7,92),JoiningGroup::Seen), ((0,7,93),JoiningGroup::Ain),
  ((0,7,94),JoiningGroup::Ain), ((0,7,95),JoiningGroup::Ain),
  ((0,7,96),JoiningGroup::Feh), ((0,7,97),JoiningGroup::Feh),
  ((0,7,98),JoiningGroup::Gaf), ((0,7,99),JoiningGroup::Gaf),
  ((0,7,100),JoiningGroup::Gaf), ((0,7,101),JoiningGroup::Meem),
  ((0,7,102),JoiningGroup::Meem), ((0,7,103),JoiningGroup::Noon),
  ((0,7,104),JoiningGroup::Noon), ((0,7,105),JoiningGroup::Noon),
  ((0,7,106),JoiningGroup::Lam), ((0,7,107),JoiningGroup::Reh),
  ((0,7,108),JoiningGroup::Reh), ((0,7,109),JoiningGroup::Seen),
  ((0,7,110),JoiningGroup::Hah), ((0,7,111),JoiningGroup::Hah),
  ((0,7,112),JoiningGroup::Seen), ((0,7,113),JoiningGroup::Reh),
  ((0,7,114),JoiningGroup::Hah), ((0,7,115),JoiningGroup::Alef),
  ((0,7,116),JoiningGroup::Alef), ((0,7,117),JoiningGroup::FarsiYeh),
  ((0,7,118),JoiningGroup::FarsiYeh), ((0,7,119),JoiningGroup::Yeh),
  ((0,7,120),JoiningGroup::Waw), ((0,7,121),JoiningGroup::Waw),
  ((0,7,122),JoiningGroup::BurushaskiYehBarree),
  ((0,7,123),JoiningGroup::BurushaskiYehBarree), ((0,7,124),JoiningGroup::Hah),
  ((0,7,125),JoiningGroup::Seen), ((0,7,126),JoiningGroup::Seen),
  ((0,7,127),JoiningGroup::Kaf), ((0,8,160),JoiningGroup::Beh),
  ((0,8,161),JoiningGroup::Beh), ((0,8,162),JoiningGroup::Hah),
  ((0,8,163),JoiningGroup::Tah), ((0,8,164),JoiningGroup::Feh),
  ((0,8,165),JoiningGroup::Qaf), ((0,8,166),JoiningGroup::Lam),
  ((0,8,167),JoiningGroup::Meem), ((0,8,168),JoiningGroup::Yeh),
  ((0,8,169),JoiningGroup::Yeh), ((0,8,170),JoiningGroup::Reh),
  ((0,8,171),JoiningGroup::Waw), ((0,8,172),JoiningGroup::RohingyaYeh),
  ((0,8,174),JoiningGroup::Dal), ((0,8,175),JoiningGroup::Sad),
  ((0,8,176),JoiningGroup::Gaf), ((0,8,177),JoiningGroup::StraightWaw),
  ((0,8,178),JoiningGroup::Reh), ((0,8,179),JoiningGroup::Ain),
  ((0,8,180),JoiningGroup::Kaf), ((0,8,182),JoiningGroup::Beh),
  ((0,8,183),JoiningGroup::Beh), ((0,8,184),JoiningGroup::Beh),
  ((0,8,185),JoiningGroup::Reh), ((0,8,186),JoiningGroup::Yeh),
  ((0,8,187),JoiningGroup::AfricanFeh), ((0,8,188),JoiningGroup::AfricanQaf),
  ((0,8,189),JoiningGroup::AfricanNoon),
  ((1,10,192),JoiningGroup::ManichaeanAleph),
  ((1,10,193),JoiningGroup::ManichaeanBeth),
  ((1,10,194),JoiningGroup::ManichaeanBeth),
  ((1,10,195),JoiningGroup::ManichaeanGimel),
  ((1,10,196),JoiningGroup::ManichaeanGimel),
  ((1,10,197),JoiningGroup::ManichaeanDaleth),
  ((1,10,199),JoiningGroup::ManichaeanWaw),
  ((1,10,201),JoiningGroup::ManichaeanZayin),
  ((1,10,202),JoiningGroup::ManichaeanZayin),
  ((1,10,205),JoiningGroup::ManichaeanHeth),
  ((1,10,206),JoiningGroup::ManichaeanTeth),
  ((1,10,207),JoiningGroup::ManichaeanYodh),
  ((1,10,208),JoiningGroup::ManichaeanKaph),
  ((1,10,209),JoiningGroup::ManichaeanKaph),
  ((1,10,210),JoiningGroup::ManichaeanKaph),
  ((1,10,211),JoiningGroup::ManichaeanLamedh),
  ((1,10,212),JoiningGroup::ManichaeanDhamedh),
  ((1,10,213),JoiningGroup::ManichaeanThamedh),
  ((1,10,214),JoiningGroup::ManichaeanMem),
  ((1,10,215),JoiningGroup::ManichaeanNun),
  ((1,10,216),JoiningGroup::ManichaeanSamekh),
  ((1,10,217),JoiningGroup::ManichaeanAyin),
  ((1,10,218),JoiningGroup::ManichaeanAyin),
  ((1,10,219),JoiningGroup::ManichaeanPe),
  ((1,10,220),JoiningGroup::ManichaeanPe),
  ((1,10,221),JoiningGroup::ManichaeanSadhe),
  ((1,10,222),JoiningGroup::ManichaeanQoph),
  ((1,10,223),JoiningGroup::ManichaeanQoph),
  ((1,10,224),JoiningGroup::ManichaeanQoph),
  ((1,10,225),JoiningGroup::ManichaeanResh),
  ((1,10,228),JoiningGroup::ManichaeanTaw),
  ((1,10,235),JoiningGroup::ManichaeanOne),
  ((1,10,236),JoiningGroup::ManichaeanFive),
  ((1,10,237),JoiningGroup::ManichaeanTen),
  ((1,10,238),JoiningGroup::ManichaeanTwenty),
  ((1,10,239),JoiningGroup::ManichaeanHundred)
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum JoiningType {
  JoinCausing, DualJoining, LeftJoining, RightJoining, Transparent, NonJoining
}

pub static UCD_JOINTYPE: &'static [((u8,u8,u8), (u8,u8,u8), JoiningType)] = &[
  ((0,0,173),(0,0,173),JoiningType::Transparent),
  ((0,3,0),(0,3,111),JoiningType::Transparent),
  ((0,4,131),(0,4,137),JoiningType::Transparent),
  ((0,5,145),(0,5,189),JoiningType::Transparent),
  ((0,5,191),(0,5,191),JoiningType::Transparent),
  ((0,5,193),(0,5,194),JoiningType::Transparent),
  ((0,5,196),(0,5,197),JoiningType::Transparent),
  ((0,5,199),(0,5,199),JoiningType::Transparent),
  ((0,6,16),(0,6,26),JoiningType::Transparent),
  ((0,6,28),(0,6,28),JoiningType::Transparent),
  ((0,6,32),(0,6,32),JoiningType::DualJoining),
  ((0,6,34),(0,6,37),JoiningType::RightJoining),
  ((0,6,38),(0,6,38),JoiningType::DualJoining),
  ((0,6,39),(0,6,39),JoiningType::RightJoining),
  ((0,6,40),(0,6,40),JoiningType::DualJoining),
  ((0,6,41),(0,6,41),JoiningType::RightJoining),
  ((0,6,42),(0,6,46),JoiningType::DualJoining),
  ((0,6,47),(0,6,50),JoiningType::RightJoining),
  ((0,6,51),(0,6,63),JoiningType::DualJoining),
  ((0,6,64),(0,6,64),JoiningType::JoinCausing),
  ((0,6,65),(0,6,71),JoiningType::DualJoining),
  ((0,6,72),(0,6,72),JoiningType::RightJoining),
  ((0,6,73),(0,6,74),JoiningType::DualJoining),
  ((0,6,75),(0,6,95),JoiningType::Transparent),
  ((0,6,110),(0,6,111),JoiningType::DualJoining),
  ((0,6,112),(0,6,112),JoiningType::Transparent),
  ((0,6,113),(0,6,115),JoiningType::RightJoining),
  ((0,6,117),(0,6,119),JoiningType::RightJoining),
  ((0,6,120),(0,6,135),JoiningType::DualJoining),
  ((0,6,136),(0,6,153),JoiningType::RightJoining),
  ((0,6,154),(0,6,191),JoiningType::DualJoining),
  ((0,6,192),(0,6,192),JoiningType::RightJoining),
  ((0,6,193),(0,6,194),JoiningType::DualJoining),
  ((0,6,195),(0,6,203),JoiningType::RightJoining),
  ((0,6,204),(0,6,204),JoiningType::DualJoining),
  ((0,6,205),(0,6,205),JoiningType::RightJoining),
  ((0,6,206),(0,6,206),JoiningType::DualJoining),
  ((0,6,207),(0,6,207),JoiningType::RightJoining),
  ((0,6,208),(0,6,209),JoiningType::DualJoining),
  ((0,6,210),(0,6,211),JoiningType::RightJoining),
  ((0,6,213),(0,6,213),JoiningType::RightJoining),
  ((0,6,214),(0,6,220),JoiningType::Transparent),
  ((0,6,223),(0,6,228),JoiningType::Transparent),
  ((0,6,231),(0,6,232),JoiningType::Transparent),
  ((0,6,234),(0,6,237),JoiningType::Transparent),
  ((0,6,238),(0,6,239),JoiningType::RightJoining),
  ((0,6,250),(0,6,252),JoiningType::DualJoining),
  ((0,6,255),(0,6,255),JoiningType::DualJoining),
  ((0,7,15),(0,7,15),JoiningType::Transparent),
  ((0,7,16),(0,7,16),JoiningType::RightJoining),
  ((0,7,17),(0,7,17),JoiningType::Transparent),
  ((0,7,18),(0,7,20),JoiningType::DualJoining),
  ((0,7,21),(0,7,25),JoiningType::RightJoining),
  ((0,7,26),(0,7,29),JoiningType::DualJoining),
  ((0,7,30),(0,7,30),JoiningType::RightJoining),
  ((0,7,31),(0,7,39),JoiningType::DualJoining),
  ((0,7,40),(0,7,40),JoiningType::RightJoining),
  ((0,7,41),(0,7,41),JoiningType::DualJoining),
  ((0,7,42),(0,7,42),JoiningType::RightJoining),
  ((0,7,43),(0,7,43),JoiningType::DualJoining),
  ((0,7,44),(0,7,44),JoiningType::RightJoining),
  ((0,7,45),(0,7,46),JoiningType::DualJoining),
  ((0,7,47),(0,7,47),JoiningType::RightJoining),
  ((0,7,48),(0,7,74),JoiningType::Transparent),
  ((0,7,77),(0,7,77),JoiningType::RightJoining),
  ((0,7,78),(0,7,88),JoiningType::DualJoining),
  ((0,7,89),(0,7,91),JoiningType::RightJoining),
  ((0,7,92),(0,7,106),JoiningType::DualJoining),
  ((0,7,107),(0,7,108),JoiningType::RightJoining),
  ((0,7,109),(0,7,112),JoiningType::DualJoining),
  ((0,7,113),(0,7,113),JoiningType::RightJoining),
  ((0,7,114),(0,7,114),JoiningType::DualJoining),
  ((0,7,115),(0,7,116),JoiningType::RightJoining),
  ((0,7,117),(0,7,119),JoiningType::DualJoining),
  ((0,7,120),(0,7,121),JoiningType::RightJoining),
  ((0,7,122),(0,7,127),JoiningType::DualJoining),
  ((0,7,166),(0,7,176),JoiningType::Transparent),
  ((0,7,202),(0,7,234),JoiningType::DualJoining),
  ((0,7,235),(0,7,243),JoiningType::Transparent),
  ((0,7,250),(0,7,250),JoiningType::JoinCausing),
  ((0,8,22),(0,8,25),JoiningType::Transparent),
  ((0,8,27),(0,8,35),JoiningType::Transparent),
  ((0,8,37),(0,8,39),JoiningType::Transparent),
  ((0,8,41),(0,8,45),JoiningType::Transparent),
  ((0,8,64),(0,8,64),JoiningType::RightJoining),
  ((0,8,65),(0,8,69),JoiningType::DualJoining),
  ((0,8,70),(0,8,71),JoiningType::RightJoining),
  ((0,8,72),(0,8,72),JoiningType::DualJoining),
  ((0,8,73),(0,8,73),JoiningType::RightJoining),
  ((0,8,74),(0,8,83),JoiningType::DualJoining),
  ((0,8,84),(0,8,84),JoiningType::RightJoining),
  ((0,8,85),(0,8,85),JoiningType::DualJoining),
  ((0,8,89),(0,8,91),JoiningType::Transparent),
  ((0,8,160),(0,8,169),JoiningType::DualJoining),
  ((0,8,170),(0,8,172),JoiningType::RightJoining),
  ((0,8,174),(0,8,174),JoiningType::RightJoining),
  ((0,8,175),(0,8,176),JoiningType::DualJoining),
  ((0,8,177),(0,8,178),JoiningType::RightJoining),
  ((0,8,179),(0,8,180),JoiningType::DualJoining),
  ((0,8,182),(0,8,184),JoiningType::DualJoining),
  ((0,8,185),(0,8,185),JoiningType::RightJoining),
  ((0,8,186),(0,8,189),JoiningType::DualJoining),
  ((0,8,212),(0,8,225),JoiningType::Transparent),
  ((0,8,227),(0,9,2),JoiningType::Transparent),
  ((0,9,58),(0,9,58),JoiningType::Transparent),
  ((0,9,60),(0,9,60),JoiningType::Transparent),
  ((0,9,65),(0,9,72),JoiningType::Transparent),
  ((0,9,77),(0,9,77),JoiningType::Transparent),
  ((0,9,81),(0,9,87),JoiningType::Transparent),
  ((0,9,98),(0,9,99),JoiningType::Transparent),
  ((0,9,129),(0,9,129),JoiningType::Transparent),
  ((0,9,188),(0,9,188),JoiningType::Transparent),
  ((0,9,193),(0,9,196),JoiningType::Transparent),
  ((0,9,205),(0,9,205),JoiningType::Transparent),
  ((0,9,226),(0,9,227),JoiningType::Transparent),
  ((0,10,1),(0,10,2),JoiningType::Transparent),
  ((0,10,60),(0,10,60),JoiningType::Transparent),
  ((0,10,65),(0,10,66),JoiningType::Transparent),
  ((0,10,71),(0,10,72),JoiningType::Transparent),
  ((0,10,75),(0,10,77),JoiningType::Transparent),
  ((0,10,81),(0,10,81),JoiningType::Transparent),
  ((0,10,112),(0,10,113),JoiningType::Transparent),
  ((0,10,117),(0,10,117),JoiningType::Transparent),
  ((0,10,129),(0,10,130),JoiningType::Transparent),
  ((0,10,188),(0,10,188),JoiningType::Transparent),
  ((0,10,193),(0,10,197),JoiningType::Transparent),
  ((0,10,199),(0,10,200),JoiningType::Transparent),
  ((0,10,205),(0,10,205),JoiningType::Transparent),
  ((0,10,226),(0,10,227),JoiningType::Transparent),
  ((0,11,1),(0,11,1),JoiningType::Transparent),
  ((0,11,60),(0,11,60),JoiningType::Transparent),
  ((0,11,63),(0,11,63),JoiningType::Transparent),
  ((0,11,65),(0,11,68),JoiningType::Transparent),
  ((0,11,77),(0,11,77),JoiningType::Transparent),
  ((0,11,86),(0,11,86),JoiningType::Transparent),
  ((0,11,98),(0,11,99),JoiningType::Transparent),
  ((0,11,130),(0,11,130),JoiningType::Transparent),
  ((0,11,192),(0,11,192),JoiningType::Transparent),
  ((0,11,205),(0,11,205),JoiningType::Transparent),
  ((0,12,0),(0,12,0),JoiningType::Transparent),
  ((0,12,62),(0,12,64),JoiningType::Transparent),
  ((0,12,70),(0,12,72),JoiningType::Transparent),
  ((0,12,74),(0,12,77),JoiningType::Transparent),
  ((0,12,85),(0,12,86),JoiningType::Transparent),
  ((0,12,98),(0,12,99),JoiningType::Transparent),
  ((0,12,129),(0,12,129),JoiningType::Transparent),
  ((0,12,188),(0,12,188),JoiningType::Transparent),
  ((0,12,191),(0,12,191),JoiningType::Transparent),
  ((0,12,198),(0,12,198),JoiningType::Transparent),
  ((0,12,204),(0,12,205),JoiningType::Transparent),
  ((0,12,226),(0,12,227),JoiningType::Transparent),
  ((0,13,1),(0,13,1),JoiningType::Transparent),
  ((0,13,65),(0,13,68),JoiningType::Transparent),
  ((0,13,77),(0,13,77),JoiningType::Transparent),
  ((0,13,98),(0,13,99),JoiningType::Transparent),
  ((0,13,202),(0,13,202),JoiningType::Transparent),
  ((0,13,210),(0,13,212),JoiningType::Transparent),
  ((0,13,214),(0,13,214),JoiningType::Transparent),
  ((0,14,49),(0,14,49),JoiningType::Transparent),
  ((0,14,52),(0,14,58),JoiningType::Transparent),
  ((0,14,71),(0,14,78),JoiningType::Transparent),
  ((0,14,177),(0,14,177),JoiningType::Transparent),
  ((0,14,180),(0,14,185),JoiningType::Transparent),
  ((0,14,187),(0,14,188),JoiningType::Transparent),
  ((0,14,200),(0,14,205),JoiningType::Transparent),
  ((0,15,24),(0,15,25),JoiningType::Transparent),
  ((0,15,53),(0,15,53),JoiningType::Transparent),
  ((0,15,55),(0,15,55),JoiningType::Transparent),
  ((0,15,57),(0,15,57),JoiningType::Transparent),
  ((0,15,113),(0,15,126),JoiningType::Transparent),
  ((0,15,128),(0,15,132),JoiningType::Transparent),
  ((0,15,134),(0,15,135),JoiningType::Transparent),
  ((0,15,141),(0,15,151),JoiningType::Transparent),
  ((0,15,153),(0,15,188),JoiningType::Transparent),
  ((0,15,198),(0,15,198),JoiningType::Transparent),
  ((0,16,45),(0,16,48),JoiningType::Transparent),
  ((0,16,50),(0,16,55),JoiningType::Transparent),
  ((0,16,57),(0,16,58),JoiningType::Transparent),
  ((0,16,61),(0,16,62),JoiningType::Transparent),
  ((0,16,88),(0,16,89),JoiningType::Transparent),
  ((0,16,94),(0,16,96),JoiningType::Transparent),
  ((0,16,113),(0,16,116),JoiningType::Transparent),
  ((0,16,130),(0,16,130),JoiningType::Transparent),
  ((0,16,133),(0,16,134),JoiningType::Transparent),
  ((0,16,141),(0,16,141),JoiningType::Transparent),
  ((0,16,157),(0,16,157),JoiningType::Transparent),
  ((0,19,93),(0,19,95),JoiningType::Transparent),
  ((0,23,18),(0,23,20),JoiningType::Transparent),
  ((0,23,50),(0,23,52),JoiningType::Transparent),
  ((0,23,82),(0,23,83),JoiningType::Transparent),
  ((0,23,114),(0,23,115),JoiningType::Transparent),
  ((0,23,180),(0,23,181),JoiningType::Transparent),
  ((0,23,183),(0,23,189),JoiningType::Transparent),
  ((0,23,198),(0,23,198),JoiningType::Transparent),
  ((0,23,201),(0,23,211),JoiningType::Transparent),
  ((0,23,221),(0,23,221),JoiningType::Transparent),
  ((0,24,7),(0,24,7),JoiningType::DualJoining),
  ((0,24,10),(0,24,10),JoiningType::JoinCausing),
  ((0,24,11),(0,24,13),JoiningType::Transparent),
  ((0,24,32),(0,24,119),JoiningType::DualJoining),
  ((0,24,133),(0,24,134),JoiningType::Transparent),
  ((0,24,135),(0,24,168),JoiningType::DualJoining),
  ((0,24,169),(0,24,169),JoiningType::Transparent),
  ((0,24,170),(0,24,170),JoiningType::DualJoining),
  ((0,25,32),(0,25,34),JoiningType::Transparent),
  ((0,25,39),(0,25,40),JoiningType::Transparent),
  ((0,25,50),(0,25,50),JoiningType::Transparent),
  ((0,25,57),(0,25,59),JoiningType::Transparent),
  ((0,26,23),(0,26,24),JoiningType::Transparent),
  ((0,26,27),(0,26,27),JoiningType::Transparent),
  ((0,26,86),(0,26,86),JoiningType::Transparent),
  ((0,26,88),(0,26,94),JoiningType::Transparent),
  ((0,26,96),(0,26,96),JoiningType::Transparent),
  ((0,26,98),(0,26,98),JoiningType::Transparent),
  ((0,26,101),(0,26,108),JoiningType::Transparent),
  ((0,26,115),(0,26,124),JoiningType::Transparent),
  ((0,26,127),(0,26,127),JoiningType::Transparent),
  ((0,26,176),(0,26,190),JoiningType::Transparent),
  ((0,27,0),(0,27,3),JoiningType::Transparent),
  ((0,27,52),(0,27,52),JoiningType::Transparent),
  ((0,27,54),(0,27,58),JoiningType::Transparent),
  ((0,27,60),(0,27,60),JoiningType::Transparent),
  ((0,27,66),(0,27,66),JoiningType::Transparent),
  ((0,27,107),(0,27,115),JoiningType::Transparent),
  ((0,27,128),(0,27,129),JoiningType::Transparent),
  ((0,27,162),(0,27,165),JoiningType::Transparent),
  ((0,27,168),(0,27,169),JoiningType::Transparent),
  ((0,27,171),(0,27,173),JoiningType::Transparent),
  ((0,27,230),(0,27,230),JoiningType::Transparent),
  ((0,27,232),(0,27,233),JoiningType::Transparent),
  ((0,27,237),(0,27,237),JoiningType::Transparent),
  ((0,27,239),(0,27,241),JoiningType::Transparent),
  ((0,28,44),(0,28,51),JoiningType::Transparent),
  ((0,28,54),(0,28,55),JoiningType::Transparent),
  ((0,28,208),(0,28,210),JoiningType::Transparent),
  ((0,28,212),(0,28,224),JoiningType::Transparent),
  ((0,28,226),(0,28,232),JoiningType::Transparent),
  ((0,28,237),(0,28,237),JoiningType::Transparent),
  ((0,28,244),(0,28,244),JoiningType::Transparent),
  ((0,28,248),(0,28,249),JoiningType::Transparent),
  ((0,29,192),(0,29,245),JoiningType::Transparent),
  ((0,29,251),(0,29,255),JoiningType::Transparent),
  ((0,32,11),(0,32,11),JoiningType::Transparent),
  ((0,32,13),(0,32,13),JoiningType::JoinCausing),
  ((0,32,14),(0,32,15),JoiningType::Transparent),
  ((0,32,42),(0,32,46),JoiningType::Transparent),
  ((0,32,96),(0,32,100),JoiningType::Transparent),
  ((0,32,106),(0,32,111),JoiningType::Transparent),
  ((0,32,208),(0,32,240),JoiningType::Transparent),
  ((0,44,239),(0,44,241),JoiningType::Transparent),
  ((0,45,127),(0,45,127),JoiningType::Transparent),
  ((0,45,224),(0,45,255),JoiningType::Transparent),
  ((0,48,42),(0,48,45),JoiningType::Transparent),
  ((0,48,153),(0,48,154),JoiningType::Transparent),
  ((0,166,111),(0,166,114),JoiningType::Transparent),
  ((0,166,116),(0,166,125),JoiningType::Transparent),
  ((0,166,158),(0,166,159),JoiningType::Transparent),
  ((0,166,240),(0,166,241),JoiningType::Transparent),
  ((0,168,2),(0,168,2),JoiningType::Transparent),
  ((0,168,6),(0,168,6),JoiningType::Transparent),
  ((0,168,11),(0,168,11),JoiningType::Transparent),
  ((0,168,37),(0,168,38),JoiningType::Transparent),
  ((0,168,64),(0,168,113),JoiningType::DualJoining),
  ((0,168,114),(0,168,114),JoiningType::LeftJoining),
  ((0,168,196),(0,168,197),JoiningType::Transparent),
  ((0,168,224),(0,168,241),JoiningType::Transparent),
  ((0,169,38),(0,169,45),JoiningType::Transparent),
  ((0,169,71),(0,169,81),JoiningType::Transparent),
  ((0,169,128),(0,169,130),JoiningType::Transparent),
  ((0,169,179),(0,169,179),JoiningType::Transparent),
  ((0,169,182),(0,169,185),JoiningType::Transparent),
  ((0,169,188),(0,169,188),JoiningType::Transparent),
  ((0,169,229),(0,169,229),JoiningType::Transparent),
  ((0,170,41),(0,170,46),JoiningType::Transparent),
  ((0,170,49),(0,170,50),JoiningType::Transparent),
  ((0,170,53),(0,170,54),JoiningType::Transparent),
  ((0,170,67),(0,170,67),JoiningType::Transparent),
  ((0,170,76),(0,170,76),JoiningType::Transparent),
  ((0,170,124),(0,170,124),JoiningType::Transparent),
  ((0,170,176),(0,170,176),JoiningType::Transparent),
  ((0,170,178),(0,170,180),JoiningType::Transparent),
  ((0,170,183),(0,170,184),JoiningType::Transparent),
  ((0,170,190),(0,170,191),JoiningType::Transparent),
  ((0,170,193),(0,170,193),JoiningType::Transparent),
  ((0,170,236),(0,170,237),JoiningType::Transparent),
  ((0,170,246),(0,170,246),JoiningType::Transparent),
  ((0,171,229),(0,171,229),JoiningType::Transparent),
  ((0,171,232),(0,171,232),JoiningType::Transparent),
  ((0,171,237),(0,171,237),JoiningType::Transparent),
  ((0,251,30),(0,251,30),JoiningType::Transparent),
  ((0,254,0),(0,254,15),JoiningType::Transparent),
  ((0,254,32),(0,254,47),JoiningType::Transparent),
  ((0,254,255),(0,254,255),JoiningType::Transparent),
  ((0,255,249),(0,255,251),JoiningType::Transparent),
  ((1,1,253),(1,1,253),JoiningType::Transparent),
  ((1,2,224),(1,2,224),JoiningType::Transparent),
  ((1,3,118),(1,3,122),JoiningType::Transparent),
  ((1,10,1),(1,10,3),JoiningType::Transparent),
  ((1,10,5),(1,10,6),JoiningType::Transparent),
  ((1,10,12),(1,10,15),JoiningType::Transparent),
  ((1,10,56),(1,10,58),JoiningType::Transparent),
  ((1,10,63),(1,10,63),JoiningType::Transparent),
  ((1,10,192),(1,10,196),JoiningType::DualJoining),
  ((1,10,197),(1,10,197),JoiningType::RightJoining),
  ((1,10,199),(1,10,199),JoiningType::RightJoining),
  ((1,10,201),(1,10,202),JoiningType::RightJoining),
  ((1,10,205),(1,10,205),JoiningType::LeftJoining),
  ((1,10,206),(1,10,210),JoiningType::RightJoining),
  ((1,10,211),(1,10,214),JoiningType::DualJoining),
  ((1,10,215),(1,10,215),JoiningType::LeftJoining),
  ((1,10,216),(1,10,220),JoiningType::DualJoining),
  ((1,10,221),(1,10,221),JoiningType::RightJoining),
  ((1,10,222),(1,10,224),JoiningType::DualJoining),
  ((1,10,225),(1,10,225),JoiningType::RightJoining),
  ((1,10,228),(1,10,228),JoiningType::RightJoining),
  ((1,10,229),(1,10,230),JoiningType::Transparent),
  ((1,10,235),(1,10,238),JoiningType::DualJoining),
  ((1,10,239),(1,10,239),JoiningType::RightJoining),
  ((1,11,128),(1,11,128),JoiningType::DualJoining),
  ((1,11,129),(1,11,129),JoiningType::RightJoining),
  ((1,11,130),(1,11,130),JoiningType::DualJoining),
  ((1,11,131),(1,11,133),JoiningType::RightJoining),
  ((1,11,134),(1,11,136),JoiningType::DualJoining),
  ((1,11,137),(1,11,137),JoiningType::RightJoining),
  ((1,11,138),(1,11,139),JoiningType::DualJoining),
  ((1,11,140),(1,11,140),JoiningType::RightJoining),
  ((1,11,141),(1,11,141),JoiningType::DualJoining),
  ((1,11,142),(1,11,143),JoiningType::RightJoining),
  ((1,11,144),(1,11,144),JoiningType::DualJoining),
  ((1,11,145),(1,11,145),JoiningType::RightJoining),
  ((1,11,169),(1,11,172),JoiningType::RightJoining),
  ((1,11,173),(1,11,174),JoiningType::DualJoining),
  ((1,16,1),(1,16,1),JoiningType::Transparent),
  ((1,16,56),(1,16,70),JoiningType::Transparent),
  ((1,16,127),(1,16,129),JoiningType::Transparent),
  ((1,16,179),(1,16,182),JoiningType::Transparent),
  ((1,16,185),(1,16,186),JoiningType::Transparent),
  ((1,16,189),(1,16,189),JoiningType::Transparent),
  ((1,17,0),(1,17,2),JoiningType::Transparent),
  ((1,17,39),(1,17,43),JoiningType::Transparent),
  ((1,17,45),(1,17,52),JoiningType::Transparent),
  ((1,17,115),(1,17,115),JoiningType::Transparent),
  ((1,17,128),(1,17,129),JoiningType::Transparent),
  ((1,17,182),(1,17,190),JoiningType::Transparent),
  ((1,17,202),(1,17,204),JoiningType::Transparent),
  ((1,18,47),(1,18,49),JoiningType::Transparent),
  ((1,18,52),(1,18,52),JoiningType::Transparent),
  ((1,18,54),(1,18,55),JoiningType::Transparent),
  ((1,18,62),(1,18,62),JoiningType::Transparent),
  ((1,18,223),(1,18,223),JoiningType::Transparent),
  ((1,18,227),(1,18,234),JoiningType::Transparent),
  ((1,19,0),(1,19,1),JoiningType::Transparent),
  ((1,19,60),(1,19,60),JoiningType::Transparent),
  ((1,19,64),(1,19,64),JoiningType::Transparent),
  ((1,19,102),(1,19,108),JoiningType::Transparent),
  ((1,19,112),(1,19,116),JoiningType::Transparent),
  ((1,20,56),(1,20,63),JoiningType::Transparent),
  ((1,20,66),(1,20,68),JoiningType::Transparent),
  ((1,20,70),(1,20,70),JoiningType::Transparent),
  ((1,20,179),(1,20,184),JoiningType::Transparent),
  ((1,20,186),(1,20,186),JoiningType::Transparent),
  ((1,20,191),(1,20,192),JoiningType::Transparent),
  ((1,20,194),(1,20,195),JoiningType::Transparent),
  ((1,21,178),(1,21,181),JoiningType::Transparent),
  ((1,21,188),(1,21,189),JoiningType::Transparent),
  ((1,21,191),(1,21,192),JoiningType::Transparent),
  ((1,21,220),(1,21,221),JoiningType::Transparent),
  ((1,22,51),(1,22,58),JoiningType::Transparent),
  ((1,22,61),(1,22,61),JoiningType::Transparent),
  ((1,22,63),(1,22,64),JoiningType::Transparent),
  ((1,22,171),(1,22,171),JoiningType::Transparent),
  ((1,22,173),(1,22,173),JoiningType::Transparent),
  ((1,22,176),(1,22,181),JoiningType::Transparent),
  ((1,22,183),(1,22,183),JoiningType::Transparent),
  ((1,23,29),(1,23,31),JoiningType::Transparent),
  ((1,23,34),(1,23,37),JoiningType::Transparent),
  ((1,23,39),(1,23,43),JoiningType::Transparent),
  ((1,28,48),(1,28,54),JoiningType::Transparent),
  ((1,28,56),(1,28,61),JoiningType::Transparent),
  ((1,28,63),(1,28,63),JoiningType::Transparent),
  ((1,28,146),(1,28,167),JoiningType::Transparent),
  ((1,28,170),(1,28,176),JoiningType::Transparent),
  ((1,28,178),(1,28,179),JoiningType::Transparent),
  ((1,28,181),(1,28,182),JoiningType::Transparent),
  ((1,106,240),(1,106,244),JoiningType::Transparent),
  ((1,107,48),(1,107,54),JoiningType::Transparent),
  ((1,111,143),(1,111,146),JoiningType::Transparent),
  ((1,188,157),(1,188,158),JoiningType::Transparent),
  ((1,188,160),(1,188,163),JoiningType::Transparent),
  ((1,209,103),(1,209,105),JoiningType::Transparent),
  ((1,209,115),(1,209,130),JoiningType::Transparent),
  ((1,209,133),(1,209,139),JoiningType::Transparent),
  ((1,209,170),(1,209,173),JoiningType::Transparent),
  ((1,210,66),(1,210,68),JoiningType::Transparent),
  ((1,218,0),(1,218,54),JoiningType::Transparent),
  ((1,218,59),(1,218,108),JoiningType::Transparent),
  ((1,218,117),(1,218,117),JoiningType::Transparent),
  ((1,218,132),(1,218,132),JoiningType::Transparent),
  ((1,218,155),(1,218,159),JoiningType::Transparent),
  ((1,218,161),(1,218,175),JoiningType::Transparent),
  ((1,224,0),(1,224,6),JoiningType::Transparent),
  ((1,224,8),(1,224,24),JoiningType::Transparent),
  ((1,224,27),(1,224,33),JoiningType::Transparent),
  ((1,224,35),(1,224,36),JoiningType::Transparent),
  ((1,224,38),(1,224,42),JoiningType::Transparent),
  ((1,232,208),(1,232,214),JoiningType::Transparent),
  ((1,233,0),(1,233,67),JoiningType::DualJoining),
  ((1,233,68),(1,233,74),JoiningType::Transparent),
  ((14,0,1),(14,0,1),JoiningType::Transparent),
  ((14,0,32),(14,0,127),JoiningType::Transparent),
  ((14,1,0),(14,1,239),JoiningType::Transparent)
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum Script {
  Adlam, CaucasianAlbanian, Ahom, Arabic, ImperialAramaic, Armenian, Avestan,
  Balinese, Bamum, BassaVah, Batak, Bengali, Bhaiksuki, Bopomofo, Brahmi,
  Braille, Buginese, Buhid, Chakma, CanadianAboriginal, Carian, Cham, Cherokee,
  Coptic, Cypriot, Cyrillic, Devanagari, Deseret, Duployan, EgyptianHieroglyphs,
  Elbasan, Ethiopic, Georgian, Glagolitic, Gothic, Grantha, Greek, Gujarati,
  Gurmukhi, Hangul, Han, Hanunoo, Hatran, Hebrew, Hiragana,
  AnatolianHieroglyphs, PahawhHmong, KatakanaOrHiragana, OldHungarian,
  OldItalic, Javanese, KayahLi, Katakana, Kharoshthi, Khmer, Khojki, Kannada,
  Kaithi, TaiTham, Lao, Latin, Lepcha, Limbu, LinearA, LinearB, Lisu, Lycian,
  Lydian, Mahajani, Mandaic, Manichaean, Marchen, MendeKikakui, MeroiticCursive,
  MeroiticHieroglyphs, Malayalam, Modi, Mongolian, Mro, MeeteiMayek, Multani,
  Myanmar, OldNorthArabian, Nabataean, Newa, Nko, Ogham, OlChiki, OldTurkic,
  Oriya, Osage, Osmanya, Palmyrene, PauCinHau, OldPermic, PhagsPa,
  InscriptionalPahlavi, PsalterPahlavi, Phoenician, Miao, InscriptionalParthian,
  Rejang, Runic, Samaritan, OldSouthArabian, Saurashtra, SignWriting, Shavian,
  Sharada, Siddham, Khudawadi, Sinhala, SoraSompeng, Sundanese, SylotiNagri,
  Syriac, Tagbanwa, Takri, TaiLe, NewTaiLue, Tamil, Tangut, TaiViet, Telugu,
  Tifinagh, Tagalog, Thaana, Thai, Tibetan, Tirhuta, Ugaritic, Vai, WarangCiti,
  OldPersian, Cuneiform, Yi, Inherited, Common
}

pub static UCD_SCRIPT: &'static [((u8,u8,u8), (u8,u8,u8), Script)] = &[
  ((0,0,0),(0,0,64),Script::Common), ((0,0,65),(0,0,90),Script::Latin),
  ((0,0,91),(0,0,96),Script::Common), ((0,0,97),(0,0,122),Script::Latin),
  ((0,0,123),(0,0,169),Script::Common), ((0,0,170),(0,0,170),Script::Latin),
  ((0,0,171),(0,0,185),Script::Common), ((0,0,186),(0,0,186),Script::Latin),
  ((0,0,187),(0,0,191),Script::Common), ((0,0,192),(0,0,214),Script::Latin),
  ((0,0,215),(0,0,215),Script::Common), ((0,0,216),(0,0,246),Script::Latin),
  ((0,0,247),(0,0,247),Script::Common), ((0,0,248),(0,2,184),Script::Latin),
  ((0,2,185),(0,2,223),Script::Common), ((0,2,224),(0,2,228),Script::Latin),
  ((0,2,229),(0,2,233),Script::Common), ((0,2,234),(0,2,235),Script::Bopomofo),
  ((0,2,236),(0,2,255),Script::Common), ((0,3,0),(0,3,111),Script::Inherited),
  ((0,3,112),(0,3,115),Script::Greek), ((0,3,116),(0,3,116),Script::Common),
  ((0,3,117),(0,3,119),Script::Greek), ((0,3,122),(0,3,125),Script::Greek),
  ((0,3,126),(0,3,126),Script::Common), ((0,3,127),(0,3,127),Script::Greek),
  ((0,3,132),(0,3,132),Script::Greek), ((0,3,133),(0,3,133),Script::Common),
  ((0,3,134),(0,3,134),Script::Greek), ((0,3,135),(0,3,135),Script::Common),
  ((0,3,136),(0,3,138),Script::Greek), ((0,3,140),(0,3,140),Script::Greek),
  ((0,3,142),(0,3,161),Script::Greek), ((0,3,163),(0,3,225),Script::Greek),
  ((0,3,226),(0,3,239),Script::Coptic), ((0,3,240),(0,3,255),Script::Greek),
  ((0,4,0),(0,4,132),Script::Cyrillic), ((0,4,133),(0,4,134),Script::Inherited),
  ((0,4,135),(0,5,47),Script::Cyrillic), ((0,5,49),(0,5,86),Script::Armenian),
  ((0,5,89),(0,5,95),Script::Armenian), ((0,5,97),(0,5,135),Script::Armenian),
  ((0,5,137),(0,5,137),Script::Common), ((0,5,138),(0,5,138),Script::Armenian),
  ((0,5,141),(0,5,143),Script::Armenian), ((0,5,145),(0,5,199),Script::Hebrew),
  ((0,5,208),(0,5,234),Script::Hebrew), ((0,5,240),(0,5,244),Script::Hebrew),
  ((0,6,0),(0,6,4),Script::Arabic), ((0,6,5),(0,6,5),Script::Common),
  ((0,6,6),(0,6,11),Script::Arabic), ((0,6,12),(0,6,12),Script::Common),
  ((0,6,13),(0,6,26),Script::Arabic), ((0,6,27),(0,6,28),Script::Common),
  ((0,6,30),(0,6,30),Script::Arabic), ((0,6,31),(0,6,31),Script::Common),
  ((0,6,32),(0,6,63),Script::Arabic), ((0,6,64),(0,6,64),Script::Common),
  ((0,6,65),(0,6,74),Script::Arabic), ((0,6,75),(0,6,85),Script::Inherited),
  ((0,6,86),(0,6,111),Script::Arabic), ((0,6,112),(0,6,112),Script::Inherited),
  ((0,6,113),(0,6,220),Script::Arabic), ((0,6,221),(0,6,221),Script::Common),
  ((0,6,222),(0,6,255),Script::Arabic), ((0,7,0),(0,7,13),Script::Syriac),
  ((0,7,15),(0,7,74),Script::Syriac), ((0,7,77),(0,7,79),Script::Syriac),
  ((0,7,80),(0,7,127),Script::Arabic), ((0,7,128),(0,7,177),Script::Thaana),
  ((0,7,192),(0,7,250),Script::Nko), ((0,8,0),(0,8,45),Script::Samaritan),
  ((0,8,48),(0,8,62),Script::Samaritan), ((0,8,64),(0,8,91),Script::Mandaic),
  ((0,8,94),(0,8,94),Script::Mandaic), ((0,8,160),(0,8,180),Script::Arabic),
  ((0,8,182),(0,8,189),Script::Arabic), ((0,8,212),(0,8,225),Script::Arabic),
  ((0,8,226),(0,8,226),Script::Common), ((0,8,227),(0,8,255),Script::Arabic),
  ((0,9,0),(0,9,80),Script::Devanagari), ((0,9,81),(0,9,82),Script::Inherited),
  ((0,9,83),(0,9,99),Script::Devanagari), ((0,9,100),(0,9,101),Script::Common),
  ((0,9,102),(0,9,127),Script::Devanagari),
  ((0,9,128),(0,9,131),Script::Bengali), ((0,9,133),(0,9,140),Script::Bengali),
  ((0,9,143),(0,9,144),Script::Bengali), ((0,9,147),(0,9,168),Script::Bengali),
  ((0,9,170),(0,9,176),Script::Bengali), ((0,9,178),(0,9,178),Script::Bengali),
  ((0,9,182),(0,9,185),Script::Bengali), ((0,9,188),(0,9,196),Script::Bengali),
  ((0,9,199),(0,9,200),Script::Bengali), ((0,9,203),(0,9,206),Script::Bengali),
  ((0,9,215),(0,9,215),Script::Bengali), ((0,9,220),(0,9,221),Script::Bengali),
  ((0,9,223),(0,9,227),Script::Bengali), ((0,9,230),(0,9,251),Script::Bengali),
  ((0,10,1),(0,10,3),Script::Gurmukhi), ((0,10,5),(0,10,10),Script::Gurmukhi),
  ((0,10,15),(0,10,16),Script::Gurmukhi),
  ((0,10,19),(0,10,40),Script::Gurmukhi),
  ((0,10,42),(0,10,48),Script::Gurmukhi),
  ((0,10,50),(0,10,51),Script::Gurmukhi),
  ((0,10,53),(0,10,54),Script::Gurmukhi),
  ((0,10,56),(0,10,57),Script::Gurmukhi),
  ((0,10,60),(0,10,60),Script::Gurmukhi),
  ((0,10,62),(0,10,66),Script::Gurmukhi),
  ((0,10,71),(0,10,72),Script::Gurmukhi),
  ((0,10,75),(0,10,77),Script::Gurmukhi),
  ((0,10,81),(0,10,81),Script::Gurmukhi),
  ((0,10,89),(0,10,92),Script::Gurmukhi),
  ((0,10,94),(0,10,94),Script::Gurmukhi),
  ((0,10,102),(0,10,117),Script::Gurmukhi),
  ((0,10,129),(0,10,131),Script::Gujarati),
  ((0,10,133),(0,10,141),Script::Gujarati),
  ((0,10,143),(0,10,145),Script::Gujarati),
  ((0,10,147),(0,10,168),Script::Gujarati),
  ((0,10,170),(0,10,176),Script::Gujarati),
  ((0,10,178),(0,10,179),Script::Gujarati),
  ((0,10,181),(0,10,185),Script::Gujarati),
  ((0,10,188),(0,10,197),Script::Gujarati),
  ((0,10,199),(0,10,201),Script::Gujarati),
  ((0,10,203),(0,10,205),Script::Gujarati),
  ((0,10,208),(0,10,208),Script::Gujarati),
  ((0,10,224),(0,10,227),Script::Gujarati),
  ((0,10,230),(0,10,241),Script::Gujarati),
  ((0,10,249),(0,10,249),Script::Gujarati), ((0,11,1),(0,11,3),Script::Oriya),
  ((0,11,5),(0,11,12),Script::Oriya), ((0,11,15),(0,11,16),Script::Oriya),
  ((0,11,19),(0,11,40),Script::Oriya), ((0,11,42),(0,11,48),Script::Oriya),
  ((0,11,50),(0,11,51),Script::Oriya), ((0,11,53),(0,11,57),Script::Oriya),
  ((0,11,60),(0,11,68),Script::Oriya), ((0,11,71),(0,11,72),Script::Oriya),
  ((0,11,75),(0,11,77),Script::Oriya), ((0,11,86),(0,11,87),Script::Oriya),
  ((0,11,92),(0,11,93),Script::Oriya), ((0,11,95),(0,11,99),Script::Oriya),
  ((0,11,102),(0,11,119),Script::Oriya), ((0,11,130),(0,11,131),Script::Tamil),
  ((0,11,133),(0,11,138),Script::Tamil), ((0,11,142),(0,11,144),Script::Tamil),
  ((0,11,146),(0,11,149),Script::Tamil), ((0,11,153),(0,11,154),Script::Tamil),
  ((0,11,156),(0,11,156),Script::Tamil), ((0,11,158),(0,11,159),Script::Tamil),
  ((0,11,163),(0,11,164),Script::Tamil), ((0,11,168),(0,11,170),Script::Tamil),
  ((0,11,174),(0,11,185),Script::Tamil), ((0,11,190),(0,11,194),Script::Tamil),
  ((0,11,198),(0,11,200),Script::Tamil), ((0,11,202),(0,11,205),Script::Tamil),
  ((0,11,208),(0,11,208),Script::Tamil), ((0,11,215),(0,11,215),Script::Tamil),
  ((0,11,230),(0,11,250),Script::Tamil), ((0,12,0),(0,12,3),Script::Telugu),
  ((0,12,5),(0,12,12),Script::Telugu), ((0,12,14),(0,12,16),Script::Telugu),
  ((0,12,18),(0,12,40),Script::Telugu), ((0,12,42),(0,12,57),Script::Telugu),
  ((0,12,61),(0,12,68),Script::Telugu), ((0,12,70),(0,12,72),Script::Telugu),
  ((0,12,74),(0,12,77),Script::Telugu), ((0,12,85),(0,12,86),Script::Telugu),
  ((0,12,88),(0,12,90),Script::Telugu), ((0,12,96),(0,12,99),Script::Telugu),
  ((0,12,102),(0,12,111),Script::Telugu),
  ((0,12,120),(0,12,127),Script::Telugu),
  ((0,12,128),(0,12,131),Script::Kannada),
  ((0,12,133),(0,12,140),Script::Kannada),
  ((0,12,142),(0,12,144),Script::Kannada),
  ((0,12,146),(0,12,168),Script::Kannada),
  ((0,12,170),(0,12,179),Script::Kannada),
  ((0,12,181),(0,12,185),Script::Kannada),
  ((0,12,188),(0,12,196),Script::Kannada),
  ((0,12,198),(0,12,200),Script::Kannada),
  ((0,12,202),(0,12,205),Script::Kannada),
  ((0,12,213),(0,12,214),Script::Kannada),
  ((0,12,222),(0,12,222),Script::Kannada),
  ((0,12,224),(0,12,227),Script::Kannada),
  ((0,12,230),(0,12,239),Script::Kannada),
  ((0,12,241),(0,12,242),Script::Kannada),
  ((0,13,1),(0,13,3),Script::Malayalam), ((0,13,5),(0,13,12),Script::Malayalam),
  ((0,13,14),(0,13,16),Script::Malayalam),
  ((0,13,18),(0,13,58),Script::Malayalam),
  ((0,13,61),(0,13,68),Script::Malayalam),
  ((0,13,70),(0,13,72),Script::Malayalam),
  ((0,13,74),(0,13,79),Script::Malayalam),
  ((0,13,84),(0,13,99),Script::Malayalam),
  ((0,13,102),(0,13,127),Script::Malayalam),
  ((0,13,130),(0,13,131),Script::Sinhala),
  ((0,13,133),(0,13,150),Script::Sinhala),
  ((0,13,154),(0,13,177),Script::Sinhala),
  ((0,13,179),(0,13,187),Script::Sinhala),
  ((0,13,189),(0,13,189),Script::Sinhala),
  ((0,13,192),(0,13,198),Script::Sinhala),
  ((0,13,202),(0,13,202),Script::Sinhala),
  ((0,13,207),(0,13,212),Script::Sinhala),
  ((0,13,214),(0,13,214),Script::Sinhala),
  ((0,13,216),(0,13,223),Script::Sinhala),
  ((0,13,230),(0,13,239),Script::Sinhala),
  ((0,13,242),(0,13,244),Script::Sinhala), ((0,14,1),(0,14,58),Script::Thai),
  ((0,14,63),(0,14,63),Script::Common), ((0,14,64),(0,14,91),Script::Thai),
  ((0,14,129),(0,14,130),Script::Lao), ((0,14,132),(0,14,132),Script::Lao),
  ((0,14,135),(0,14,136),Script::Lao), ((0,14,138),(0,14,138),Script::Lao),
  ((0,14,141),(0,14,141),Script::Lao), ((0,14,148),(0,14,151),Script::Lao),
  ((0,14,153),(0,14,159),Script::Lao), ((0,14,161),(0,14,163),Script::Lao),
  ((0,14,165),(0,14,165),Script::Lao), ((0,14,167),(0,14,167),Script::Lao),
  ((0,14,170),(0,14,171),Script::Lao), ((0,14,173),(0,14,185),Script::Lao),
  ((0,14,187),(0,14,189),Script::Lao), ((0,14,192),(0,14,196),Script::Lao),
  ((0,14,198),(0,14,198),Script::Lao), ((0,14,200),(0,14,205),Script::Lao),
  ((0,14,208),(0,14,217),Script::Lao), ((0,14,220),(0,14,223),Script::Lao),
  ((0,15,0),(0,15,71),Script::Tibetan), ((0,15,73),(0,15,108),Script::Tibetan),
  ((0,15,113),(0,15,151),Script::Tibetan),
  ((0,15,153),(0,15,188),Script::Tibetan),
  ((0,15,190),(0,15,204),Script::Tibetan),
  ((0,15,206),(0,15,212),Script::Tibetan),
  ((0,15,213),(0,15,216),Script::Common),
  ((0,15,217),(0,15,218),Script::Tibetan),
  ((0,16,0),(0,16,159),Script::Myanmar),
  ((0,16,160),(0,16,197),Script::Georgian),
  ((0,16,199),(0,16,199),Script::Georgian),
  ((0,16,205),(0,16,205),Script::Georgian),
  ((0,16,208),(0,16,250),Script::Georgian),
  ((0,16,251),(0,16,251),Script::Common),
  ((0,16,252),(0,16,255),Script::Georgian),
  ((0,17,0),(0,17,255),Script::Hangul), ((0,18,0),(0,18,72),Script::Ethiopic),
  ((0,18,74),(0,18,77),Script::Ethiopic),
  ((0,18,80),(0,18,86),Script::Ethiopic),
  ((0,18,88),(0,18,88),Script::Ethiopic),
  ((0,18,90),(0,18,93),Script::Ethiopic),
  ((0,18,96),(0,18,136),Script::Ethiopic),
  ((0,18,138),(0,18,141),Script::Ethiopic),
  ((0,18,144),(0,18,176),Script::Ethiopic),
  ((0,18,178),(0,18,181),Script::Ethiopic),
  ((0,18,184),(0,18,190),Script::Ethiopic),
  ((0,18,192),(0,18,192),Script::Ethiopic),
  ((0,18,194),(0,18,197),Script::Ethiopic),
  ((0,18,200),(0,18,214),Script::Ethiopic),
  ((0,18,216),(0,19,16),Script::Ethiopic),
  ((0,19,18),(0,19,21),Script::Ethiopic),
  ((0,19,24),(0,19,90),Script::Ethiopic),
  ((0,19,93),(0,19,124),Script::Ethiopic),
  ((0,19,128),(0,19,153),Script::Ethiopic),
  ((0,19,160),(0,19,245),Script::Cherokee),
  ((0,19,248),(0,19,253),Script::Cherokee),
  ((0,20,0),(0,22,127),Script::CanadianAboriginal),
  ((0,22,128),(0,22,156),Script::Ogham), ((0,22,160),(0,22,234),Script::Runic),
  ((0,22,235),(0,22,237),Script::Common), ((0,22,238),(0,22,248),Script::Runic),
  ((0,23,0),(0,23,12),Script::Tagalog), ((0,23,14),(0,23,20),Script::Tagalog),
  ((0,23,32),(0,23,52),Script::Hanunoo), ((0,23,53),(0,23,54),Script::Common),
  ((0,23,64),(0,23,83),Script::Buhid), ((0,23,96),(0,23,108),Script::Tagbanwa),
  ((0,23,110),(0,23,112),Script::Tagbanwa),
  ((0,23,114),(0,23,115),Script::Tagbanwa),
  ((0,23,128),(0,23,221),Script::Khmer), ((0,23,224),(0,23,233),Script::Khmer),
  ((0,23,240),(0,23,249),Script::Khmer), ((0,24,0),(0,24,1),Script::Mongolian),
  ((0,24,2),(0,24,3),Script::Common), ((0,24,4),(0,24,4),Script::Mongolian),
  ((0,24,5),(0,24,5),Script::Common), ((0,24,6),(0,24,14),Script::Mongolian),
  ((0,24,16),(0,24,25),Script::Mongolian),
  ((0,24,32),(0,24,119),Script::Mongolian),
  ((0,24,128),(0,24,170),Script::Mongolian),
  ((0,24,176),(0,24,245),Script::CanadianAboriginal),
  ((0,25,0),(0,25,30),Script::Limbu), ((0,25,32),(0,25,43),Script::Limbu),
  ((0,25,48),(0,25,59),Script::Limbu), ((0,25,64),(0,25,64),Script::Limbu),
  ((0,25,68),(0,25,79),Script::Limbu), ((0,25,80),(0,25,109),Script::TaiLe),
  ((0,25,112),(0,25,116),Script::TaiLe),
  ((0,25,128),(0,25,171),Script::NewTaiLue),
  ((0,25,176),(0,25,201),Script::NewTaiLue),
  ((0,25,208),(0,25,218),Script::NewTaiLue),
  ((0,25,222),(0,25,223),Script::NewTaiLue),
  ((0,25,224),(0,25,255),Script::Khmer), ((0,26,0),(0,26,27),Script::Buginese),
  ((0,26,30),(0,26,31),Script::Buginese), ((0,26,32),(0,26,94),Script::TaiTham),
  ((0,26,96),(0,26,124),Script::TaiTham),
  ((0,26,127),(0,26,137),Script::TaiTham),
  ((0,26,144),(0,26,153),Script::TaiTham),
  ((0,26,160),(0,26,173),Script::TaiTham),
  ((0,26,176),(0,26,190),Script::Inherited),
  ((0,27,0),(0,27,75),Script::Balinese),
  ((0,27,80),(0,27,124),Script::Balinese),
  ((0,27,128),(0,27,191),Script::Sundanese),
  ((0,27,192),(0,27,243),Script::Batak), ((0,27,252),(0,27,255),Script::Batak),
  ((0,28,0),(0,28,55),Script::Lepcha), ((0,28,59),(0,28,73),Script::Lepcha),
  ((0,28,77),(0,28,79),Script::Lepcha), ((0,28,80),(0,28,127),Script::OlChiki),
  ((0,28,128),(0,28,136),Script::Cyrillic),
  ((0,28,192),(0,28,199),Script::Sundanese),
  ((0,28,208),(0,28,210),Script::Inherited),
  ((0,28,211),(0,28,211),Script::Common),
  ((0,28,212),(0,28,224),Script::Inherited),
  ((0,28,225),(0,28,225),Script::Common),
  ((0,28,226),(0,28,232),Script::Inherited),
  ((0,28,233),(0,28,236),Script::Common),
  ((0,28,237),(0,28,237),Script::Inherited),
  ((0,28,238),(0,28,243),Script::Common),
  ((0,28,244),(0,28,244),Script::Inherited),
  ((0,28,245),(0,28,246),Script::Common),
  ((0,28,248),(0,28,249),Script::Inherited), ((0,29,0),(0,29,37),Script::Latin),
  ((0,29,38),(0,29,42),Script::Greek), ((0,29,43),(0,29,43),Script::Cyrillic),
  ((0,29,44),(0,29,92),Script::Latin), ((0,29,93),(0,29,97),Script::Greek),
  ((0,29,98),(0,29,101),Script::Latin), ((0,29,102),(0,29,106),Script::Greek),
  ((0,29,107),(0,29,119),Script::Latin),
  ((0,29,120),(0,29,120),Script::Cyrillic),
  ((0,29,121),(0,29,190),Script::Latin), ((0,29,191),(0,29,191),Script::Greek),
  ((0,29,192),(0,29,245),Script::Inherited),
  ((0,29,251),(0,29,255),Script::Inherited),
  ((0,30,0),(0,30,255),Script::Latin), ((0,31,0),(0,31,21),Script::Greek),
  ((0,31,24),(0,31,29),Script::Greek), ((0,31,32),(0,31,69),Script::Greek),
  ((0,31,72),(0,31,77),Script::Greek), ((0,31,80),(0,31,87),Script::Greek),
  ((0,31,89),(0,31,89),Script::Greek), ((0,31,91),(0,31,91),Script::Greek),
  ((0,31,93),(0,31,93),Script::Greek), ((0,31,95),(0,31,125),Script::Greek),
  ((0,31,128),(0,31,180),Script::Greek), ((0,31,182),(0,31,196),Script::Greek),
  ((0,31,198),(0,31,211),Script::Greek), ((0,31,214),(0,31,219),Script::Greek),
  ((0,31,221),(0,31,239),Script::Greek), ((0,31,242),(0,31,244),Script::Greek),
  ((0,31,246),(0,31,254),Script::Greek), ((0,32,0),(0,32,11),Script::Common),
  ((0,32,12),(0,32,13),Script::Inherited),
  ((0,32,14),(0,32,100),Script::Common), ((0,32,102),(0,32,112),Script::Common),
  ((0,32,113),(0,32,113),Script::Latin), ((0,32,116),(0,32,126),Script::Common),
  ((0,32,127),(0,32,127),Script::Latin), ((0,32,128),(0,32,142),Script::Common),
  ((0,32,144),(0,32,156),Script::Latin), ((0,32,160),(0,32,190),Script::Common),
  ((0,32,208),(0,32,240),Script::Inherited),
  ((0,33,0),(0,33,37),Script::Common), ((0,33,38),(0,33,38),Script::Greek),
  ((0,33,39),(0,33,41),Script::Common), ((0,33,42),(0,33,43),Script::Latin),
  ((0,33,44),(0,33,49),Script::Common), ((0,33,50),(0,33,50),Script::Latin),
  ((0,33,51),(0,33,77),Script::Common), ((0,33,78),(0,33,78),Script::Latin),
  ((0,33,79),(0,33,95),Script::Common), ((0,33,96),(0,33,136),Script::Latin),
  ((0,33,137),(0,33,139),Script::Common),
  ((0,33,144),(0,35,254),Script::Common), ((0,36,0),(0,36,38),Script::Common),
  ((0,36,64),(0,36,74),Script::Common), ((0,36,96),(0,39,255),Script::Common),
  ((0,40,0),(0,40,255),Script::Braille), ((0,41,0),(0,43,115),Script::Common),
  ((0,43,118),(0,43,149),Script::Common),
  ((0,43,152),(0,43,185),Script::Common),
  ((0,43,189),(0,43,200),Script::Common),
  ((0,43,202),(0,43,209),Script::Common),
  ((0,43,236),(0,43,239),Script::Common),
  ((0,44,0),(0,44,46),Script::Glagolitic),
  ((0,44,48),(0,44,94),Script::Glagolitic),
  ((0,44,96),(0,44,127),Script::Latin), ((0,44,128),(0,44,243),Script::Coptic),
  ((0,44,249),(0,44,255),Script::Coptic), ((0,45,0),(0,45,37),Script::Georgian),
  ((0,45,39),(0,45,39),Script::Georgian),
  ((0,45,45),(0,45,45),Script::Georgian),
  ((0,45,48),(0,45,103),Script::Tifinagh),
  ((0,45,111),(0,45,112),Script::Tifinagh),
  ((0,45,127),(0,45,127),Script::Tifinagh),
  ((0,45,128),(0,45,150),Script::Ethiopic),
  ((0,45,160),(0,45,166),Script::Ethiopic),
  ((0,45,168),(0,45,174),Script::Ethiopic),
  ((0,45,176),(0,45,182),Script::Ethiopic),
  ((0,45,184),(0,45,190),Script::Ethiopic),
  ((0,45,192),(0,45,198),Script::Ethiopic),
  ((0,45,200),(0,45,206),Script::Ethiopic),
  ((0,45,208),(0,45,214),Script::Ethiopic),
  ((0,45,216),(0,45,222),Script::Ethiopic),
  ((0,45,224),(0,45,255),Script::Cyrillic), ((0,46,0),(0,46,68),Script::Common),
  ((0,46,128),(0,46,153),Script::Han), ((0,46,155),(0,46,243),Script::Han),
  ((0,47,0),(0,47,213),Script::Han), ((0,47,240),(0,47,251),Script::Common),
  ((0,48,0),(0,48,4),Script::Common), ((0,48,5),(0,48,5),Script::Han),
  ((0,48,6),(0,48,6),Script::Common), ((0,48,7),(0,48,7),Script::Han),
  ((0,48,8),(0,48,32),Script::Common), ((0,48,33),(0,48,41),Script::Han),
  ((0,48,42),(0,48,45),Script::Inherited), ((0,48,46),(0,48,47),Script::Hangul),
  ((0,48,48),(0,48,55),Script::Common), ((0,48,56),(0,48,59),Script::Han),
  ((0,48,60),(0,48,63),Script::Common), ((0,48,65),(0,48,150),Script::Hiragana),
  ((0,48,153),(0,48,154),Script::Inherited),
  ((0,48,155),(0,48,156),Script::Common),
  ((0,48,157),(0,48,159),Script::Hiragana),
  ((0,48,160),(0,48,160),Script::Common),
  ((0,48,161),(0,48,250),Script::Katakana),
  ((0,48,251),(0,48,252),Script::Common),
  ((0,48,253),(0,48,255),Script::Katakana),
  ((0,49,5),(0,49,45),Script::Bopomofo), ((0,49,49),(0,49,142),Script::Hangul),
  ((0,49,144),(0,49,159),Script::Common),
  ((0,49,160),(0,49,186),Script::Bopomofo),
  ((0,49,192),(0,49,227),Script::Common),
  ((0,49,240),(0,49,255),Script::Katakana), ((0,50,0),(0,50,30),Script::Hangul),
  ((0,50,32),(0,50,95),Script::Common), ((0,50,96),(0,50,126),Script::Hangul),
  ((0,50,127),(0,50,207),Script::Common),
  ((0,50,208),(0,50,254),Script::Katakana),
  ((0,51,0),(0,51,87),Script::Katakana), ((0,51,88),(0,51,255),Script::Common),
  ((0,52,0),(0,77,181),Script::Han), ((0,77,192),(0,77,255),Script::Common),
  ((0,78,0),(0,159,213),Script::Han), ((0,160,0),(0,164,140),Script::Yi),
  ((0,164,144),(0,164,198),Script::Yi), ((0,164,208),(0,164,255),Script::Lisu),
  ((0,165,0),(0,166,43),Script::Vai), ((0,166,64),(0,166,159),Script::Cyrillic),
  ((0,166,160),(0,166,247),Script::Bamum),
  ((0,167,0),(0,167,33),Script::Common), ((0,167,34),(0,167,135),Script::Latin),
  ((0,167,136),(0,167,138),Script::Common),
  ((0,167,139),(0,167,174),Script::Latin),
  ((0,167,176),(0,167,183),Script::Latin),
  ((0,167,247),(0,167,255),Script::Latin),
  ((0,168,0),(0,168,43),Script::SylotiNagri),
  ((0,168,48),(0,168,57),Script::Common),
  ((0,168,64),(0,168,119),Script::PhagsPa),
  ((0,168,128),(0,168,197),Script::Saurashtra),
  ((0,168,206),(0,168,217),Script::Saurashtra),
  ((0,168,224),(0,168,253),Script::Devanagari),
  ((0,169,0),(0,169,45),Script::KayahLi),
  ((0,169,46),(0,169,46),Script::Common),
  ((0,169,47),(0,169,47),Script::KayahLi),
  ((0,169,48),(0,169,83),Script::Rejang),
  ((0,169,95),(0,169,95),Script::Rejang),
  ((0,169,96),(0,169,124),Script::Hangul),
  ((0,169,128),(0,169,205),Script::Javanese),
  ((0,169,207),(0,169,207),Script::Common),
  ((0,169,208),(0,169,217),Script::Javanese),
  ((0,169,222),(0,169,223),Script::Javanese),
  ((0,169,224),(0,169,254),Script::Myanmar),
  ((0,170,0),(0,170,54),Script::Cham), ((0,170,64),(0,170,77),Script::Cham),
  ((0,170,80),(0,170,89),Script::Cham), ((0,170,92),(0,170,95),Script::Cham),
  ((0,170,96),(0,170,127),Script::Myanmar),
  ((0,170,128),(0,170,194),Script::TaiViet),
  ((0,170,219),(0,170,223),Script::TaiViet),
  ((0,170,224),(0,170,246),Script::MeeteiMayek),
  ((0,171,1),(0,171,6),Script::Ethiopic),
  ((0,171,9),(0,171,14),Script::Ethiopic),
  ((0,171,17),(0,171,22),Script::Ethiopic),
  ((0,171,32),(0,171,38),Script::Ethiopic),
  ((0,171,40),(0,171,46),Script::Ethiopic),
  ((0,171,48),(0,171,90),Script::Latin), ((0,171,91),(0,171,91),Script::Common),
  ((0,171,92),(0,171,100),Script::Latin),
  ((0,171,101),(0,171,101),Script::Greek),
  ((0,171,112),(0,171,191),Script::Cherokee),
  ((0,171,192),(0,171,237),Script::MeeteiMayek),
  ((0,171,240),(0,171,249),Script::MeeteiMayek),
  ((0,172,0),(0,215,163),Script::Hangul),
  ((0,215,176),(0,215,198),Script::Hangul),
  ((0,215,203),(0,215,251),Script::Hangul), ((0,249,0),(0,250,109),Script::Han),
  ((0,250,112),(0,250,217),Script::Han), ((0,251,0),(0,251,6),Script::Latin),
  ((0,251,19),(0,251,23),Script::Armenian),
  ((0,251,29),(0,251,54),Script::Hebrew),
  ((0,251,56),(0,251,60),Script::Hebrew),
  ((0,251,62),(0,251,62),Script::Hebrew),
  ((0,251,64),(0,251,65),Script::Hebrew),
  ((0,251,67),(0,251,68),Script::Hebrew),
  ((0,251,70),(0,251,79),Script::Hebrew),
  ((0,251,80),(0,251,193),Script::Arabic),
  ((0,251,211),(0,253,61),Script::Arabic),
  ((0,253,62),(0,253,63),Script::Common),
  ((0,253,80),(0,253,143),Script::Arabic),
  ((0,253,146),(0,253,199),Script::Arabic),
  ((0,253,240),(0,253,253),Script::Arabic),
  ((0,254,0),(0,254,15),Script::Inherited),
  ((0,254,16),(0,254,25),Script::Common),
  ((0,254,32),(0,254,45),Script::Inherited),
  ((0,254,46),(0,254,47),Script::Cyrillic),
  ((0,254,48),(0,254,82),Script::Common),
  ((0,254,84),(0,254,102),Script::Common),
  ((0,254,104),(0,254,107),Script::Common),
  ((0,254,112),(0,254,116),Script::Arabic),
  ((0,254,118),(0,254,252),Script::Arabic),
  ((0,254,255),(0,254,255),Script::Common),
  ((0,255,1),(0,255,32),Script::Common), ((0,255,33),(0,255,58),Script::Latin),
  ((0,255,59),(0,255,64),Script::Common), ((0,255,65),(0,255,90),Script::Latin),
  ((0,255,91),(0,255,101),Script::Common),
  ((0,255,102),(0,255,111),Script::Katakana),
  ((0,255,112),(0,255,112),Script::Common),
  ((0,255,113),(0,255,157),Script::Katakana),
  ((0,255,158),(0,255,159),Script::Common),
  ((0,255,160),(0,255,190),Script::Hangul),
  ((0,255,194),(0,255,199),Script::Hangul),
  ((0,255,202),(0,255,207),Script::Hangul),
  ((0,255,210),(0,255,215),Script::Hangul),
  ((0,255,218),(0,255,220),Script::Hangul),
  ((0,255,224),(0,255,230),Script::Common),
  ((0,255,232),(0,255,238),Script::Common),
  ((0,255,249),(0,255,253),Script::Common), ((1,0,0),(1,0,11),Script::LinearB),
  ((1,0,13),(1,0,38),Script::LinearB), ((1,0,40),(1,0,58),Script::LinearB),
  ((1,0,60),(1,0,61),Script::LinearB), ((1,0,63),(1,0,77),Script::LinearB),
  ((1,0,80),(1,0,93),Script::LinearB), ((1,0,128),(1,0,250),Script::LinearB),
  ((1,1,0),(1,1,2),Script::Common), ((1,1,7),(1,1,51),Script::Common),
  ((1,1,55),(1,1,63),Script::Common), ((1,1,64),(1,1,142),Script::Greek),
  ((1,1,144),(1,1,155),Script::Common), ((1,1,160),(1,1,160),Script::Greek),
  ((1,1,208),(1,1,252),Script::Common), ((1,1,253),(1,1,253),Script::Inherited),
  ((1,2,128),(1,2,156),Script::Lycian), ((1,2,160),(1,2,208),Script::Carian),
  ((1,2,224),(1,2,224),Script::Inherited), ((1,2,225),(1,2,251),Script::Common),
  ((1,3,0),(1,3,35),Script::OldItalic), ((1,3,48),(1,3,74),Script::Gothic),
  ((1,3,80),(1,3,122),Script::OldPermic),
  ((1,3,128),(1,3,157),Script::Ugaritic),
  ((1,3,159),(1,3,159),Script::Ugaritic),
  ((1,3,160),(1,3,195),Script::OldPersian),
  ((1,3,200),(1,3,213),Script::OldPersian), ((1,4,0),(1,4,79),Script::Deseret),
  ((1,4,80),(1,4,127),Script::Shavian), ((1,4,128),(1,4,157),Script::Osmanya),
  ((1,4,160),(1,4,169),Script::Osmanya), ((1,4,176),(1,4,211),Script::Osage),
  ((1,4,216),(1,4,251),Script::Osage), ((1,5,0),(1,5,39),Script::Elbasan),
  ((1,5,48),(1,5,99),Script::CaucasianAlbanian),
  ((1,5,111),(1,5,111),Script::CaucasianAlbanian),
  ((1,6,0),(1,7,54),Script::LinearA), ((1,7,64),(1,7,85),Script::LinearA),
  ((1,7,96),(1,7,103),Script::LinearA), ((1,8,0),(1,8,5),Script::Cypriot),
  ((1,8,8),(1,8,8),Script::Cypriot), ((1,8,10),(1,8,53),Script::Cypriot),
  ((1,8,55),(1,8,56),Script::Cypriot), ((1,8,60),(1,8,60),Script::Cypriot),
  ((1,8,63),(1,8,63),Script::Cypriot),
  ((1,8,64),(1,8,85),Script::ImperialAramaic),
  ((1,8,87),(1,8,95),Script::ImperialAramaic),
  ((1,8,96),(1,8,127),Script::Palmyrene),
  ((1,8,128),(1,8,158),Script::Nabataean),
  ((1,8,167),(1,8,175),Script::Nabataean), ((1,8,224),(1,8,242),Script::Hatran),
  ((1,8,244),(1,8,245),Script::Hatran), ((1,8,251),(1,8,255),Script::Hatran),
  ((1,9,0),(1,9,27),Script::Phoenician), ((1,9,31),(1,9,31),Script::Phoenician),
  ((1,9,32),(1,9,57),Script::Lydian), ((1,9,63),(1,9,63),Script::Lydian),
  ((1,9,128),(1,9,159),Script::MeroiticHieroglyphs),
  ((1,9,160),(1,9,183),Script::MeroiticCursive),
  ((1,9,188),(1,9,207),Script::MeroiticCursive),
  ((1,9,210),(1,9,255),Script::MeroiticCursive),
  ((1,10,0),(1,10,3),Script::Kharoshthi),
  ((1,10,5),(1,10,6),Script::Kharoshthi),
  ((1,10,12),(1,10,19),Script::Kharoshthi),
  ((1,10,21),(1,10,23),Script::Kharoshthi),
  ((1,10,25),(1,10,51),Script::Kharoshthi),
  ((1,10,56),(1,10,58),Script::Kharoshthi),
  ((1,10,63),(1,10,71),Script::Kharoshthi),
  ((1,10,80),(1,10,88),Script::Kharoshthi),
  ((1,10,96),(1,10,127),Script::OldSouthArabian),
  ((1,10,128),(1,10,159),Script::OldNorthArabian),
  ((1,10,192),(1,10,230),Script::Manichaean),
  ((1,10,235),(1,10,246),Script::Manichaean),
  ((1,11,0),(1,11,53),Script::Avestan), ((1,11,57),(1,11,63),Script::Avestan),
  ((1,11,64),(1,11,85),Script::InscriptionalParthian),
  ((1,11,88),(1,11,95),Script::InscriptionalParthian),
  ((1,11,96),(1,11,114),Script::InscriptionalPahlavi),
  ((1,11,120),(1,11,127),Script::InscriptionalPahlavi),
  ((1,11,128),(1,11,145),Script::PsalterPahlavi),
  ((1,11,153),(1,11,156),Script::PsalterPahlavi),
  ((1,11,169),(1,11,175),Script::PsalterPahlavi),
  ((1,12,0),(1,12,72),Script::OldTurkic),
  ((1,12,128),(1,12,178),Script::OldHungarian),
  ((1,12,192),(1,12,242),Script::OldHungarian),
  ((1,12,250),(1,12,255),Script::OldHungarian),
  ((1,14,96),(1,14,126),Script::Arabic), ((1,16,0),(1,16,77),Script::Brahmi),
  ((1,16,82),(1,16,111),Script::Brahmi), ((1,16,127),(1,16,127),Script::Brahmi),
  ((1,16,128),(1,16,193),Script::Kaithi),
  ((1,16,208),(1,16,232),Script::SoraSompeng),
  ((1,16,240),(1,16,249),Script::SoraSompeng),
  ((1,17,0),(1,17,52),Script::Chakma), ((1,17,54),(1,17,67),Script::Chakma),
  ((1,17,80),(1,17,118),Script::Mahajani),
  ((1,17,128),(1,17,205),Script::Sharada),
  ((1,17,208),(1,17,223),Script::Sharada),
  ((1,17,225),(1,17,244),Script::Sinhala), ((1,18,0),(1,18,17),Script::Khojki),
  ((1,18,19),(1,18,62),Script::Khojki), ((1,18,128),(1,18,134),Script::Multani),
  ((1,18,136),(1,18,136),Script::Multani),
  ((1,18,138),(1,18,141),Script::Multani),
  ((1,18,143),(1,18,157),Script::Multani),
  ((1,18,159),(1,18,169),Script::Multani),
  ((1,18,176),(1,18,234),Script::Khudawadi),
  ((1,18,240),(1,18,249),Script::Khudawadi),
  ((1,19,0),(1,19,3),Script::Grantha), ((1,19,5),(1,19,12),Script::Grantha),
  ((1,19,15),(1,19,16),Script::Grantha), ((1,19,19),(1,19,40),Script::Grantha),
  ((1,19,42),(1,19,48),Script::Grantha), ((1,19,50),(1,19,51),Script::Grantha),
  ((1,19,53),(1,19,57),Script::Grantha), ((1,19,60),(1,19,68),Script::Grantha),
  ((1,19,71),(1,19,72),Script::Grantha), ((1,19,75),(1,19,77),Script::Grantha),
  ((1,19,80),(1,19,80),Script::Grantha), ((1,19,87),(1,19,87),Script::Grantha),
  ((1,19,93),(1,19,99),Script::Grantha),
  ((1,19,102),(1,19,108),Script::Grantha),
  ((1,19,112),(1,19,116),Script::Grantha), ((1,20,0),(1,20,89),Script::Newa),
  ((1,20,91),(1,20,91),Script::Newa), ((1,20,93),(1,20,93),Script::Newa),
  ((1,20,128),(1,20,199),Script::Tirhuta),
  ((1,20,208),(1,20,217),Script::Tirhuta),
  ((1,21,128),(1,21,181),Script::Siddham),
  ((1,21,184),(1,21,221),Script::Siddham), ((1,22,0),(1,22,68),Script::Modi),
  ((1,22,80),(1,22,89),Script::Modi), ((1,22,96),(1,22,108),Script::Mongolian),
  ((1,22,128),(1,22,183),Script::Takri), ((1,22,192),(1,22,201),Script::Takri),
  ((1,23,0),(1,23,25),Script::Ahom), ((1,23,29),(1,23,43),Script::Ahom),
  ((1,23,48),(1,23,63),Script::Ahom),
  ((1,24,160),(1,24,242),Script::WarangCiti),
  ((1,24,255),(1,24,255),Script::WarangCiti),
  ((1,26,192),(1,26,248),Script::PauCinHau),
  ((1,28,0),(1,28,8),Script::Bhaiksuki),
  ((1,28,10),(1,28,54),Script::Bhaiksuki),
  ((1,28,56),(1,28,69),Script::Bhaiksuki),
  ((1,28,80),(1,28,108),Script::Bhaiksuki),
  ((1,28,112),(1,28,143),Script::Marchen),
  ((1,28,146),(1,28,167),Script::Marchen),
  ((1,28,169),(1,28,182),Script::Marchen),
  ((1,32,0),(1,35,153),Script::Cuneiform),
  ((1,36,0),(1,36,110),Script::Cuneiform),
  ((1,36,112),(1,36,116),Script::Cuneiform),
  ((1,36,128),(1,37,67),Script::Cuneiform),
  ((1,48,0),(1,52,46),Script::EgyptianHieroglyphs),
  ((1,68,0),(1,70,70),Script::AnatolianHieroglyphs),
  ((1,104,0),(1,106,56),Script::Bamum), ((1,106,64),(1,106,94),Script::Mro),
  ((1,106,96),(1,106,105),Script::Mro), ((1,106,110),(1,106,111),Script::Mro),
  ((1,106,208),(1,106,237),Script::BassaVah),
  ((1,106,240),(1,106,245),Script::BassaVah),
  ((1,107,0),(1,107,69),Script::PahawhHmong),
  ((1,107,80),(1,107,89),Script::PahawhHmong),
  ((1,107,91),(1,107,97),Script::PahawhHmong),
  ((1,107,99),(1,107,119),Script::PahawhHmong),
  ((1,107,125),(1,107,143),Script::PahawhHmong),
  ((1,111,0),(1,111,68),Script::Miao), ((1,111,80),(1,111,126),Script::Miao),
  ((1,111,143),(1,111,159),Script::Miao),
  ((1,111,224),(1,111,224),Script::Tangut),
  ((1,112,0),(1,135,236),Script::Tangut),
  ((1,136,0),(1,138,242),Script::Tangut),
  ((1,176,0),(1,176,0),Script::Katakana),
  ((1,176,1),(1,176,1),Script::Hiragana),
  ((1,188,0),(1,188,106),Script::Duployan),
  ((1,188,112),(1,188,124),Script::Duployan),
  ((1,188,128),(1,188,136),Script::Duployan),
  ((1,188,144),(1,188,153),Script::Duployan),
  ((1,188,156),(1,188,159),Script::Duployan),
  ((1,188,160),(1,188,163),Script::Common),
  ((1,208,0),(1,208,245),Script::Common), ((1,209,0),(1,209,38),Script::Common),
  ((1,209,41),(1,209,102),Script::Common),
  ((1,209,103),(1,209,105),Script::Inherited),
  ((1,209,106),(1,209,122),Script::Common),
  ((1,209,123),(1,209,130),Script::Inherited),
  ((1,209,131),(1,209,132),Script::Common),
  ((1,209,133),(1,209,139),Script::Inherited),
  ((1,209,140),(1,209,169),Script::Common),
  ((1,209,170),(1,209,173),Script::Inherited),
  ((1,209,174),(1,209,232),Script::Common),
  ((1,210,0),(1,210,69),Script::Greek), ((1,211,0),(1,211,86),Script::Common),
  ((1,211,96),(1,211,113),Script::Common),
  ((1,212,0),(1,212,84),Script::Common),
  ((1,212,86),(1,212,156),Script::Common),
  ((1,212,158),(1,212,159),Script::Common),
  ((1,212,162),(1,212,162),Script::Common),
  ((1,212,165),(1,212,166),Script::Common),
  ((1,212,169),(1,212,172),Script::Common),
  ((1,212,174),(1,212,185),Script::Common),
  ((1,212,187),(1,212,187),Script::Common),
  ((1,212,189),(1,212,195),Script::Common),
  ((1,212,197),(1,213,5),Script::Common), ((1,213,7),(1,213,10),Script::Common),
  ((1,213,13),(1,213,20),Script::Common),
  ((1,213,22),(1,213,28),Script::Common),
  ((1,213,30),(1,213,57),Script::Common),
  ((1,213,59),(1,213,62),Script::Common),
  ((1,213,64),(1,213,68),Script::Common),
  ((1,213,70),(1,213,70),Script::Common),
  ((1,213,74),(1,213,80),Script::Common),
  ((1,213,82),(1,214,165),Script::Common),
  ((1,214,168),(1,215,203),Script::Common),
  ((1,215,206),(1,215,255),Script::Common),
  ((1,216,0),(1,218,139),Script::SignWriting),
  ((1,218,155),(1,218,159),Script::SignWriting),
  ((1,218,161),(1,218,175),Script::SignWriting),
  ((1,224,0),(1,224,6),Script::Glagolitic),
  ((1,224,8),(1,224,24),Script::Glagolitic),
  ((1,224,27),(1,224,33),Script::Glagolitic),
  ((1,224,35),(1,224,36),Script::Glagolitic),
  ((1,224,38),(1,224,42),Script::Glagolitic),
  ((1,232,0),(1,232,196),Script::MendeKikakui),
  ((1,232,199),(1,232,214),Script::MendeKikakui),
  ((1,233,0),(1,233,74),Script::Adlam), ((1,233,80),(1,233,89),Script::Adlam),
  ((1,233,94),(1,233,95),Script::Adlam), ((1,238,0),(1,238,3),Script::Arabic),
  ((1,238,5),(1,238,31),Script::Arabic), ((1,238,33),(1,238,34),Script::Arabic),
  ((1,238,36),(1,238,36),Script::Arabic),
  ((1,238,39),(1,238,39),Script::Arabic),
  ((1,238,41),(1,238,50),Script::Arabic),
  ((1,238,52),(1,238,55),Script::Arabic),
  ((1,238,57),(1,238,57),Script::Arabic),
  ((1,238,59),(1,238,59),Script::Arabic),
  ((1,238,66),(1,238,66),Script::Arabic),
  ((1,238,71),(1,238,71),Script::Arabic),
  ((1,238,73),(1,238,73),Script::Arabic),
  ((1,238,75),(1,238,75),Script::Arabic),
  ((1,238,77),(1,238,79),Script::Arabic),
  ((1,238,81),(1,238,82),Script::Arabic),
  ((1,238,84),(1,238,84),Script::Arabic),
  ((1,238,87),(1,238,87),Script::Arabic),
  ((1,238,89),(1,238,89),Script::Arabic),
  ((1,238,91),(1,238,91),Script::Arabic),
  ((1,238,93),(1,238,93),Script::Arabic),
  ((1,238,95),(1,238,95),Script::Arabic),
  ((1,238,97),(1,238,98),Script::Arabic),
  ((1,238,100),(1,238,100),Script::Arabic),
  ((1,238,103),(1,238,106),Script::Arabic),
  ((1,238,108),(1,238,114),Script::Arabic),
  ((1,238,116),(1,238,119),Script::Arabic),
  ((1,238,121),(1,238,124),Script::Arabic),
  ((1,238,126),(1,238,126),Script::Arabic),
  ((1,238,128),(1,238,137),Script::Arabic),
  ((1,238,139),(1,238,155),Script::Arabic),
  ((1,238,161),(1,238,163),Script::Arabic),
  ((1,238,165),(1,238,169),Script::Arabic),
  ((1,238,171),(1,238,187),Script::Arabic),
  ((1,238,240),(1,238,241),Script::Arabic),
  ((1,240,0),(1,240,43),Script::Common),
  ((1,240,48),(1,240,147),Script::Common),
  ((1,240,160),(1,240,174),Script::Common),
  ((1,240,177),(1,240,191),Script::Common),
  ((1,240,193),(1,240,207),Script::Common),
  ((1,240,209),(1,240,245),Script::Common),
  ((1,241,0),(1,241,12),Script::Common), ((1,241,16),(1,241,46),Script::Common),
  ((1,241,48),(1,241,107),Script::Common),
  ((1,241,112),(1,241,172),Script::Common),
  ((1,241,230),(1,241,255),Script::Common),
  ((1,242,0),(1,242,0),Script::Hiragana), ((1,242,1),(1,242,2),Script::Common),
  ((1,242,16),(1,242,59),Script::Common),
  ((1,242,64),(1,242,72),Script::Common),
  ((1,242,80),(1,242,81),Script::Common),
  ((1,243,0),(1,246,210),Script::Common),
  ((1,246,224),(1,246,236),Script::Common),
  ((1,246,240),(1,246,246),Script::Common),
  ((1,247,0),(1,247,115),Script::Common),
  ((1,247,128),(1,247,212),Script::Common),
  ((1,248,0),(1,248,11),Script::Common), ((1,248,16),(1,248,71),Script::Common),
  ((1,248,80),(1,248,89),Script::Common),
  ((1,248,96),(1,248,135),Script::Common),
  ((1,248,144),(1,248,173),Script::Common),
  ((1,249,16),(1,249,30),Script::Common),
  ((1,249,32),(1,249,39),Script::Common),
  ((1,249,48),(1,249,48),Script::Common),
  ((1,249,51),(1,249,62),Script::Common),
  ((1,249,64),(1,249,75),Script::Common),
  ((1,249,80),(1,249,94),Script::Common),
  ((1,249,128),(1,249,145),Script::Common),
  ((1,249,192),(1,249,192),Script::Common), ((2,0,0),(2,166,214),Script::Han),
  ((2,167,0),(2,183,52),Script::Han), ((2,183,64),(2,184,29),Script::Han),
  ((2,184,32),(2,206,161),Script::Han), ((2,248,0),(2,250,29),Script::Han),
  ((14,0,1),(14,0,1),Script::Common), ((14,0,32),(14,0,127),Script::Common),
  ((14,1,0),(14,1,239),Script::Inherited)
];

pub static UCD_SCRIPT_MAP: &'static [&'static [Script]] = &[
  &[Script::Adlam], &[Script::CaucasianAlbanian], &[Script::Ahom],
  &[Script::Arabic], &[Script::ImperialAramaic], &[Script::Armenian],
  &[Script::Avestan], &[Script::Balinese], &[Script::Bamum],
  &[Script::BassaVah], &[Script::Batak], &[Script::Bengali],
  &[Script::Bhaiksuki], &[Script::Bopomofo], &[Script::Brahmi],
  &[Script::Braille], &[Script::Buginese], &[Script::Buhid], &[Script::Chakma],
  &[Script::CanadianAboriginal], &[Script::Carian], &[Script::Cham],
  &[Script::Cherokee], &[Script::Coptic], &[Script::Cypriot],
  &[Script::Cyrillic], &[Script::Devanagari], &[Script::Deseret],
  &[Script::Duployan], &[Script::EgyptianHieroglyphs], &[Script::Elbasan],
  &[Script::Ethiopic], &[Script::Georgian], &[Script::Glagolitic],
  &[Script::Gothic], &[Script::Grantha], &[Script::Greek], &[Script::Gujarati],
  &[Script::Gurmukhi], &[Script::Hangul], &[Script::Han], &[Script::Hanunoo],
  &[Script::Hatran], &[Script::Hebrew], &[Script::Hiragana],
  &[Script::AnatolianHieroglyphs], &[Script::PahawhHmong],
  &[Script::KatakanaOrHiragana], &[Script::OldHungarian], &[Script::OldItalic],
  &[Script::Javanese], &[Script::KayahLi], &[Script::Katakana],
  &[Script::Kharoshthi], &[Script::Khmer], &[Script::Khojki],
  &[Script::Kannada], &[Script::Kaithi], &[Script::TaiTham], &[Script::Lao],
  &[Script::Latin], &[Script::Lepcha], &[Script::Limbu], &[Script::LinearA],
  &[Script::LinearB], &[Script::Lisu], &[Script::Lycian], &[Script::Lydian],
  &[Script::Mahajani], &[Script::Mandaic], &[Script::Manichaean],
  &[Script::Marchen], &[Script::MendeKikakui], &[Script::MeroiticCursive],
  &[Script::MeroiticHieroglyphs], &[Script::Malayalam], &[Script::Modi],
  &[Script::Mongolian], &[Script::Mro], &[Script::MeeteiMayek],
  &[Script::Multani], &[Script::Myanmar], &[Script::OldNorthArabian],
  &[Script::Nabataean], &[Script::Newa], &[Script::Nko], &[Script::Ogham],
  &[Script::OlChiki], &[Script::OldTurkic], &[Script::Oriya], &[Script::Osage],
  &[Script::Osmanya], &[Script::Palmyrene], &[Script::PauCinHau],
  &[Script::OldPermic], &[Script::PhagsPa], &[Script::InscriptionalPahlavi],
  &[Script::PsalterPahlavi], &[Script::Phoenician], &[Script::Miao],
  &[Script::InscriptionalParthian], &[Script::Rejang], &[Script::Runic],
  &[Script::Samaritan], &[Script::OldSouthArabian], &[Script::Saurashtra],
  &[Script::SignWriting], &[Script::Shavian], &[Script::Sharada],
  &[Script::Siddham], &[Script::Khudawadi], &[Script::Sinhala],
  &[Script::SoraSompeng], &[Script::Sundanese], &[Script::SylotiNagri],
  &[Script::Syriac], &[Script::Tagbanwa], &[Script::Takri], &[Script::TaiLe],
  &[Script::NewTaiLue], &[Script::Tamil], &[Script::Tangut], &[Script::TaiViet],
  &[Script::Telugu], &[Script::Tifinagh], &[Script::Tagalog], &[Script::Thaana],
  &[Script::Thai], &[Script::Tibetan], &[Script::Tirhuta], &[Script::Ugaritic],
  &[Script::Vai], &[Script::WarangCiti], &[Script::OldPersian],
  &[Script::Cuneiform], &[Script::Yi], &[Script::Inherited], &[Script::Common]
];

pub static UCD_SCRIPTEXT: &'static [((u8,u8,u8), &'static [Script])] = &[
  ((0,3,66), &[Script::Greek]), ((0,3,69), &[Script::Greek]), ((0,3,99),
  &[Script::Latin]), ((0,3,100), &[Script::Latin]), ((0,3,101),
  &[Script::Latin]), ((0,3,102), &[Script::Latin]), ((0,3,103),
  &[Script::Latin]), ((0,3,104), &[Script::Latin]), ((0,3,105),
  &[Script::Latin]), ((0,3,106), &[Script::Latin]), ((0,3,107),
  &[Script::Latin]), ((0,3,108), &[Script::Latin]), ((0,3,109),
  &[Script::Latin]), ((0,3,110), &[Script::Latin]), ((0,3,111),
  &[Script::Latin]), ((0,4,131), &[Script::Cyrillic, Script::OldPermic]),
  ((0,4,132), &[Script::Cyrillic, Script::Glagolitic]), ((0,4,133),
  &[Script::Cyrillic, Script::Latin]), ((0,4,134), &[Script::Cyrillic,
  Script::Latin]), ((0,4,135), &[Script::Cyrillic, Script::Glagolitic]),
  ((0,5,137), &[Script::Armenian, Script::Georgian]), ((0,6,12),
  &[Script::Arabic, Script::Syriac, Script::Thaana]), ((0,6,27),
  &[Script::Arabic, Script::Syriac, Script::Thaana]), ((0,6,31),
  &[Script::Arabic, Script::Syriac, Script::Thaana]), ((0,6,64),
  &[Script::Adlam, Script::Arabic, Script::Mandaic, Script::Manichaean,
  Script::PsalterPahlavi, Script::Syriac]), ((0,6,75), &[Script::Arabic,
  Script::Syriac]), ((0,6,76), &[Script::Arabic, Script::Syriac]), ((0,6,77),
  &[Script::Arabic, Script::Syriac]), ((0,6,78), &[Script::Arabic,
  Script::Syriac]), ((0,6,79), &[Script::Arabic, Script::Syriac]), ((0,6,80),
  &[Script::Arabic, Script::Syriac]), ((0,6,81), &[Script::Arabic,
  Script::Syriac]), ((0,6,82), &[Script::Arabic, Script::Syriac]), ((0,6,83),
  &[Script::Arabic, Script::Syriac]), ((0,6,84), &[Script::Arabic,
  Script::Syriac]), ((0,6,85), &[Script::Arabic, Script::Syriac]), ((0,6,96),
  &[Script::Arabic, Script::Thaana]), ((0,6,97), &[Script::Arabic,
  Script::Thaana]), ((0,6,98), &[Script::Arabic, Script::Thaana]), ((0,6,99),
  &[Script::Arabic, Script::Thaana]), ((0,6,100), &[Script::Arabic,
  Script::Thaana]), ((0,6,101), &[Script::Arabic, Script::Thaana]), ((0,6,102),
  &[Script::Arabic, Script::Thaana]), ((0,6,103), &[Script::Arabic,
  Script::Thaana]), ((0,6,104), &[Script::Arabic, Script::Thaana]), ((0,6,105),
  &[Script::Arabic, Script::Thaana]), ((0,6,112), &[Script::Arabic,
  Script::Syriac]), ((0,9,81), &[Script::Bengali, Script::Devanagari,
  Script::Grantha, Script::Gujarati, Script::Gurmukhi, Script::Kannada,
  Script::Latin, Script::Malayalam, Script::Oriya, Script::Sharada,
  Script::Tamil, Script::Telugu]), ((0,9,82), &[Script::Bengali,
  Script::Devanagari, Script::Grantha, Script::Gujarati, Script::Gurmukhi,
  Script::Kannada, Script::Latin, Script::Malayalam, Script::Oriya,
  Script::Tamil, Script::Telugu]), ((0,9,100), &[Script::Bengali,
  Script::Devanagari, Script::Grantha, Script::Gujarati, Script::Gurmukhi,
  Script::Kannada, Script::Mahajani, Script::Malayalam, Script::Oriya,
  Script::Khudawadi, Script::Sinhala, Script::SylotiNagri, Script::Takri,
  Script::Tamil, Script::Telugu, Script::Tirhuta]), ((0,9,101),
  &[Script::Bengali, Script::Devanagari, Script::Grantha, Script::Gujarati,
  Script::Gurmukhi, Script::Kannada, Script::Limbu, Script::Mahajani,
  Script::Malayalam, Script::Oriya, Script::Khudawadi, Script::Sinhala,
  Script::SylotiNagri, Script::Takri, Script::Tamil, Script::Telugu,
  Script::Tirhuta]), ((0,9,102), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,103), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,104), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,105), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,106), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,107), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,108), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,109), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,110), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,111), &[Script::Devanagari, Script::Kaithi,
  Script::Mahajani]), ((0,9,230), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,231), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,232), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,233), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,234), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,235), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,236), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,237), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,238), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,9,239), &[Script::Bengali, Script::Chakma,
  Script::SylotiNagri]), ((0,10,102), &[Script::Gurmukhi, Script::Multani]),
  ((0,10,103), &[Script::Gurmukhi, Script::Multani]), ((0,10,104),
  &[Script::Gurmukhi, Script::Multani]), ((0,10,105), &[Script::Gurmukhi,
  Script::Multani]), ((0,10,106), &[Script::Gurmukhi, Script::Multani]),
  ((0,10,107), &[Script::Gurmukhi, Script::Multani]), ((0,10,108),
  &[Script::Gurmukhi, Script::Multani]), ((0,10,109), &[Script::Gurmukhi,
  Script::Multani]), ((0,10,110), &[Script::Gurmukhi, Script::Multani]),
  ((0,10,111), &[Script::Gurmukhi, Script::Multani]), ((0,10,230),
  &[Script::Gujarati, Script::Khojki]), ((0,10,231), &[Script::Gujarati,
  Script::Khojki]), ((0,10,232), &[Script::Gujarati, Script::Khojki]),
  ((0,10,233), &[Script::Gujarati, Script::Khojki]), ((0,10,234),
  &[Script::Gujarati, Script::Khojki]), ((0,10,235), &[Script::Gujarati,
  Script::Khojki]), ((0,10,236), &[Script::Gujarati, Script::Khojki]),
  ((0,10,237), &[Script::Gujarati, Script::Khojki]), ((0,10,238),
  &[Script::Gujarati, Script::Khojki]), ((0,10,239), &[Script::Gujarati,
  Script::Khojki]), ((0,11,170), &[Script::Grantha, Script::Tamil]),
  ((0,11,181), &[Script::Grantha, Script::Tamil]), ((0,11,230),
  &[Script::Grantha, Script::Tamil]), ((0,11,231), &[Script::Grantha,
  Script::Tamil]), ((0,11,232), &[Script::Grantha, Script::Tamil]), ((0,11,233),
  &[Script::Grantha, Script::Tamil]), ((0,11,234), &[Script::Grantha,
  Script::Tamil]), ((0,11,235), &[Script::Grantha, Script::Tamil]), ((0,11,236),
  &[Script::Grantha, Script::Tamil]), ((0,11,237), &[Script::Grantha,
  Script::Tamil]), ((0,11,238), &[Script::Grantha, Script::Tamil]), ((0,11,239),
  &[Script::Grantha, Script::Tamil]), ((0,11,240), &[Script::Grantha,
  Script::Tamil]), ((0,11,241), &[Script::Grantha, Script::Tamil]), ((0,11,242),
  &[Script::Grantha, Script::Tamil]), ((0,16,64), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,65), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,66), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,67), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,68), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,69), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,70), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,71), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,72), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,73), &[Script::Chakma,
  Script::Myanmar, Script::TaiLe]), ((0,16,251), &[Script::Georgian,
  Script::Latin]), ((0,23,53), &[Script::Buhid, Script::Hanunoo,
  Script::Tagbanwa, Script::Tagalog]), ((0,23,54), &[Script::Buhid,
  Script::Hanunoo, Script::Tagbanwa, Script::Tagalog]), ((0,24,2),
  &[Script::Mongolian, Script::PhagsPa]), ((0,24,3), &[Script::Mongolian,
  Script::PhagsPa]), ((0,24,5), &[Script::Mongolian, Script::PhagsPa]),
  ((0,28,208), &[Script::Devanagari, Script::Grantha]), ((0,28,209),
  &[Script::Devanagari]), ((0,28,210), &[Script::Devanagari, Script::Grantha]),
  ((0,28,211), &[Script::Devanagari, Script::Grantha]), ((0,28,212),
  &[Script::Devanagari]), ((0,28,213), &[Script::Devanagari]), ((0,28,214),
  &[Script::Devanagari]), ((0,28,215), &[Script::Devanagari, Script::Sharada]),
  ((0,28,216), &[Script::Devanagari]), ((0,28,217), &[Script::Devanagari,
  Script::Sharada]), ((0,28,218), &[Script::Devanagari, Script::Kannada,
  Script::Malayalam, Script::Tamil, Script::Telugu]), ((0,28,219),
  &[Script::Devanagari]), ((0,28,220), &[Script::Devanagari, Script::Sharada]),
  ((0,28,221), &[Script::Devanagari, Script::Sharada]), ((0,28,222),
  &[Script::Devanagari]), ((0,28,223), &[Script::Devanagari]), ((0,28,224),
  &[Script::Devanagari, Script::Sharada]), ((0,28,225), &[Script::Devanagari]),
  ((0,28,226), &[Script::Devanagari]), ((0,28,227), &[Script::Devanagari]),
  ((0,28,228), &[Script::Devanagari]), ((0,28,229), &[Script::Devanagari]),
  ((0,28,230), &[Script::Devanagari]), ((0,28,231), &[Script::Devanagari]),
  ((0,28,232), &[Script::Devanagari]), ((0,28,233), &[Script::Devanagari]),
  ((0,28,234), &[Script::Devanagari]), ((0,28,235), &[Script::Devanagari]),
  ((0,28,236), &[Script::Devanagari]), ((0,28,237), &[Script::Devanagari]),
  ((0,28,238), &[Script::Devanagari]), ((0,28,239), &[Script::Devanagari]),
  ((0,28,240), &[Script::Devanagari]), ((0,28,241), &[Script::Devanagari]),
  ((0,28,242), &[Script::Devanagari, Script::Grantha]), ((0,28,243),
  &[Script::Devanagari, Script::Grantha]), ((0,28,244), &[Script::Devanagari,
  Script::Grantha]), ((0,28,245), &[Script::Devanagari, Script::Kannada]),
  ((0,28,246), &[Script::Devanagari]), ((0,28,248), &[Script::Devanagari,
  Script::Grantha]), ((0,28,249), &[Script::Devanagari, Script::Grantha]),
  ((0,29,192), &[Script::Greek]), ((0,29,193), &[Script::Greek]), ((0,32,240),
  &[Script::Devanagari, Script::Grantha, Script::Latin]), ((0,46,67),
  &[Script::Cyrillic, Script::Glagolitic]), ((0,48,1), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,2), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,3), &[Script::Bopomofo, Script::Hangul,
  Script::Han, Script::Hiragana, Script::Katakana]), ((0,48,6), &[Script::Han]),
  ((0,48,8), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,9), &[Script::Bopomofo, Script::Hangul,
  Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]), ((0,48,10),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,11), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,12), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,13), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,14), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,15), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,16), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,17), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,19), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,20), &[Script::Bopomofo, Script::Hangul,
  Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]), ((0,48,21),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,22), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,23), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,24), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,25), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,26), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,48,27), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,28), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana]), ((0,48,29),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,30), &[Script::Bopomofo, Script::Hangul,
  Script::Han, Script::Hiragana, Script::Katakana]), ((0,48,31),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,42), &[Script::Bopomofo, Script::Han]), ((0,48,43),
  &[Script::Bopomofo, Script::Han]), ((0,48,44), &[Script::Bopomofo,
  Script::Han]), ((0,48,45), &[Script::Bopomofo, Script::Han]), ((0,48,48),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,49), &[Script::Hiragana, Script::Katakana]),
  ((0,48,50), &[Script::Hiragana, Script::Katakana]), ((0,48,51),
  &[Script::Hiragana, Script::Katakana]), ((0,48,52), &[Script::Hiragana,
  Script::Katakana]), ((0,48,53), &[Script::Hiragana, Script::Katakana]),
  ((0,48,55), &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,60), &[Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,61), &[Script::Han, Script::Hiragana,
  Script::Katakana]), ((0,48,62), &[Script::Han]), ((0,48,63), &[Script::Han]),
  ((0,48,153), &[Script::Hiragana, Script::Katakana]), ((0,48,154),
  &[Script::Hiragana, Script::Katakana]), ((0,48,155), &[Script::Hiragana,
  Script::Katakana]), ((0,48,156), &[Script::Hiragana, Script::Katakana]),
  ((0,48,160), &[Script::Hiragana, Script::Katakana]), ((0,48,251),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,48,252), &[Script::Hiragana,
  Script::Katakana]), ((0,49,144), &[Script::Han]), ((0,49,145),
  &[Script::Han]), ((0,49,146), &[Script::Han]), ((0,49,147), &[Script::Han]),
  ((0,49,148), &[Script::Han]), ((0,49,149), &[Script::Han]), ((0,49,150),
  &[Script::Han]), ((0,49,151), &[Script::Han]), ((0,49,152), &[Script::Han]),
  ((0,49,153), &[Script::Han]), ((0,49,154), &[Script::Han]), ((0,49,155),
  &[Script::Han]), ((0,49,156), &[Script::Han]), ((0,49,157), &[Script::Han]),
  ((0,49,158), &[Script::Han]), ((0,49,159), &[Script::Han]), ((0,49,192),
  &[Script::Han]), ((0,49,193), &[Script::Han]), ((0,49,194), &[Script::Han]),
  ((0,49,195), &[Script::Han]), ((0,49,196), &[Script::Han]), ((0,49,197),
  &[Script::Han]), ((0,49,198), &[Script::Han]), ((0,49,199), &[Script::Han]),
  ((0,49,200), &[Script::Han]), ((0,49,201), &[Script::Han]), ((0,49,202),
  &[Script::Han]), ((0,49,203), &[Script::Han]), ((0,49,204), &[Script::Han]),
  ((0,49,205), &[Script::Han]), ((0,49,206), &[Script::Han]), ((0,49,207),
  &[Script::Han]), ((0,49,208), &[Script::Han]), ((0,49,209), &[Script::Han]),
  ((0,49,210), &[Script::Han]), ((0,49,211), &[Script::Han]), ((0,49,212),
  &[Script::Han]), ((0,49,213), &[Script::Han]), ((0,49,214), &[Script::Han]),
  ((0,49,215), &[Script::Han]), ((0,49,216), &[Script::Han]), ((0,49,217),
  &[Script::Han]), ((0,49,218), &[Script::Han]), ((0,49,219), &[Script::Han]),
  ((0,49,220), &[Script::Han]), ((0,49,221), &[Script::Han]), ((0,49,222),
  &[Script::Han]), ((0,49,223), &[Script::Han]), ((0,49,224), &[Script::Han]),
  ((0,49,225), &[Script::Han]), ((0,49,226), &[Script::Han]), ((0,49,227),
  &[Script::Han]), ((0,50,32), &[Script::Han]), ((0,50,33), &[Script::Han]),
  ((0,50,34), &[Script::Han]), ((0,50,35), &[Script::Han]), ((0,50,36),
  &[Script::Han]), ((0,50,37), &[Script::Han]), ((0,50,38), &[Script::Han]),
  ((0,50,39), &[Script::Han]), ((0,50,40), &[Script::Han]), ((0,50,41),
  &[Script::Han]), ((0,50,42), &[Script::Han]), ((0,50,43), &[Script::Han]),
  ((0,50,44), &[Script::Han]), ((0,50,45), &[Script::Han]), ((0,50,46),
  &[Script::Han]), ((0,50,47), &[Script::Han]), ((0,50,48), &[Script::Han]),
  ((0,50,49), &[Script::Han]), ((0,50,50), &[Script::Han]), ((0,50,51),
  &[Script::Han]), ((0,50,52), &[Script::Han]), ((0,50,53), &[Script::Han]),
  ((0,50,54), &[Script::Han]), ((0,50,55), &[Script::Han]), ((0,50,56),
  &[Script::Han]), ((0,50,57), &[Script::Han]), ((0,50,58), &[Script::Han]),
  ((0,50,59), &[Script::Han]), ((0,50,60), &[Script::Han]), ((0,50,61),
  &[Script::Han]), ((0,50,62), &[Script::Han]), ((0,50,63), &[Script::Han]),
  ((0,50,64), &[Script::Han]), ((0,50,65), &[Script::Han]), ((0,50,66),
  &[Script::Han]), ((0,50,67), &[Script::Han]), ((0,50,68), &[Script::Han]),
  ((0,50,69), &[Script::Han]), ((0,50,70), &[Script::Han]), ((0,50,71),
  &[Script::Han]), ((0,50,128), &[Script::Han]), ((0,50,129), &[Script::Han]),
  ((0,50,130), &[Script::Han]), ((0,50,131), &[Script::Han]), ((0,50,132),
  &[Script::Han]), ((0,50,133), &[Script::Han]), ((0,50,134), &[Script::Han]),
  ((0,50,135), &[Script::Han]), ((0,50,136), &[Script::Han]), ((0,50,137),
  &[Script::Han]), ((0,50,138), &[Script::Han]), ((0,50,139), &[Script::Han]),
  ((0,50,140), &[Script::Han]), ((0,50,141), &[Script::Han]), ((0,50,142),
  &[Script::Han]), ((0,50,143), &[Script::Han]), ((0,50,144), &[Script::Han]),
  ((0,50,145), &[Script::Han]), ((0,50,146), &[Script::Han]), ((0,50,147),
  &[Script::Han]), ((0,50,148), &[Script::Han]), ((0,50,149), &[Script::Han]),
  ((0,50,150), &[Script::Han]), ((0,50,151), &[Script::Han]), ((0,50,152),
  &[Script::Han]), ((0,50,153), &[Script::Han]), ((0,50,154), &[Script::Han]),
  ((0,50,155), &[Script::Han]), ((0,50,156), &[Script::Han]), ((0,50,157),
  &[Script::Han]), ((0,50,158), &[Script::Han]), ((0,50,159), &[Script::Han]),
  ((0,50,160), &[Script::Han]), ((0,50,161), &[Script::Han]), ((0,50,162),
  &[Script::Han]), ((0,50,163), &[Script::Han]), ((0,50,164), &[Script::Han]),
  ((0,50,165), &[Script::Han]), ((0,50,166), &[Script::Han]), ((0,50,167),
  &[Script::Han]), ((0,50,168), &[Script::Han]), ((0,50,169), &[Script::Han]),
  ((0,50,170), &[Script::Han]), ((0,50,171), &[Script::Han]), ((0,50,172),
  &[Script::Han]), ((0,50,173), &[Script::Han]), ((0,50,174), &[Script::Han]),
  ((0,50,175), &[Script::Han]), ((0,50,176), &[Script::Han]), ((0,50,192),
  &[Script::Han]), ((0,50,193), &[Script::Han]), ((0,50,194), &[Script::Han]),
  ((0,50,195), &[Script::Han]), ((0,50,196), &[Script::Han]), ((0,50,197),
  &[Script::Han]), ((0,50,198), &[Script::Han]), ((0,50,199), &[Script::Han]),
  ((0,50,200), &[Script::Han]), ((0,50,201), &[Script::Han]), ((0,50,202),
  &[Script::Han]), ((0,50,203), &[Script::Han]), ((0,51,88), &[Script::Han]),
  ((0,51,89), &[Script::Han]), ((0,51,90), &[Script::Han]), ((0,51,91),
  &[Script::Han]), ((0,51,92), &[Script::Han]), ((0,51,93), &[Script::Han]),
  ((0,51,94), &[Script::Han]), ((0,51,95), &[Script::Han]), ((0,51,96),
  &[Script::Han]), ((0,51,97), &[Script::Han]), ((0,51,98), &[Script::Han]),
  ((0,51,99), &[Script::Han]), ((0,51,100), &[Script::Han]), ((0,51,101),
  &[Script::Han]), ((0,51,102), &[Script::Han]), ((0,51,103), &[Script::Han]),
  ((0,51,104), &[Script::Han]), ((0,51,105), &[Script::Han]), ((0,51,106),
  &[Script::Han]), ((0,51,107), &[Script::Han]), ((0,51,108), &[Script::Han]),
  ((0,51,109), &[Script::Han]), ((0,51,110), &[Script::Han]), ((0,51,111),
  &[Script::Han]), ((0,51,112), &[Script::Han]), ((0,51,123), &[Script::Han]),
  ((0,51,124), &[Script::Han]), ((0,51,125), &[Script::Han]), ((0,51,126),
  &[Script::Han]), ((0,51,127), &[Script::Han]), ((0,51,224), &[Script::Han]),
  ((0,51,225), &[Script::Han]), ((0,51,226), &[Script::Han]), ((0,51,227),
  &[Script::Han]), ((0,51,228), &[Script::Han]), ((0,51,229), &[Script::Han]),
  ((0,51,230), &[Script::Han]), ((0,51,231), &[Script::Han]), ((0,51,232),
  &[Script::Han]), ((0,51,233), &[Script::Han]), ((0,51,234), &[Script::Han]),
  ((0,51,235), &[Script::Han]), ((0,51,236), &[Script::Han]), ((0,51,237),
  &[Script::Han]), ((0,51,238), &[Script::Han]), ((0,51,239), &[Script::Han]),
  ((0,51,240), &[Script::Han]), ((0,51,241), &[Script::Han]), ((0,51,242),
  &[Script::Han]), ((0,51,243), &[Script::Han]), ((0,51,244), &[Script::Han]),
  ((0,51,245), &[Script::Han]), ((0,51,246), &[Script::Han]), ((0,51,247),
  &[Script::Han]), ((0,51,248), &[Script::Han]), ((0,51,249), &[Script::Han]),
  ((0,51,250), &[Script::Han]), ((0,51,251), &[Script::Han]), ((0,51,252),
  &[Script::Han]), ((0,51,253), &[Script::Han]), ((0,51,254), &[Script::Han]),
  ((0,166,111), &[Script::Cyrillic, Script::Glagolitic]), ((0,168,48),
  &[Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Kannada,
  Script::Kaithi, Script::Mahajani, Script::Modi, Script::Khudawadi,
  Script::Takri, Script::Tirhuta]), ((0,168,49), &[Script::Devanagari,
  Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Kaithi,
  Script::Mahajani, Script::Modi, Script::Khudawadi, Script::Takri,
  Script::Tirhuta]), ((0,168,50), &[Script::Devanagari, Script::Gujarati,
  Script::Gurmukhi, Script::Kannada, Script::Kaithi, Script::Mahajani,
  Script::Modi, Script::Khudawadi, Script::Takri, Script::Tirhuta]),
  ((0,168,51), &[Script::Devanagari, Script::Gujarati, Script::Gurmukhi,
  Script::Kannada, Script::Kaithi, Script::Mahajani, Script::Modi,
  Script::Khudawadi, Script::Takri, Script::Tirhuta]), ((0,168,52),
  &[Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Kannada,
  Script::Kaithi, Script::Mahajani, Script::Modi, Script::Khudawadi,
  Script::Takri, Script::Tirhuta]), ((0,168,53), &[Script::Devanagari,
  Script::Gujarati, Script::Gurmukhi, Script::Kannada, Script::Kaithi,
  Script::Mahajani, Script::Modi, Script::Khudawadi, Script::Takri,
  Script::Tirhuta]), ((0,168,54), &[Script::Devanagari, Script::Gujarati,
  Script::Gurmukhi, Script::Kaithi, Script::Mahajani, Script::Modi,
  Script::Khudawadi, Script::Takri, Script::Tirhuta]), ((0,168,55),
  &[Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Kaithi,
  Script::Mahajani, Script::Modi, Script::Khudawadi, Script::Takri,
  Script::Tirhuta]), ((0,168,56), &[Script::Devanagari, Script::Gujarati,
  Script::Gurmukhi, Script::Kaithi, Script::Mahajani, Script::Modi,
  Script::Khudawadi, Script::Takri, Script::Tirhuta]), ((0,168,57),
  &[Script::Devanagari, Script::Gujarati, Script::Gurmukhi, Script::Kaithi,
  Script::Mahajani, Script::Modi, Script::Khudawadi, Script::Takri,
  Script::Tirhuta]), ((0,168,241), &[Script::Bengali, Script::Devanagari]),
  ((0,168,243), &[Script::Devanagari, Script::Tamil]), ((0,169,46),
  &[Script::KayahLi, Script::Latin, Script::Myanmar]), ((0,169,207),
  &[Script::Buginese, Script::Javanese]), ((0,253,242), &[Script::Arabic,
  Script::Thaana]), ((0,253,253), &[Script::Arabic, Script::Thaana]),
  ((0,254,69), &[Script::Bopomofo, Script::Hangul, Script::Han,
  Script::Hiragana, Script::Katakana]), ((0,254,70), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana]),
  ((0,255,97), &[Script::Bopomofo, Script::Hangul, Script::Han,
  Script::Hiragana, Script::Katakana, Script::Yi]), ((0,255,98),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,255,99), &[Script::Bopomofo,
  Script::Hangul, Script::Han, Script::Hiragana, Script::Katakana, Script::Yi]),
  ((0,255,100), &[Script::Bopomofo, Script::Hangul, Script::Han,
  Script::Hiragana, Script::Katakana, Script::Yi]), ((0,255,101),
  &[Script::Bopomofo, Script::Hangul, Script::Han, Script::Hiragana,
  Script::Katakana, Script::Yi]), ((0,255,112), &[Script::Hiragana,
  Script::Katakana]), ((0,255,158), &[Script::Hiragana, Script::Katakana]),
  ((0,255,159), &[Script::Hiragana, Script::Katakana]), ((1,1,0),
  &[Script::Cypriot, Script::LinearB]), ((1,1,1), &[Script::Cypriot,
  Script::LinearB]), ((1,1,2), &[Script::Cypriot, Script::LinearB]), ((1,1,7),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,8),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,9),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,10),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,11),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,12),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,13),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,14),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,15),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,16),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,17),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,18),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,19),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,20),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,21),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,22),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,23),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,24),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,25),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,26),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,27),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,28),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,29),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,30),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,31),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,32),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,33),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,34),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,35),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,36),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,37),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,38),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,39),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,40),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,41),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,42),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,43),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,44),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,45),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,46),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,47),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,48),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,49),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,50),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,51),
  &[Script::Cypriot, Script::LinearA, Script::LinearB]), ((1,1,55),
  &[Script::Cypriot, Script::LinearB]), ((1,1,56), &[Script::Cypriot,
  Script::LinearB]), ((1,1,57), &[Script::Cypriot, Script::LinearB]), ((1,1,58),
  &[Script::Cypriot, Script::LinearB]), ((1,1,59), &[Script::Cypriot,
  Script::LinearB]), ((1,1,60), &[Script::Cypriot, Script::LinearB]), ((1,1,61),
  &[Script::Cypriot, Script::LinearB]), ((1,1,62), &[Script::Cypriot,
  Script::LinearB]), ((1,1,63), &[Script::Cypriot, Script::LinearB]),
  ((1,2,224), &[Script::Arabic, Script::Coptic]), ((1,2,225), &[Script::Arabic,
  Script::Coptic]), ((1,2,226), &[Script::Arabic, Script::Coptic]), ((1,2,227),
  &[Script::Arabic, Script::Coptic]), ((1,2,228), &[Script::Arabic,
  Script::Coptic]), ((1,2,229), &[Script::Arabic, Script::Coptic]), ((1,2,230),
  &[Script::Arabic, Script::Coptic]), ((1,2,231), &[Script::Arabic,
  Script::Coptic]), ((1,2,232), &[Script::Arabic, Script::Coptic]), ((1,2,233),
  &[Script::Arabic, Script::Coptic]), ((1,2,234), &[Script::Arabic,
  Script::Coptic]), ((1,2,235), &[Script::Arabic, Script::Coptic]), ((1,2,236),
  &[Script::Arabic, Script::Coptic]), ((1,2,237), &[Script::Arabic,
  Script::Coptic]), ((1,2,238), &[Script::Arabic, Script::Coptic]), ((1,2,239),
  &[Script::Arabic, Script::Coptic]), ((1,2,240), &[Script::Arabic,
  Script::Coptic]), ((1,2,241), &[Script::Arabic, Script::Coptic]), ((1,2,242),
  &[Script::Arabic, Script::Coptic]), ((1,2,243), &[Script::Arabic,
  Script::Coptic]), ((1,2,244), &[Script::Arabic, Script::Coptic]), ((1,2,245),
  &[Script::Arabic, Script::Coptic]), ((1,2,246), &[Script::Arabic,
  Script::Coptic]), ((1,2,247), &[Script::Arabic, Script::Coptic]), ((1,2,248),
  &[Script::Arabic, Script::Coptic]), ((1,2,249), &[Script::Arabic,
  Script::Coptic]), ((1,2,250), &[Script::Arabic, Script::Coptic]), ((1,2,251),
  &[Script::Arabic, Script::Coptic]), ((1,19,3), &[Script::Grantha,
  Script::Tamil]), ((1,19,60), &[Script::Grantha, Script::Tamil]), ((1,188,160),
  &[Script::Duployan]), ((1,188,161), &[Script::Duployan]), ((1,188,162),
  &[Script::Duployan]), ((1,188,163), &[Script::Duployan]), ((1,211,96),
  &[Script::Han]), ((1,211,97), &[Script::Han]), ((1,211,98), &[Script::Han]),
  ((1,211,99), &[Script::Han]), ((1,211,100), &[Script::Han]), ((1,211,101),
  &[Script::Han]), ((1,211,102), &[Script::Han]), ((1,211,103), &[Script::Han]),
  ((1,211,104), &[Script::Han]), ((1,211,105), &[Script::Han]), ((1,211,106),
  &[Script::Han]), ((1,211,107), &[Script::Han]), ((1,211,108), &[Script::Han]),
  ((1,211,109), &[Script::Han]), ((1,211,110), &[Script::Han]), ((1,211,111),
  &[Script::Han]), ((1,211,112), &[Script::Han]), ((1,211,113), &[Script::Han]),
  ((1,242,80), &[Script::Han]), ((1,242,81), &[Script::Han])
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum HangulSyllableType {
  LeadingJamo, VowelJamo, TrailingJamo, LVSyllable, LVTSyllable
}

pub static UCD_JSN: &'static [((u8,u8,u8), &'static str)] = &[
  ((0,17,0),"G"), ((0,17,1),"GG"), ((0,17,2),"N"), ((0,17,3),"D"),
  ((0,17,4),"DD"), ((0,17,5),"R"), ((0,17,6),"M"), ((0,17,7),"B"),
  ((0,17,8),"BB"), ((0,17,9),"S"), ((0,17,10),"SS"), ((0,17,11),""),
  ((0,17,12),"J"), ((0,17,13),"JJ"), ((0,17,14),"C"), ((0,17,15),"K"),
  ((0,17,16),"T"), ((0,17,17),"P"), ((0,17,18),"H"), ((0,17,97),"A"),
  ((0,17,98),"AE"), ((0,17,99),"YA"), ((0,17,100),"YAE"), ((0,17,101),"EO"),
  ((0,17,102),"E"), ((0,17,103),"YEO"), ((0,17,104),"YE"), ((0,17,105),"O"),
  ((0,17,106),"WA"), ((0,17,107),"WAE"), ((0,17,108),"OE"), ((0,17,109),"YO"),
  ((0,17,110),"U"), ((0,17,111),"WEO"), ((0,17,112),"WE"), ((0,17,113),"WI"),
  ((0,17,114),"YU"), ((0,17,115),"EU"), ((0,17,116),"YI"), ((0,17,117),"I"),
  ((0,17,168),"G"), ((0,17,169),"GG"), ((0,17,170),"GS"), ((0,17,171),"N"),
  ((0,17,172),"NJ"), ((0,17,173),"NH"), ((0,17,174),"D"), ((0,17,175),"L"),
  ((0,17,176),"LG"), ((0,17,177),"LM"), ((0,17,178),"LB"), ((0,17,179),"LS"),
  ((0,17,180),"LT"), ((0,17,181),"LP"), ((0,17,182),"LH"), ((0,17,183),"M"),
  ((0,17,184),"B"), ((0,17,185),"BS"), ((0,17,186),"S"), ((0,17,187),"SS"),
  ((0,17,188),"NG"), ((0,17,189),"J"), ((0,17,190),"C"), ((0,17,191),"K"),
  ((0,17,192),"T"), ((0,17,193),"P"), ((0,17,194),"H")
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum IndicSyllabicCategory {
  ConsonantDead, ToneMark, ToneLetter, VowelDependent, NumberJoiner, Virama,
  ConsonantHeadLetter, Number, ConsonantMedial, ModifyingLetter,
  ConsonantSucceedingRepha, ConsonantFinal, Avagraha, Vowel, VowelIndependent,
  RegisterShifter, ConsonantKiller, Other, ConsonantSubjoined, Joiner, Nukta,
  GeminationMark, InvisibleStacker, ConsonantWithStacker, ConsonantPlaceholder,
  ConsonantPrecedingRepha, CantillationMark, PureKiller, NonJoiner,
  SyllableModifier, BrahmiJoiningNumber, Bindu, Visarga, Consonant,
  ConsonantPrefixed
}

pub static UCD_INSC: &'static [((u8,u8,u8), (u8,u8,u8), IndicSyllabicCategory)] = &[
  ((0,0,45),(0,0,45),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,0,48),(0,0,57),IndicSyllabicCategory::Number),
  ((0,0,160),(0,0,160),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,0,178),(0,0,179),IndicSyllabicCategory::SyllableModifier),
  ((0,0,215),(0,0,215),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,9,0),(0,9,2),IndicSyllabicCategory::Bindu),
  ((0,9,3),(0,9,3),IndicSyllabicCategory::Visarga),
  ((0,9,4),(0,9,20),IndicSyllabicCategory::VowelIndependent),
  ((0,9,21),(0,9,57),IndicSyllabicCategory::Consonant),
  ((0,9,58),(0,9,59),IndicSyllabicCategory::VowelDependent),
  ((0,9,60),(0,9,60),IndicSyllabicCategory::Nukta),
  ((0,9,61),(0,9,61),IndicSyllabicCategory::Avagraha),
  ((0,9,62),(0,9,76),IndicSyllabicCategory::VowelDependent),
  ((0,9,77),(0,9,77),IndicSyllabicCategory::Virama),
  ((0,9,78),(0,9,79),IndicSyllabicCategory::VowelDependent),
  ((0,9,81),(0,9,82),IndicSyllabicCategory::CantillationMark),
  ((0,9,85),(0,9,87),IndicSyllabicCategory::VowelDependent),
  ((0,9,88),(0,9,95),IndicSyllabicCategory::Consonant),
  ((0,9,96),(0,9,97),IndicSyllabicCategory::VowelIndependent),
  ((0,9,98),(0,9,99),IndicSyllabicCategory::VowelDependent),
  ((0,9,102),(0,9,111),IndicSyllabicCategory::Number),
  ((0,9,114),(0,9,119),IndicSyllabicCategory::VowelIndependent),
  ((0,9,120),(0,9,127),IndicSyllabicCategory::Consonant),
  ((0,9,129),(0,9,130),IndicSyllabicCategory::Bindu),
  ((0,9,131),(0,9,131),IndicSyllabicCategory::Visarga),
  ((0,9,133),(0,9,140),IndicSyllabicCategory::VowelIndependent),
  ((0,9,143),(0,9,144),IndicSyllabicCategory::VowelIndependent),
  ((0,9,147),(0,9,148),IndicSyllabicCategory::VowelIndependent),
  ((0,9,149),(0,9,168),IndicSyllabicCategory::Consonant),
  ((0,9,170),(0,9,176),IndicSyllabicCategory::Consonant),
  ((0,9,178),(0,9,178),IndicSyllabicCategory::Consonant),
  ((0,9,182),(0,9,185),IndicSyllabicCategory::Consonant),
  ((0,9,188),(0,9,188),IndicSyllabicCategory::Nukta),
  ((0,9,189),(0,9,189),IndicSyllabicCategory::Avagraha),
  ((0,9,190),(0,9,196),IndicSyllabicCategory::VowelDependent),
  ((0,9,199),(0,9,200),IndicSyllabicCategory::VowelDependent),
  ((0,9,203),(0,9,204),IndicSyllabicCategory::VowelDependent),
  ((0,9,205),(0,9,205),IndicSyllabicCategory::Virama),
  ((0,9,206),(0,9,206),IndicSyllabicCategory::ConsonantDead),
  ((0,9,215),(0,9,215),IndicSyllabicCategory::VowelDependent),
  ((0,9,220),(0,9,221),IndicSyllabicCategory::Consonant),
  ((0,9,223),(0,9,223),IndicSyllabicCategory::Consonant),
  ((0,9,224),(0,9,225),IndicSyllabicCategory::VowelIndependent),
  ((0,9,226),(0,9,227),IndicSyllabicCategory::VowelDependent),
  ((0,9,230),(0,9,239),IndicSyllabicCategory::Number),
  ((0,9,240),(0,9,241),IndicSyllabicCategory::Consonant),
  ((0,10,1),(0,10,2),IndicSyllabicCategory::Bindu),
  ((0,10,3),(0,10,3),IndicSyllabicCategory::Visarga),
  ((0,10,5),(0,10,10),IndicSyllabicCategory::VowelIndependent),
  ((0,10,15),(0,10,16),IndicSyllabicCategory::VowelIndependent),
  ((0,10,19),(0,10,20),IndicSyllabicCategory::VowelIndependent),
  ((0,10,21),(0,10,40),IndicSyllabicCategory::Consonant),
  ((0,10,42),(0,10,48),IndicSyllabicCategory::Consonant),
  ((0,10,50),(0,10,51),IndicSyllabicCategory::Consonant),
  ((0,10,53),(0,10,54),IndicSyllabicCategory::Consonant),
  ((0,10,56),(0,10,57),IndicSyllabicCategory::Consonant),
  ((0,10,60),(0,10,60),IndicSyllabicCategory::Nukta),
  ((0,10,62),(0,10,66),IndicSyllabicCategory::VowelDependent),
  ((0,10,71),(0,10,72),IndicSyllabicCategory::VowelDependent),
  ((0,10,75),(0,10,76),IndicSyllabicCategory::VowelDependent),
  ((0,10,77),(0,10,77),IndicSyllabicCategory::Virama),
  ((0,10,89),(0,10,92),IndicSyllabicCategory::Consonant),
  ((0,10,94),(0,10,94),IndicSyllabicCategory::Consonant),
  ((0,10,102),(0,10,111),IndicSyllabicCategory::Number),
  ((0,10,112),(0,10,112),IndicSyllabicCategory::Bindu),
  ((0,10,113),(0,10,113),IndicSyllabicCategory::GeminationMark),
  ((0,10,114),(0,10,115),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,10,117),(0,10,117),IndicSyllabicCategory::ConsonantMedial),
  ((0,10,129),(0,10,130),IndicSyllabicCategory::Bindu),
  ((0,10,131),(0,10,131),IndicSyllabicCategory::Visarga),
  ((0,10,133),(0,10,141),IndicSyllabicCategory::VowelIndependent),
  ((0,10,143),(0,10,145),IndicSyllabicCategory::VowelIndependent),
  ((0,10,147),(0,10,148),IndicSyllabicCategory::VowelIndependent),
  ((0,10,149),(0,10,168),IndicSyllabicCategory::Consonant),
  ((0,10,170),(0,10,176),IndicSyllabicCategory::Consonant),
  ((0,10,178),(0,10,179),IndicSyllabicCategory::Consonant),
  ((0,10,181),(0,10,185),IndicSyllabicCategory::Consonant),
  ((0,10,188),(0,10,188),IndicSyllabicCategory::Nukta),
  ((0,10,189),(0,10,189),IndicSyllabicCategory::Avagraha),
  ((0,10,190),(0,10,197),IndicSyllabicCategory::VowelDependent),
  ((0,10,199),(0,10,201),IndicSyllabicCategory::VowelDependent),
  ((0,10,203),(0,10,204),IndicSyllabicCategory::VowelDependent),
  ((0,10,205),(0,10,205),IndicSyllabicCategory::Virama),
  ((0,10,224),(0,10,225),IndicSyllabicCategory::VowelIndependent),
  ((0,10,226),(0,10,227),IndicSyllabicCategory::VowelDependent),
  ((0,10,230),(0,10,239),IndicSyllabicCategory::Number),
  ((0,10,249),(0,10,249),IndicSyllabicCategory::Consonant),
  ((0,11,1),(0,11,2),IndicSyllabicCategory::Bindu),
  ((0,11,3),(0,11,3),IndicSyllabicCategory::Visarga),
  ((0,11,5),(0,11,12),IndicSyllabicCategory::VowelIndependent),
  ((0,11,15),(0,11,16),IndicSyllabicCategory::VowelIndependent),
  ((0,11,19),(0,11,20),IndicSyllabicCategory::VowelIndependent),
  ((0,11,21),(0,11,40),IndicSyllabicCategory::Consonant),
  ((0,11,42),(0,11,48),IndicSyllabicCategory::Consonant),
  ((0,11,50),(0,11,51),IndicSyllabicCategory::Consonant),
  ((0,11,53),(0,11,57),IndicSyllabicCategory::Consonant),
  ((0,11,60),(0,11,60),IndicSyllabicCategory::Nukta),
  ((0,11,61),(0,11,61),IndicSyllabicCategory::Avagraha),
  ((0,11,62),(0,11,68),IndicSyllabicCategory::VowelDependent),
  ((0,11,71),(0,11,72),IndicSyllabicCategory::VowelDependent),
  ((0,11,75),(0,11,76),IndicSyllabicCategory::VowelDependent),
  ((0,11,77),(0,11,77),IndicSyllabicCategory::Virama),
  ((0,11,86),(0,11,87),IndicSyllabicCategory::VowelDependent),
  ((0,11,92),(0,11,93),IndicSyllabicCategory::Consonant),
  ((0,11,95),(0,11,95),IndicSyllabicCategory::Consonant),
  ((0,11,96),(0,11,97),IndicSyllabicCategory::VowelIndependent),
  ((0,11,98),(0,11,99),IndicSyllabicCategory::VowelDependent),
  ((0,11,102),(0,11,111),IndicSyllabicCategory::Number),
  ((0,11,113),(0,11,113),IndicSyllabicCategory::Consonant),
  ((0,11,130),(0,11,130),IndicSyllabicCategory::Bindu),
  ((0,11,131),(0,11,131),IndicSyllabicCategory::ModifyingLetter),
  ((0,11,133),(0,11,138),IndicSyllabicCategory::VowelIndependent),
  ((0,11,142),(0,11,144),IndicSyllabicCategory::VowelIndependent),
  ((0,11,146),(0,11,148),IndicSyllabicCategory::VowelIndependent),
  ((0,11,149),(0,11,149),IndicSyllabicCategory::Consonant),
  ((0,11,153),(0,11,154),IndicSyllabicCategory::Consonant),
  ((0,11,156),(0,11,156),IndicSyllabicCategory::Consonant),
  ((0,11,158),(0,11,159),IndicSyllabicCategory::Consonant),
  ((0,11,163),(0,11,164),IndicSyllabicCategory::Consonant),
  ((0,11,168),(0,11,170),IndicSyllabicCategory::Consonant),
  ((0,11,174),(0,11,185),IndicSyllabicCategory::Consonant),
  ((0,11,190),(0,11,194),IndicSyllabicCategory::VowelDependent),
  ((0,11,198),(0,11,200),IndicSyllabicCategory::VowelDependent),
  ((0,11,202),(0,11,204),IndicSyllabicCategory::VowelDependent),
  ((0,11,205),(0,11,205),IndicSyllabicCategory::Virama),
  ((0,11,215),(0,11,215),IndicSyllabicCategory::VowelDependent),
  ((0,11,230),(0,11,239),IndicSyllabicCategory::Number),
  ((0,12,0),(0,12,2),IndicSyllabicCategory::Bindu),
  ((0,12,3),(0,12,3),IndicSyllabicCategory::Visarga),
  ((0,12,5),(0,12,12),IndicSyllabicCategory::VowelIndependent),
  ((0,12,14),(0,12,16),IndicSyllabicCategory::VowelIndependent),
  ((0,12,18),(0,12,20),IndicSyllabicCategory::VowelIndependent),
  ((0,12,21),(0,12,40),IndicSyllabicCategory::Consonant),
  ((0,12,42),(0,12,57),IndicSyllabicCategory::Consonant),
  ((0,12,61),(0,12,61),IndicSyllabicCategory::Avagraha),
  ((0,12,62),(0,12,68),IndicSyllabicCategory::VowelDependent),
  ((0,12,70),(0,12,72),IndicSyllabicCategory::VowelDependent),
  ((0,12,74),(0,12,76),IndicSyllabicCategory::VowelDependent),
  ((0,12,77),(0,12,77),IndicSyllabicCategory::Virama),
  ((0,12,85),(0,12,86),IndicSyllabicCategory::VowelDependent),
  ((0,12,88),(0,12,90),IndicSyllabicCategory::Consonant),
  ((0,12,96),(0,12,97),IndicSyllabicCategory::VowelIndependent),
  ((0,12,98),(0,12,99),IndicSyllabicCategory::VowelDependent),
  ((0,12,102),(0,12,111),IndicSyllabicCategory::Number),
  ((0,12,129),(0,12,130),IndicSyllabicCategory::Bindu),
  ((0,12,131),(0,12,131),IndicSyllabicCategory::Visarga),
  ((0,12,133),(0,12,140),IndicSyllabicCategory::VowelIndependent),
  ((0,12,142),(0,12,144),IndicSyllabicCategory::VowelIndependent),
  ((0,12,146),(0,12,148),IndicSyllabicCategory::VowelIndependent),
  ((0,12,149),(0,12,168),IndicSyllabicCategory::Consonant),
  ((0,12,170),(0,12,179),IndicSyllabicCategory::Consonant),
  ((0,12,181),(0,12,185),IndicSyllabicCategory::Consonant),
  ((0,12,188),(0,12,188),IndicSyllabicCategory::Nukta),
  ((0,12,189),(0,12,189),IndicSyllabicCategory::Avagraha),
  ((0,12,190),(0,12,196),IndicSyllabicCategory::VowelDependent),
  ((0,12,198),(0,12,200),IndicSyllabicCategory::VowelDependent),
  ((0,12,202),(0,12,204),IndicSyllabicCategory::VowelDependent),
  ((0,12,205),(0,12,205),IndicSyllabicCategory::Virama),
  ((0,12,213),(0,12,214),IndicSyllabicCategory::VowelDependent),
  ((0,12,222),(0,12,222),IndicSyllabicCategory::Consonant),
  ((0,12,224),(0,12,225),IndicSyllabicCategory::VowelIndependent),
  ((0,12,226),(0,12,227),IndicSyllabicCategory::VowelDependent),
  ((0,12,230),(0,12,239),IndicSyllabicCategory::Number),
  ((0,12,241),(0,12,242),IndicSyllabicCategory::ConsonantWithStacker),
  ((0,13,1),(0,13,2),IndicSyllabicCategory::Bindu),
  ((0,13,3),(0,13,3),IndicSyllabicCategory::Visarga),
  ((0,13,5),(0,13,12),IndicSyllabicCategory::VowelIndependent),
  ((0,13,14),(0,13,16),IndicSyllabicCategory::VowelIndependent),
  ((0,13,18),(0,13,20),IndicSyllabicCategory::VowelIndependent),
  ((0,13,21),(0,13,58),IndicSyllabicCategory::Consonant),
  ((0,13,61),(0,13,61),IndicSyllabicCategory::Avagraha),
  ((0,13,62),(0,13,68),IndicSyllabicCategory::VowelDependent),
  ((0,13,70),(0,13,72),IndicSyllabicCategory::VowelDependent),
  ((0,13,74),(0,13,76),IndicSyllabicCategory::VowelDependent),
  ((0,13,77),(0,13,77),IndicSyllabicCategory::Virama),
  ((0,13,78),(0,13,78),IndicSyllabicCategory::ConsonantPrecedingRepha),
  ((0,13,84),(0,13,86),IndicSyllabicCategory::ConsonantDead),
  ((0,13,87),(0,13,87),IndicSyllabicCategory::VowelDependent),
  ((0,13,95),(0,13,97),IndicSyllabicCategory::VowelIndependent),
  ((0,13,98),(0,13,99),IndicSyllabicCategory::VowelDependent),
  ((0,13,102),(0,13,111),IndicSyllabicCategory::Number),
  ((0,13,122),(0,13,127),IndicSyllabicCategory::ConsonantDead),
  ((0,13,130),(0,13,130),IndicSyllabicCategory::Bindu),
  ((0,13,131),(0,13,131),IndicSyllabicCategory::Visarga),
  ((0,13,133),(0,13,150),IndicSyllabicCategory::VowelIndependent),
  ((0,13,154),(0,13,177),IndicSyllabicCategory::Consonant),
  ((0,13,179),(0,13,187),IndicSyllabicCategory::Consonant),
  ((0,13,189),(0,13,189),IndicSyllabicCategory::Consonant),
  ((0,13,192),(0,13,198),IndicSyllabicCategory::Consonant),
  ((0,13,202),(0,13,202),IndicSyllabicCategory::Virama),
  ((0,13,207),(0,13,212),IndicSyllabicCategory::VowelDependent),
  ((0,13,214),(0,13,214),IndicSyllabicCategory::VowelDependent),
  ((0,13,216),(0,13,223),IndicSyllabicCategory::VowelDependent),
  ((0,13,230),(0,13,239),IndicSyllabicCategory::Number),
  ((0,13,242),(0,13,243),IndicSyllabicCategory::VowelDependent),
  ((0,14,1),(0,14,46),IndicSyllabicCategory::Consonant),
  ((0,14,48),(0,14,57),IndicSyllabicCategory::VowelDependent),
  ((0,14,58),(0,14,58),IndicSyllabicCategory::PureKiller),
  ((0,14,64),(0,14,69),IndicSyllabicCategory::VowelDependent),
  ((0,14,71),(0,14,71),IndicSyllabicCategory::VowelDependent),
  ((0,14,72),(0,14,75),IndicSyllabicCategory::ToneMark),
  ((0,14,76),(0,14,76),IndicSyllabicCategory::ConsonantKiller),
  ((0,14,77),(0,14,77),IndicSyllabicCategory::Bindu),
  ((0,14,78),(0,14,78),IndicSyllabicCategory::PureKiller),
  ((0,14,80),(0,14,89),IndicSyllabicCategory::Number),
  ((0,14,129),(0,14,130),IndicSyllabicCategory::Consonant),
  ((0,14,132),(0,14,132),IndicSyllabicCategory::Consonant),
  ((0,14,135),(0,14,136),IndicSyllabicCategory::Consonant),
  ((0,14,138),(0,14,138),IndicSyllabicCategory::Consonant),
  ((0,14,141),(0,14,141),IndicSyllabicCategory::Consonant),
  ((0,14,148),(0,14,151),IndicSyllabicCategory::Consonant),
  ((0,14,153),(0,14,159),IndicSyllabicCategory::Consonant),
  ((0,14,161),(0,14,163),IndicSyllabicCategory::Consonant),
  ((0,14,165),(0,14,165),IndicSyllabicCategory::Consonant),
  ((0,14,167),(0,14,167),IndicSyllabicCategory::Consonant),
  ((0,14,170),(0,14,171),IndicSyllabicCategory::Consonant),
  ((0,14,173),(0,14,174),IndicSyllabicCategory::Consonant),
  ((0,14,176),(0,14,185),IndicSyllabicCategory::VowelDependent),
  ((0,14,187),(0,14,187),IndicSyllabicCategory::VowelDependent),
  ((0,14,188),(0,14,189),IndicSyllabicCategory::ConsonantMedial),
  ((0,14,192),(0,14,196),IndicSyllabicCategory::VowelDependent),
  ((0,14,200),(0,14,203),IndicSyllabicCategory::ToneMark),
  ((0,14,205),(0,14,205),IndicSyllabicCategory::Bindu),
  ((0,14,208),(0,14,217),IndicSyllabicCategory::Number),
  ((0,14,220),(0,14,223),IndicSyllabicCategory::Consonant),
  ((0,15,32),(0,15,51),IndicSyllabicCategory::Number),
  ((0,15,53),(0,15,53),IndicSyllabicCategory::SyllableModifier),
  ((0,15,55),(0,15,55),IndicSyllabicCategory::SyllableModifier),
  ((0,15,57),(0,15,57),IndicSyllabicCategory::Nukta),
  ((0,15,64),(0,15,71),IndicSyllabicCategory::Consonant),
  ((0,15,73),(0,15,108),IndicSyllabicCategory::Consonant),
  ((0,15,113),(0,15,125),IndicSyllabicCategory::VowelDependent),
  ((0,15,126),(0,15,126),IndicSyllabicCategory::Bindu),
  ((0,15,127),(0,15,127),IndicSyllabicCategory::Visarga),
  ((0,15,128),(0,15,129),IndicSyllabicCategory::VowelDependent),
  ((0,15,130),(0,15,131),IndicSyllabicCategory::Bindu),
  ((0,15,132),(0,15,132),IndicSyllabicCategory::PureKiller),
  ((0,15,133),(0,15,133),IndicSyllabicCategory::Avagraha),
  ((0,15,136),(0,15,140),IndicSyllabicCategory::ConsonantHeadLetter),
  ((0,15,141),(0,15,151),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,15,153),(0,15,188),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,15,198),(0,15,198),IndicSyllabicCategory::SyllableModifier),
  ((0,16,0),(0,16,32),IndicSyllabicCategory::Consonant),
  ((0,16,33),(0,16,42),IndicSyllabicCategory::VowelIndependent),
  ((0,16,43),(0,16,53),IndicSyllabicCategory::VowelDependent),
  ((0,16,54),(0,16,54),IndicSyllabicCategory::Bindu),
  ((0,16,55),(0,16,55),IndicSyllabicCategory::ToneMark),
  ((0,16,56),(0,16,56),IndicSyllabicCategory::Visarga),
  ((0,16,57),(0,16,57),IndicSyllabicCategory::InvisibleStacker),
  ((0,16,58),(0,16,58),IndicSyllabicCategory::PureKiller),
  ((0,16,59),(0,16,62),IndicSyllabicCategory::ConsonantMedial),
  ((0,16,63),(0,16,63),IndicSyllabicCategory::Consonant),
  ((0,16,64),(0,16,73),IndicSyllabicCategory::Number),
  ((0,16,78),(0,16,78),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,16,80),(0,16,81),IndicSyllabicCategory::Consonant),
  ((0,16,82),(0,16,85),IndicSyllabicCategory::VowelIndependent),
  ((0,16,86),(0,16,89),IndicSyllabicCategory::VowelDependent),
  ((0,16,90),(0,16,93),IndicSyllabicCategory::Consonant),
  ((0,16,94),(0,16,96),IndicSyllabicCategory::ConsonantMedial),
  ((0,16,97),(0,16,97),IndicSyllabicCategory::Consonant),
  ((0,16,98),(0,16,98),IndicSyllabicCategory::VowelDependent),
  ((0,16,99),(0,16,100),IndicSyllabicCategory::ToneMark),
  ((0,16,101),(0,16,102),IndicSyllabicCategory::Consonant),
  ((0,16,103),(0,16,104),IndicSyllabicCategory::VowelDependent),
  ((0,16,105),(0,16,109),IndicSyllabicCategory::ToneMark),
  ((0,16,110),(0,16,112),IndicSyllabicCategory::Consonant),
  ((0,16,113),(0,16,116),IndicSyllabicCategory::VowelDependent),
  ((0,16,117),(0,16,129),IndicSyllabicCategory::Consonant),
  ((0,16,130),(0,16,130),IndicSyllabicCategory::ConsonantMedial),
  ((0,16,131),(0,16,134),IndicSyllabicCategory::VowelDependent),
  ((0,16,135),(0,16,141),IndicSyllabicCategory::ToneMark),
  ((0,16,142),(0,16,142),IndicSyllabicCategory::Consonant),
  ((0,16,143),(0,16,143),IndicSyllabicCategory::ToneMark),
  ((0,16,144),(0,16,153),IndicSyllabicCategory::Number),
  ((0,16,154),(0,16,155),IndicSyllabicCategory::ToneMark),
  ((0,16,156),(0,16,157),IndicSyllabicCategory::VowelDependent),
  ((0,23,0),(0,23,2),IndicSyllabicCategory::VowelIndependent),
  ((0,23,3),(0,23,12),IndicSyllabicCategory::Consonant),
  ((0,23,14),(0,23,17),IndicSyllabicCategory::Consonant),
  ((0,23,18),(0,23,19),IndicSyllabicCategory::VowelDependent),
  ((0,23,20),(0,23,20),IndicSyllabicCategory::PureKiller),
  ((0,23,32),(0,23,34),IndicSyllabicCategory::VowelIndependent),
  ((0,23,35),(0,23,49),IndicSyllabicCategory::Consonant),
  ((0,23,50),(0,23,51),IndicSyllabicCategory::VowelDependent),
  ((0,23,52),(0,23,52),IndicSyllabicCategory::PureKiller),
  ((0,23,64),(0,23,66),IndicSyllabicCategory::VowelIndependent),
  ((0,23,67),(0,23,81),IndicSyllabicCategory::Consonant),
  ((0,23,82),(0,23,83),IndicSyllabicCategory::VowelDependent),
  ((0,23,96),(0,23,98),IndicSyllabicCategory::VowelIndependent),
  ((0,23,99),(0,23,108),IndicSyllabicCategory::Consonant),
  ((0,23,110),(0,23,112),IndicSyllabicCategory::Consonant),
  ((0,23,114),(0,23,115),IndicSyllabicCategory::VowelDependent),
  ((0,23,128),(0,23,162),IndicSyllabicCategory::Consonant),
  ((0,23,163),(0,23,179),IndicSyllabicCategory::VowelIndependent),
  ((0,23,182),(0,23,197),IndicSyllabicCategory::VowelDependent),
  ((0,23,198),(0,23,198),IndicSyllabicCategory::Bindu),
  ((0,23,199),(0,23,199),IndicSyllabicCategory::Visarga),
  ((0,23,200),(0,23,200),IndicSyllabicCategory::VowelDependent),
  ((0,23,201),(0,23,202),IndicSyllabicCategory::RegisterShifter),
  ((0,23,203),(0,23,203),IndicSyllabicCategory::SyllableModifier),
  ((0,23,204),(0,23,204),IndicSyllabicCategory::ConsonantSucceedingRepha),
  ((0,23,205),(0,23,205),IndicSyllabicCategory::ConsonantKiller),
  ((0,23,206),(0,23,208),IndicSyllabicCategory::SyllableModifier),
  ((0,23,209),(0,23,209),IndicSyllabicCategory::PureKiller),
  ((0,23,210),(0,23,210),IndicSyllabicCategory::InvisibleStacker),
  ((0,23,211),(0,23,211),IndicSyllabicCategory::SyllableModifier),
  ((0,23,220),(0,23,220),IndicSyllabicCategory::Avagraha),
  ((0,23,221),(0,23,221),IndicSyllabicCategory::SyllableModifier),
  ((0,23,224),(0,23,233),IndicSyllabicCategory::Number),
  ((0,25,0),(0,25,0),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,25,1),(0,25,30),IndicSyllabicCategory::Consonant),
  ((0,25,32),(0,25,40),IndicSyllabicCategory::VowelDependent),
  ((0,25,41),(0,25,43),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,25,48),(0,25,49),IndicSyllabicCategory::ConsonantFinal),
  ((0,25,50),(0,25,50),IndicSyllabicCategory::Bindu),
  ((0,25,51),(0,25,57),IndicSyllabicCategory::ConsonantFinal),
  ((0,25,58),(0,25,58),IndicSyllabicCategory::VowelDependent),
  ((0,25,59),(0,25,59),IndicSyllabicCategory::SyllableModifier),
  ((0,25,70),(0,25,79),IndicSyllabicCategory::Number),
  ((0,25,80),(0,25,98),IndicSyllabicCategory::Consonant),
  ((0,25,99),(0,25,109),IndicSyllabicCategory::Vowel),
  ((0,25,112),(0,25,116),IndicSyllabicCategory::ToneLetter),
  ((0,25,128),(0,25,171),IndicSyllabicCategory::Consonant),
  ((0,25,176),(0,25,192),IndicSyllabicCategory::VowelDependent),
  ((0,25,193),(0,25,199),IndicSyllabicCategory::ConsonantFinal),
  ((0,25,200),(0,25,201),IndicSyllabicCategory::ToneMark),
  ((0,25,208),(0,25,217),IndicSyllabicCategory::Number),
  ((0,26,0),(0,26,22),IndicSyllabicCategory::Consonant),
  ((0,26,23),(0,26,27),IndicSyllabicCategory::VowelDependent),
  ((0,26,32),(0,26,76),IndicSyllabicCategory::Consonant),
  ((0,26,77),(0,26,82),IndicSyllabicCategory::VowelIndependent),
  ((0,26,83),(0,26,84),IndicSyllabicCategory::Consonant),
  ((0,26,85),(0,26,86),IndicSyllabicCategory::ConsonantMedial),
  ((0,26,87),(0,26,94),IndicSyllabicCategory::ConsonantFinal),
  ((0,26,96),(0,26,96),IndicSyllabicCategory::InvisibleStacker),
  ((0,26,97),(0,26,116),IndicSyllabicCategory::VowelDependent),
  ((0,26,117),(0,26,121),IndicSyllabicCategory::ToneMark),
  ((0,26,122),(0,26,124),IndicSyllabicCategory::SyllableModifier),
  ((0,26,127),(0,26,127),IndicSyllabicCategory::SyllableModifier),
  ((0,26,128),(0,26,137),IndicSyllabicCategory::Number),
  ((0,26,144),(0,26,153),IndicSyllabicCategory::Number),
  ((0,27,0),(0,27,2),IndicSyllabicCategory::Bindu),
  ((0,27,3),(0,27,3),IndicSyllabicCategory::ConsonantSucceedingRepha),
  ((0,27,4),(0,27,4),IndicSyllabicCategory::Visarga),
  ((0,27,5),(0,27,18),IndicSyllabicCategory::VowelIndependent),
  ((0,27,19),(0,27,51),IndicSyllabicCategory::Consonant),
  ((0,27,52),(0,27,52),IndicSyllabicCategory::Nukta),
  ((0,27,53),(0,27,67),IndicSyllabicCategory::VowelDependent),
  ((0,27,68),(0,27,68),IndicSyllabicCategory::Virama),
  ((0,27,69),(0,27,75),IndicSyllabicCategory::Consonant),
  ((0,27,80),(0,27,89),IndicSyllabicCategory::Number),
  ((0,27,128),(0,27,128),IndicSyllabicCategory::Bindu),
  ((0,27,129),(0,27,129),IndicSyllabicCategory::ConsonantSucceedingRepha),
  ((0,27,130),(0,27,130),IndicSyllabicCategory::Visarga),
  ((0,27,131),(0,27,137),IndicSyllabicCategory::VowelIndependent),
  ((0,27,138),(0,27,160),IndicSyllabicCategory::Consonant),
  ((0,27,161),(0,27,163),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,27,164),(0,27,169),IndicSyllabicCategory::VowelDependent),
  ((0,27,170),(0,27,170),IndicSyllabicCategory::PureKiller),
  ((0,27,171),(0,27,171),IndicSyllabicCategory::InvisibleStacker),
  ((0,27,172),(0,27,173),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,27,174),(0,27,175),IndicSyllabicCategory::Consonant),
  ((0,27,176),(0,27,185),IndicSyllabicCategory::Number),
  ((0,27,186),(0,27,186),IndicSyllabicCategory::Avagraha),
  ((0,27,187),(0,27,189),IndicSyllabicCategory::Consonant),
  ((0,27,190),(0,27,191),IndicSyllabicCategory::ConsonantFinal),
  ((0,27,192),(0,27,227),IndicSyllabicCategory::Consonant),
  ((0,27,228),(0,27,229),IndicSyllabicCategory::VowelIndependent),
  ((0,27,230),(0,27,230),IndicSyllabicCategory::Nukta),
  ((0,27,231),(0,27,239),IndicSyllabicCategory::VowelDependent),
  ((0,27,240),(0,27,241),IndicSyllabicCategory::ConsonantFinal),
  ((0,27,242),(0,27,243),IndicSyllabicCategory::PureKiller),
  ((0,28,0),(0,28,35),IndicSyllabicCategory::Consonant),
  ((0,28,36),(0,28,37),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,28,38),(0,28,44),IndicSyllabicCategory::VowelDependent),
  ((0,28,45),(0,28,51),IndicSyllabicCategory::ConsonantFinal),
  ((0,28,52),(0,28,53),IndicSyllabicCategory::Bindu),
  ((0,28,54),(0,28,54),IndicSyllabicCategory::SyllableModifier),
  ((0,28,55),(0,28,55),IndicSyllabicCategory::Nukta),
  ((0,28,64),(0,28,73),IndicSyllabicCategory::Number),
  ((0,28,77),(0,28,79),IndicSyllabicCategory::Consonant),
  ((0,28,208),(0,28,210),IndicSyllabicCategory::CantillationMark),
  ((0,28,212),(0,28,225),IndicSyllabicCategory::CantillationMark),
  ((0,28,242),(0,28,243),IndicSyllabicCategory::Visarga),
  ((0,28,244),(0,28,244),IndicSyllabicCategory::CantillationMark),
  ((0,28,248),(0,28,249),IndicSyllabicCategory::CantillationMark),
  ((0,29,251),(0,29,251),IndicSyllabicCategory::SyllableModifier),
  ((0,32,12),(0,32,12),IndicSyllabicCategory::NonJoiner),
  ((0,32,13),(0,32,13),IndicSyllabicCategory::Joiner),
  ((0,32,16),(0,32,20),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,32,116),(0,32,116),IndicSyllabicCategory::SyllableModifier),
  ((0,32,130),(0,32,132),IndicSyllabicCategory::SyllableModifier),
  ((0,37,204),(0,37,204),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,168,0),(0,168,1),IndicSyllabicCategory::VowelIndependent),
  ((0,168,3),(0,168,5),IndicSyllabicCategory::VowelIndependent),
  ((0,168,6),(0,168,6),IndicSyllabicCategory::PureKiller),
  ((0,168,7),(0,168,10),IndicSyllabicCategory::Consonant),
  ((0,168,11),(0,168,11),IndicSyllabicCategory::Bindu),
  ((0,168,12),(0,168,34),IndicSyllabicCategory::Consonant),
  ((0,168,35),(0,168,39),IndicSyllabicCategory::VowelDependent),
  ((0,168,64),(0,168,93),IndicSyllabicCategory::Consonant),
  ((0,168,94),(0,168,97),IndicSyllabicCategory::Vowel),
  ((0,168,98),(0,168,101),IndicSyllabicCategory::Consonant),
  ((0,168,102),(0,168,102),IndicSyllabicCategory::Vowel),
  ((0,168,103),(0,168,104),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,168,105),(0,168,112),IndicSyllabicCategory::Consonant),
  ((0,168,113),(0,168,113),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,168,114),(0,168,114),IndicSyllabicCategory::Consonant),
  ((0,168,115),(0,168,115),IndicSyllabicCategory::Bindu),
  ((0,168,128),(0,168,128),IndicSyllabicCategory::Bindu),
  ((0,168,129),(0,168,129),IndicSyllabicCategory::Visarga),
  ((0,168,130),(0,168,145),IndicSyllabicCategory::VowelIndependent),
  ((0,168,146),(0,168,179),IndicSyllabicCategory::Consonant),
  ((0,168,180),(0,168,180),IndicSyllabicCategory::ConsonantFinal),
  ((0,168,181),(0,168,195),IndicSyllabicCategory::VowelDependent),
  ((0,168,196),(0,168,196),IndicSyllabicCategory::Virama),
  ((0,168,197),(0,168,197),IndicSyllabicCategory::Bindu),
  ((0,168,208),(0,168,217),IndicSyllabicCategory::Number),
  ((0,168,224),(0,168,241),IndicSyllabicCategory::CantillationMark),
  ((0,169,0),(0,169,9),IndicSyllabicCategory::Number),
  ((0,169,10),(0,169,33),IndicSyllabicCategory::Consonant),
  ((0,169,34),(0,169,42),IndicSyllabicCategory::Vowel),
  ((0,169,43),(0,169,45),IndicSyllabicCategory::ToneMark),
  ((0,169,48),(0,169,70),IndicSyllabicCategory::Consonant),
  ((0,169,71),(0,169,78),IndicSyllabicCategory::VowelDependent),
  ((0,169,79),(0,169,82),IndicSyllabicCategory::ConsonantFinal),
  ((0,169,83),(0,169,83),IndicSyllabicCategory::PureKiller),
  ((0,169,128),(0,169,129),IndicSyllabicCategory::Bindu),
  ((0,169,130),(0,169,130),IndicSyllabicCategory::ConsonantSucceedingRepha),
  ((0,169,131),(0,169,131),IndicSyllabicCategory::Visarga),
  ((0,169,132),(0,169,136),IndicSyllabicCategory::VowelIndependent),
  ((0,169,137),(0,169,139),IndicSyllabicCategory::Consonant),
  ((0,169,140),(0,169,142),IndicSyllabicCategory::VowelIndependent),
  ((0,169,143),(0,169,178),IndicSyllabicCategory::Consonant),
  ((0,169,179),(0,169,179),IndicSyllabicCategory::Nukta),
  ((0,169,180),(0,169,188),IndicSyllabicCategory::VowelDependent),
  ((0,169,189),(0,169,189),IndicSyllabicCategory::ConsonantSubjoined),
  ((0,169,190),(0,169,191),IndicSyllabicCategory::ConsonantMedial),
  ((0,169,192),(0,169,192),IndicSyllabicCategory::Virama),
  ((0,169,208),(0,169,217),IndicSyllabicCategory::Number),
  ((0,169,224),(0,169,228),IndicSyllabicCategory::Consonant),
  ((0,169,229),(0,169,229),IndicSyllabicCategory::VowelDependent),
  ((0,169,231),(0,169,239),IndicSyllabicCategory::Consonant),
  ((0,169,240),(0,169,249),IndicSyllabicCategory::Number),
  ((0,169,250),(0,169,254),IndicSyllabicCategory::Consonant),
  ((0,170,0),(0,170,5),IndicSyllabicCategory::VowelIndependent),
  ((0,170,6),(0,170,40),IndicSyllabicCategory::Consonant),
  ((0,170,41),(0,170,50),IndicSyllabicCategory::VowelDependent),
  ((0,170,51),(0,170,54),IndicSyllabicCategory::ConsonantMedial),
  ((0,170,64),(0,170,77),IndicSyllabicCategory::ConsonantFinal),
  ((0,170,80),(0,170,89),IndicSyllabicCategory::Number),
  ((0,170,96),(0,170,111),IndicSyllabicCategory::Consonant),
  ((0,170,113),(0,170,115),IndicSyllabicCategory::Consonant),
  ((0,170,116),(0,170,118),IndicSyllabicCategory::ConsonantPlaceholder),
  ((0,170,122),(0,170,122),IndicSyllabicCategory::Consonant),
  ((0,170,123),(0,170,125),IndicSyllabicCategory::ToneMark),
  ((0,170,126),(0,170,175),IndicSyllabicCategory::Consonant),
  ((0,170,176),(0,170,190),IndicSyllabicCategory::VowelDependent),
  ((0,170,191),(0,170,191),IndicSyllabicCategory::ToneMark),
  ((0,170,192),(0,170,192),IndicSyllabicCategory::ToneLetter),
  ((0,170,193),(0,170,193),IndicSyllabicCategory::ToneMark),
  ((0,170,194),(0,170,194),IndicSyllabicCategory::ToneLetter),
  ((0,170,224),(0,170,225),IndicSyllabicCategory::VowelIndependent),
  ((0,170,226),(0,170,234),IndicSyllabicCategory::Consonant),
  ((0,170,235),(0,170,239),IndicSyllabicCategory::VowelDependent),
  ((0,170,245),(0,170,245),IndicSyllabicCategory::Visarga),
  ((0,170,246),(0,170,246),IndicSyllabicCategory::InvisibleStacker),
  ((0,171,192),(0,171,205),IndicSyllabicCategory::Consonant),
  ((0,171,206),(0,171,207),IndicSyllabicCategory::VowelIndependent),
  ((0,171,208),(0,171,208),IndicSyllabicCategory::Consonant),
  ((0,171,209),(0,171,209),IndicSyllabicCategory::VowelIndependent),
  ((0,171,210),(0,171,218),IndicSyllabicCategory::Consonant),
  ((0,171,219),(0,171,226),IndicSyllabicCategory::ConsonantFinal),
  ((0,171,227),(0,171,234),IndicSyllabicCategory::VowelDependent),
  ((0,171,236),(0,171,236),IndicSyllabicCategory::ToneMark),
  ((0,171,237),(0,171,237),IndicSyllabicCategory::PureKiller),
  ((0,171,240),(0,171,249),IndicSyllabicCategory::Number),
  ((1,10,0),(1,10,0),IndicSyllabicCategory::Consonant),
  ((1,10,1),(1,10,3),IndicSyllabicCategory::VowelDependent),
  ((1,10,5),(1,10,6),IndicSyllabicCategory::VowelDependent),
  ((1,10,12),(1,10,13),IndicSyllabicCategory::VowelDependent),
  ((1,10,14),(1,10,14),IndicSyllabicCategory::Bindu),
  ((1,10,15),(1,10,15),IndicSyllabicCategory::Visarga),
  ((1,10,16),(1,10,19),IndicSyllabicCategory::Consonant),
  ((1,10,21),(1,10,23),IndicSyllabicCategory::Consonant),
  ((1,10,25),(1,10,51),IndicSyllabicCategory::Consonant),
  ((1,10,56),(1,10,58),IndicSyllabicCategory::Nukta),
  ((1,10,63),(1,10,63),IndicSyllabicCategory::InvisibleStacker),
  ((1,10,64),(1,10,71),IndicSyllabicCategory::Number),
  ((1,16,0),(1,16,1),IndicSyllabicCategory::Bindu),
  ((1,16,2),(1,16,2),IndicSyllabicCategory::Visarga),
  ((1,16,3),(1,16,4),IndicSyllabicCategory::ConsonantWithStacker),
  ((1,16,5),(1,16,18),IndicSyllabicCategory::VowelIndependent),
  ((1,16,19),(1,16,55),IndicSyllabicCategory::Consonant),
  ((1,16,56),(1,16,69),IndicSyllabicCategory::VowelDependent),
  ((1,16,70),(1,16,70),IndicSyllabicCategory::Virama),
  ((1,16,82),(1,16,101),IndicSyllabicCategory::BrahmiJoiningNumber),
  ((1,16,102),(1,16,111),IndicSyllabicCategory::Number),
  ((1,16,127),(1,16,127),IndicSyllabicCategory::NumberJoiner),
  ((1,16,128),(1,16,129),IndicSyllabicCategory::Bindu),
  ((1,16,130),(1,16,130),IndicSyllabicCategory::Visarga),
  ((1,16,131),(1,16,140),IndicSyllabicCategory::VowelIndependent),
  ((1,16,141),(1,16,175),IndicSyllabicCategory::Consonant),
  ((1,16,176),(1,16,184),IndicSyllabicCategory::VowelDependent),
  ((1,16,185),(1,16,185),IndicSyllabicCategory::Virama),
  ((1,16,186),(1,16,186),IndicSyllabicCategory::Nukta),
  ((1,17,0),(1,17,1),IndicSyllabicCategory::Bindu),
  ((1,17,2),(1,17,2),IndicSyllabicCategory::Visarga),
  ((1,17,3),(1,17,6),IndicSyllabicCategory::VowelIndependent),
  ((1,17,7),(1,17,38),IndicSyllabicCategory::Consonant),
  ((1,17,39),(1,17,50),IndicSyllabicCategory::VowelDependent),
  ((1,17,51),(1,17,51),IndicSyllabicCategory::InvisibleStacker),
  ((1,17,52),(1,17,52),IndicSyllabicCategory::PureKiller),
  ((1,17,54),(1,17,63),IndicSyllabicCategory::Number),
  ((1,17,80),(1,17,84),IndicSyllabicCategory::Vowel),
  ((1,17,85),(1,17,114),IndicSyllabicCategory::Consonant),
  ((1,17,115),(1,17,115),IndicSyllabicCategory::Nukta),
  ((1,17,128),(1,17,129),IndicSyllabicCategory::Bindu),
  ((1,17,130),(1,17,130),IndicSyllabicCategory::Visarga),
  ((1,17,131),(1,17,144),IndicSyllabicCategory::VowelIndependent),
  ((1,17,145),(1,17,178),IndicSyllabicCategory::Consonant),
  ((1,17,179),(1,17,191),IndicSyllabicCategory::VowelDependent),
  ((1,17,192),(1,17,192),IndicSyllabicCategory::Virama),
  ((1,17,193),(1,17,193),IndicSyllabicCategory::Avagraha),
  ((1,17,194),(1,17,195),IndicSyllabicCategory::ConsonantPrefixed),
  ((1,17,202),(1,17,202),IndicSyllabicCategory::Nukta),
  ((1,17,203),(1,17,204),IndicSyllabicCategory::VowelDependent),
  ((1,17,208),(1,17,217),IndicSyllabicCategory::Number),
  ((1,17,225),(1,17,244),IndicSyllabicCategory::Number),
  ((1,18,0),(1,18,7),IndicSyllabicCategory::VowelIndependent),
  ((1,18,8),(1,18,17),IndicSyllabicCategory::Consonant),
  ((1,18,19),(1,18,43),IndicSyllabicCategory::Consonant),
  ((1,18,44),(1,18,51),IndicSyllabicCategory::VowelDependent),
  ((1,18,52),(1,18,52),IndicSyllabicCategory::Bindu),
  ((1,18,53),(1,18,53),IndicSyllabicCategory::Virama),
  ((1,18,54),(1,18,54),IndicSyllabicCategory::Nukta),
  ((1,18,55),(1,18,55),IndicSyllabicCategory::GeminationMark),
  ((1,18,62),(1,18,62),IndicSyllabicCategory::CantillationMark),
  ((1,18,128),(1,18,131),IndicSyllabicCategory::VowelIndependent),
  ((1,18,132),(1,18,134),IndicSyllabicCategory::Consonant),
  ((1,18,136),(1,18,136),IndicSyllabicCategory::Consonant),
  ((1,18,138),(1,18,141),IndicSyllabicCategory::Consonant),
  ((1,18,143),(1,18,157),IndicSyllabicCategory::Consonant),
  ((1,18,159),(1,18,168),IndicSyllabicCategory::Consonant),
  ((1,18,176),(1,18,185),IndicSyllabicCategory::VowelIndependent),
  ((1,18,186),(1,18,222),IndicSyllabicCategory::Consonant),
  ((1,18,223),(1,18,223),IndicSyllabicCategory::Bindu),
  ((1,18,224),(1,18,232),IndicSyllabicCategory::VowelDependent),
  ((1,18,233),(1,18,233),IndicSyllabicCategory::Nukta),
  ((1,18,234),(1,18,234),IndicSyllabicCategory::PureKiller),
  ((1,18,240),(1,18,249),IndicSyllabicCategory::Number),
  ((1,19,0),(1,19,2),IndicSyllabicCategory::Bindu),
  ((1,19,3),(1,19,3),IndicSyllabicCategory::Visarga),
  ((1,19,5),(1,19,12),IndicSyllabicCategory::VowelIndependent),
  ((1,19,15),(1,19,16),IndicSyllabicCategory::VowelIndependent),
  ((1,19,19),(1,19,20),IndicSyllabicCategory::VowelIndependent),
  ((1,19,21),(1,19,40),IndicSyllabicCategory::Consonant),
  ((1,19,42),(1,19,48),IndicSyllabicCategory::Consonant),
  ((1,19,50),(1,19,51),IndicSyllabicCategory::Consonant),
  ((1,19,53),(1,19,57),IndicSyllabicCategory::Consonant),
  ((1,19,60),(1,19,60),IndicSyllabicCategory::Nukta),
  ((1,19,61),(1,19,61),IndicSyllabicCategory::Avagraha),
  ((1,19,62),(1,19,68),IndicSyllabicCategory::VowelDependent),
  ((1,19,71),(1,19,72),IndicSyllabicCategory::VowelDependent),
  ((1,19,75),(1,19,76),IndicSyllabicCategory::VowelDependent),
  ((1,19,77),(1,19,77),IndicSyllabicCategory::Virama),
  ((1,19,87),(1,19,87),IndicSyllabicCategory::VowelDependent),
  ((1,19,96),(1,19,97),IndicSyllabicCategory::VowelIndependent),
  ((1,19,98),(1,19,99),IndicSyllabicCategory::VowelDependent),
  ((1,19,102),(1,19,108),IndicSyllabicCategory::CantillationMark),
  ((1,19,112),(1,19,116),IndicSyllabicCategory::CantillationMark),
  ((1,20,0),(1,20,13),IndicSyllabicCategory::VowelIndependent),
  ((1,20,14),(1,20,52),IndicSyllabicCategory::Consonant),
  ((1,20,53),(1,20,65),IndicSyllabicCategory::VowelDependent),
  ((1,20,66),(1,20,66),IndicSyllabicCategory::Virama),
  ((1,20,67),(1,20,68),IndicSyllabicCategory::Bindu),
  ((1,20,69),(1,20,69),IndicSyllabicCategory::Visarga),
  ((1,20,70),(1,20,70),IndicSyllabicCategory::Nukta),
  ((1,20,71),(1,20,71),IndicSyllabicCategory::Avagraha),
  ((1,20,80),(1,20,89),IndicSyllabicCategory::Number),
  ((1,20,129),(1,20,142),IndicSyllabicCategory::VowelIndependent),
  ((1,20,143),(1,20,175),IndicSyllabicCategory::Consonant),
  ((1,20,176),(1,20,190),IndicSyllabicCategory::VowelDependent),
  ((1,20,191),(1,20,192),IndicSyllabicCategory::Bindu),
  ((1,20,193),(1,20,193),IndicSyllabicCategory::Visarga),
  ((1,20,194),(1,20,194),IndicSyllabicCategory::Virama),
  ((1,20,195),(1,20,195),IndicSyllabicCategory::Nukta),
  ((1,20,196),(1,20,196),IndicSyllabicCategory::Avagraha),
  ((1,20,208),(1,20,217),IndicSyllabicCategory::Number),
  ((1,21,128),(1,21,141),IndicSyllabicCategory::VowelIndependent),
  ((1,21,142),(1,21,174),IndicSyllabicCategory::Consonant),
  ((1,21,175),(1,21,181),IndicSyllabicCategory::VowelDependent),
  ((1,21,184),(1,21,187),IndicSyllabicCategory::VowelDependent),
  ((1,21,188),(1,21,189),IndicSyllabicCategory::Bindu),
  ((1,21,190),(1,21,190),IndicSyllabicCategory::Visarga),
  ((1,21,191),(1,21,191),IndicSyllabicCategory::Virama),
  ((1,21,192),(1,21,192),IndicSyllabicCategory::Nukta),
  ((1,21,216),(1,21,219),IndicSyllabicCategory::VowelIndependent),
  ((1,21,220),(1,21,221),IndicSyllabicCategory::VowelDependent),
  ((1,22,0),(1,22,13),IndicSyllabicCategory::VowelIndependent),
  ((1,22,14),(1,22,47),IndicSyllabicCategory::Consonant),
  ((1,22,48),(1,22,60),IndicSyllabicCategory::VowelDependent),
  ((1,22,61),(1,22,61),IndicSyllabicCategory::Bindu),
  ((1,22,62),(1,22,62),IndicSyllabicCategory::Visarga),
  ((1,22,63),(1,22,63),IndicSyllabicCategory::Virama),
  ((1,22,64),(1,22,64),IndicSyllabicCategory::VowelDependent),
  ((1,22,80),(1,22,89),IndicSyllabicCategory::Number),
  ((1,22,128),(1,22,137),IndicSyllabicCategory::VowelIndependent),
  ((1,22,138),(1,22,170),IndicSyllabicCategory::Consonant),
  ((1,22,171),(1,22,171),IndicSyllabicCategory::Bindu),
  ((1,22,172),(1,22,172),IndicSyllabicCategory::Visarga),
  ((1,22,173),(1,22,181),IndicSyllabicCategory::VowelDependent),
  ((1,22,182),(1,22,182),IndicSyllabicCategory::Virama),
  ((1,22,183),(1,22,183),IndicSyllabicCategory::Nukta),
  ((1,22,192),(1,22,201),IndicSyllabicCategory::Number),
  ((1,23,0),(1,23,25),IndicSyllabicCategory::Consonant),
  ((1,23,29),(1,23,31),IndicSyllabicCategory::ConsonantMedial),
  ((1,23,32),(1,23,42),IndicSyllabicCategory::VowelDependent),
  ((1,23,43),(1,23,43),IndicSyllabicCategory::PureKiller),
  ((1,23,48),(1,23,59),IndicSyllabicCategory::Number),
  ((1,28,0),(1,28,8),IndicSyllabicCategory::VowelIndependent),
  ((1,28,10),(1,28,13),IndicSyllabicCategory::VowelIndependent),
  ((1,28,14),(1,28,46),IndicSyllabicCategory::Consonant),
  ((1,28,47),(1,28,54),IndicSyllabicCategory::VowelDependent),
  ((1,28,56),(1,28,59),IndicSyllabicCategory::VowelDependent),
  ((1,28,60),(1,28,61),IndicSyllabicCategory::Bindu),
  ((1,28,62),(1,28,62),IndicSyllabicCategory::Visarga),
  ((1,28,63),(1,28,63),IndicSyllabicCategory::Virama),
  ((1,28,64),(1,28,64),IndicSyllabicCategory::Avagraha),
  ((1,28,80),(1,28,108),IndicSyllabicCategory::Number),
  ((1,28,114),(1,28,143),IndicSyllabicCategory::Consonant),
  ((1,28,146),(1,28,167),IndicSyllabicCategory::ConsonantSubjoined),
  ((1,28,169),(1,28,175),IndicSyllabicCategory::ConsonantSubjoined),
  ((1,28,176),(1,28,180),IndicSyllabicCategory::VowelDependent),
  ((1,28,181),(1,28,182),IndicSyllabicCategory::Bindu)
];

#[derive(Clone,Copy,Eq,PartialEq,Debug)]
pub enum IndicPositionalCategory {
  Left, Right, TopAndBottomAndRight, TopAndLeft, TopAndRight, Top,
  BottomAndRight, Overstruck, LeftAndRight, TopAndLeftAndRight, TopAndBottom,
  Bottom, VisualOrderLeft
}

pub static UCD_INPC: &'static [((u8,u8,u8), IndicPositionalCategory)] = &[
  ((0,9,0),IndicPositionalCategory::Top),
  ((0,9,1),IndicPositionalCategory::Top),
  ((0,9,2),IndicPositionalCategory::Top),
  ((0,9,3),IndicPositionalCategory::Right),
  ((0,9,58),IndicPositionalCategory::Top),
  ((0,9,59),IndicPositionalCategory::Right),
  ((0,9,60),IndicPositionalCategory::Bottom),
  ((0,9,62),IndicPositionalCategory::Right),
  ((0,9,63),IndicPositionalCategory::Left),
  ((0,9,64),IndicPositionalCategory::Right),
  ((0,9,65),IndicPositionalCategory::Bottom),
  ((0,9,66),IndicPositionalCategory::Bottom),
  ((0,9,67),IndicPositionalCategory::Bottom),
  ((0,9,68),IndicPositionalCategory::Bottom),
  ((0,9,69),IndicPositionalCategory::Top),
  ((0,9,70),IndicPositionalCategory::Top),
  ((0,9,71),IndicPositionalCategory::Top),
  ((0,9,72),IndicPositionalCategory::Top),
  ((0,9,73),IndicPositionalCategory::Right),
  ((0,9,74),IndicPositionalCategory::Right),
  ((0,9,75),IndicPositionalCategory::Right),
  ((0,9,76),IndicPositionalCategory::Right),
  ((0,9,77),IndicPositionalCategory::Bottom),
  ((0,9,78),IndicPositionalCategory::Left),
  ((0,9,79),IndicPositionalCategory::Right),
  ((0,9,81),IndicPositionalCategory::Top),
  ((0,9,82),IndicPositionalCategory::Bottom),
  ((0,9,83),IndicPositionalCategory::Top),
  ((0,9,84),IndicPositionalCategory::Top),
  ((0,9,85),IndicPositionalCategory::Top),
  ((0,9,86),IndicPositionalCategory::Bottom),
  ((0,9,87),IndicPositionalCategory::Bottom),
  ((0,9,98),IndicPositionalCategory::Bottom),
  ((0,9,99),IndicPositionalCategory::Bottom),
  ((0,9,129),IndicPositionalCategory::Top),
  ((0,9,130),IndicPositionalCategory::Right),
  ((0,9,131),IndicPositionalCategory::Right),
  ((0,9,188),IndicPositionalCategory::Bottom),
  ((0,9,190),IndicPositionalCategory::Right),
  ((0,9,191),IndicPositionalCategory::Left),
  ((0,9,192),IndicPositionalCategory::Right),
  ((0,9,193),IndicPositionalCategory::Bottom),
  ((0,9,194),IndicPositionalCategory::Bottom),
  ((0,9,195),IndicPositionalCategory::Bottom),
  ((0,9,196),IndicPositionalCategory::Bottom),
  ((0,9,199),IndicPositionalCategory::Left),
  ((0,9,200),IndicPositionalCategory::Left),
  ((0,9,203),IndicPositionalCategory::LeftAndRight),
  ((0,9,204),IndicPositionalCategory::LeftAndRight),
  ((0,9,205),IndicPositionalCategory::Bottom),
  ((0,9,215),IndicPositionalCategory::Right),
  ((0,9,226),IndicPositionalCategory::Bottom),
  ((0,9,227),IndicPositionalCategory::Bottom),
  ((0,10,1),IndicPositionalCategory::Top),
  ((0,10,2),IndicPositionalCategory::Top),
  ((0,10,3),IndicPositionalCategory::Right),
  ((0,10,60),IndicPositionalCategory::Bottom),
  ((0,10,62),IndicPositionalCategory::Right),
  ((0,10,63),IndicPositionalCategory::Left),
  ((0,10,64),IndicPositionalCategory::Right),
  ((0,10,65),IndicPositionalCategory::Bottom),
  ((0,10,66),IndicPositionalCategory::Bottom),
  ((0,10,71),IndicPositionalCategory::Top),
  ((0,10,72),IndicPositionalCategory::Top),
  ((0,10,75),IndicPositionalCategory::Top),
  ((0,10,76),IndicPositionalCategory::Top),
  ((0,10,77),IndicPositionalCategory::Bottom),
  ((0,10,112),IndicPositionalCategory::Top),
  ((0,10,113),IndicPositionalCategory::Top),
  ((0,10,117),IndicPositionalCategory::Bottom),
  ((0,10,129),IndicPositionalCategory::Top),
  ((0,10,130),IndicPositionalCategory::Top),
  ((0,10,131),IndicPositionalCategory::Right),
  ((0,10,188),IndicPositionalCategory::Bottom),
  ((0,10,190),IndicPositionalCategory::Right),
  ((0,10,191),IndicPositionalCategory::Left),
  ((0,10,192),IndicPositionalCategory::Right),
  ((0,10,193),IndicPositionalCategory::Bottom),
  ((0,10,194),IndicPositionalCategory::Bottom),
  ((0,10,195),IndicPositionalCategory::Bottom),
  ((0,10,196),IndicPositionalCategory::Bottom),
  ((0,10,197),IndicPositionalCategory::Top),
  ((0,10,199),IndicPositionalCategory::Top),
  ((0,10,200),IndicPositionalCategory::Top),
  ((0,10,201),IndicPositionalCategory::TopAndRight),
  ((0,10,203),IndicPositionalCategory::Right),
  ((0,10,204),IndicPositionalCategory::Right),
  ((0,10,205),IndicPositionalCategory::Bottom),
  ((0,10,226),IndicPositionalCategory::Bottom),
  ((0,10,227),IndicPositionalCategory::Bottom),
  ((0,11,1),IndicPositionalCategory::Top),
  ((0,11,2),IndicPositionalCategory::Right),
  ((0,11,3),IndicPositionalCategory::Right),
  ((0,11,60),IndicPositionalCategory::Bottom),
  ((0,11,62),IndicPositionalCategory::Right),
  ((0,11,63),IndicPositionalCategory::Top),
  ((0,11,64),IndicPositionalCategory::Right),
  ((0,11,65),IndicPositionalCategory::Bottom),
  ((0,11,66),IndicPositionalCategory::Bottom),
  ((0,11,67),IndicPositionalCategory::Bottom),
  ((0,11,68),IndicPositionalCategory::Bottom),
  ((0,11,71),IndicPositionalCategory::Left),
  ((0,11,72),IndicPositionalCategory::TopAndLeft),
  ((0,11,75),IndicPositionalCategory::LeftAndRight),
  ((0,11,76),IndicPositionalCategory::TopAndLeftAndRight),
  ((0,11,77),IndicPositionalCategory::Bottom),
  ((0,11,86),IndicPositionalCategory::Top),
  ((0,11,87),IndicPositionalCategory::TopAndRight),
  ((0,11,98),IndicPositionalCategory::Bottom),
  ((0,11,99),IndicPositionalCategory::Bottom),
  ((0,11,130),IndicPositionalCategory::Top),
  ((0,11,190),IndicPositionalCategory::Right),
  ((0,11,191),IndicPositionalCategory::Right),
  ((0,11,192),IndicPositionalCategory::Top),
  ((0,11,193),IndicPositionalCategory::Right),
  ((0,11,194),IndicPositionalCategory::Right),
  ((0,11,198),IndicPositionalCategory::Left),
  ((0,11,199),IndicPositionalCategory::Left),
  ((0,11,200),IndicPositionalCategory::Left),
  ((0,11,202),IndicPositionalCategory::LeftAndRight),
  ((0,11,203),IndicPositionalCategory::LeftAndRight),
  ((0,11,204),IndicPositionalCategory::LeftAndRight),
  ((0,11,205),IndicPositionalCategory::Top),
  ((0,11,215),IndicPositionalCategory::Right),
  ((0,12,0),IndicPositionalCategory::Top),
  ((0,12,1),IndicPositionalCategory::Right),
  ((0,12,2),IndicPositionalCategory::Right),
  ((0,12,3),IndicPositionalCategory::Right),
  ((0,12,62),IndicPositionalCategory::Top),
  ((0,12,63),IndicPositionalCategory::Top),
  ((0,12,64),IndicPositionalCategory::Top),
  ((0,12,65),IndicPositionalCategory::Right),
  ((0,12,66),IndicPositionalCategory::Right),
  ((0,12,67),IndicPositionalCategory::Right),
  ((0,12,68),IndicPositionalCategory::Right),
  ((0,12,70),IndicPositionalCategory::Top),
  ((0,12,71),IndicPositionalCategory::Top),
  ((0,12,72),IndicPositionalCategory::TopAndBottom),
  ((0,12,74),IndicPositionalCategory::Top),
  ((0,12,75),IndicPositionalCategory::Top),
  ((0,12,76),IndicPositionalCategory::Top),
  ((0,12,77),IndicPositionalCategory::Top),
  ((0,12,85),IndicPositionalCategory::Top),
  ((0,12,86),IndicPositionalCategory::Bottom),
  ((0,12,98),IndicPositionalCategory::Bottom),
  ((0,12,99),IndicPositionalCategory::Bottom),
  ((0,12,129),IndicPositionalCategory::Top),
  ((0,12,130),IndicPositionalCategory::Right),
  ((0,12,131),IndicPositionalCategory::Right),
  ((0,12,188),IndicPositionalCategory::Bottom),
  ((0,12,190),IndicPositionalCategory::Right),
  ((0,12,191),IndicPositionalCategory::Top),
  ((0,12,192),IndicPositionalCategory::TopAndRight),
  ((0,12,193),IndicPositionalCategory::Right),
  ((0,12,194),IndicPositionalCategory::Right),
  ((0,12,195),IndicPositionalCategory::Right),
  ((0,12,196),IndicPositionalCategory::Right),
  ((0,12,198),IndicPositionalCategory::Top),
  ((0,12,199),IndicPositionalCategory::TopAndRight),
  ((0,12,200),IndicPositionalCategory::TopAndRight),
  ((0,12,202),IndicPositionalCategory::TopAndRight),
  ((0,12,203),IndicPositionalCategory::TopAndRight),
  ((0,12,204),IndicPositionalCategory::Top),
  ((0,12,205),IndicPositionalCategory::Top),
  ((0,12,213),IndicPositionalCategory::Right),
  ((0,12,214),IndicPositionalCategory::Right),
  ((0,12,226),IndicPositionalCategory::Bottom),
  ((0,12,227),IndicPositionalCategory::Bottom),
  ((0,13,1),IndicPositionalCategory::Top),
  ((0,13,2),IndicPositionalCategory::Right),
  ((0,13,3),IndicPositionalCategory::Right),
  ((0,13,62),IndicPositionalCategory::Right),
  ((0,13,63),IndicPositionalCategory::Right),
  ((0,13,64),IndicPositionalCategory::Right),
  ((0,13,65),IndicPositionalCategory::Right),
  ((0,13,66),IndicPositionalCategory::Right),
  ((0,13,67),IndicPositionalCategory::Bottom),
  ((0,13,68),IndicPositionalCategory::Bottom),
  ((0,13,70),IndicPositionalCategory::Left),
  ((0,13,71),IndicPositionalCategory::Left),
  ((0,13,72),IndicPositionalCategory::Left),
  ((0,13,74),IndicPositionalCategory::LeftAndRight),
  ((0,13,75),IndicPositionalCategory::LeftAndRight),
  ((0,13,76),IndicPositionalCategory::LeftAndRight),
  ((0,13,77),IndicPositionalCategory::Top),
  ((0,13,87),IndicPositionalCategory::Right),
  ((0,13,98),IndicPositionalCategory::Bottom),
  ((0,13,99),IndicPositionalCategory::Bottom),
  ((0,13,130),IndicPositionalCategory::Right),
  ((0,13,131),IndicPositionalCategory::Right),
  ((0,13,202),IndicPositionalCategory::Top),
  ((0,13,207),IndicPositionalCategory::Right),
  ((0,13,208),IndicPositionalCategory::Right),
  ((0,13,209),IndicPositionalCategory::Right),
  ((0,13,210),IndicPositionalCategory::Top),
  ((0,13,211),IndicPositionalCategory::Top),
  ((0,13,212),IndicPositionalCategory::Bottom),
  ((0,13,214),IndicPositionalCategory::Bottom),
  ((0,13,216),IndicPositionalCategory::Right),
  ((0,13,217),IndicPositionalCategory::Left),
  ((0,13,218),IndicPositionalCategory::TopAndLeft),
  ((0,13,219),IndicPositionalCategory::Left),
  ((0,13,220),IndicPositionalCategory::LeftAndRight),
  ((0,13,221),IndicPositionalCategory::TopAndLeftAndRight),
  ((0,13,222),IndicPositionalCategory::LeftAndRight),
  ((0,13,223),IndicPositionalCategory::Right),
  ((0,13,242),IndicPositionalCategory::Right),
  ((0,13,243),IndicPositionalCategory::Right),
  ((0,14,48),IndicPositionalCategory::Right),
  ((0,14,49),IndicPositionalCategory::Top),
  ((0,14,50),IndicPositionalCategory::Right),
  ((0,14,51),IndicPositionalCategory::Right),
  ((0,14,52),IndicPositionalCategory::Top),
  ((0,14,53),IndicPositionalCategory::Top),
  ((0,14,54),IndicPositionalCategory::Top),
  ((0,14,55),IndicPositionalCategory::Top),
  ((0,14,56),IndicPositionalCategory::Bottom),
  ((0,14,57),IndicPositionalCategory::Bottom),
  ((0,14,58),IndicPositionalCategory::Bottom),
  ((0,14,64),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,65),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,66),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,67),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,68),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,69),IndicPositionalCategory::Right),
  ((0,14,71),IndicPositionalCategory::Top),
  ((0,14,72),IndicPositionalCategory::Top),
  ((0,14,73),IndicPositionalCategory::Top),
  ((0,14,74),IndicPositionalCategory::Top),
  ((0,14,75),IndicPositionalCategory::Top),
  ((0,14,76),IndicPositionalCategory::Top),
  ((0,14,77),IndicPositionalCategory::Top),
  ((0,14,78),IndicPositionalCategory::Top),
  ((0,14,176),IndicPositionalCategory::Right),
  ((0,14,177),IndicPositionalCategory::Top),
  ((0,14,178),IndicPositionalCategory::Right),
  ((0,14,179),IndicPositionalCategory::Right),
  ((0,14,180),IndicPositionalCategory::Top),
  ((0,14,181),IndicPositionalCategory::Top),
  ((0,14,182),IndicPositionalCategory::Top),
  ((0,14,183),IndicPositionalCategory::Top),
  ((0,14,184),IndicPositionalCategory::Bottom),
  ((0,14,185),IndicPositionalCategory::Bottom),
  ((0,14,187),IndicPositionalCategory::Top),
  ((0,14,188),IndicPositionalCategory::Bottom),
  ((0,14,192),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,193),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,194),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,195),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,196),IndicPositionalCategory::VisualOrderLeft),
  ((0,14,200),IndicPositionalCategory::Top),
  ((0,14,201),IndicPositionalCategory::Top),
  ((0,14,202),IndicPositionalCategory::Top),
  ((0,14,203),IndicPositionalCategory::Top),
  ((0,14,204),IndicPositionalCategory::Top),
  ((0,14,205),IndicPositionalCategory::Top),
  ((0,15,24),IndicPositionalCategory::Bottom),
  ((0,15,25),IndicPositionalCategory::Bottom),
  ((0,15,53),IndicPositionalCategory::Bottom),
  ((0,15,55),IndicPositionalCategory::Bottom),
  ((0,15,57),IndicPositionalCategory::Top),
  ((0,15,62),IndicPositionalCategory::Right),
  ((0,15,63),IndicPositionalCategory::Left),
  ((0,15,113),IndicPositionalCategory::Bottom),
  ((0,15,114),IndicPositionalCategory::Top),
  ((0,15,115),IndicPositionalCategory::TopAndBottom),
  ((0,15,116),IndicPositionalCategory::Bottom),
  ((0,15,117),IndicPositionalCategory::Bottom),
  ((0,15,118),IndicPositionalCategory::TopAndBottom),
  ((0,15,119),IndicPositionalCategory::TopAndBottom),
  ((0,15,120),IndicPositionalCategory::TopAndBottom),
  ((0,15,121),IndicPositionalCategory::TopAndBottom),
  ((0,15,122),IndicPositionalCategory::Top),
  ((0,15,123),IndicPositionalCategory::Top),
  ((0,15,124),IndicPositionalCategory::Top),
  ((0,15,125),IndicPositionalCategory::Top),
  ((0,15,126),IndicPositionalCategory::Top),
  ((0,15,127),IndicPositionalCategory::Right),
  ((0,15,128),IndicPositionalCategory::Top),
  ((0,15,129),IndicPositionalCategory::TopAndBottom),
  ((0,15,130),IndicPositionalCategory::Top),
  ((0,15,131),IndicPositionalCategory::Top),
  ((0,15,132),IndicPositionalCategory::Bottom),
  ((0,15,134),IndicPositionalCategory::Top),
  ((0,15,135),IndicPositionalCategory::Top),
  ((0,15,141),IndicPositionalCategory::Bottom),
  ((0,15,142),IndicPositionalCategory::Bottom),
  ((0,15,143),IndicPositionalCategory::Bottom),
  ((0,15,144),IndicPositionalCategory::Bottom),
  ((0,15,145),IndicPositionalCategory::Bottom),
  ((0,15,146),IndicPositionalCategory::Bottom),
  ((0,15,147),IndicPositionalCategory::Bottom),
  ((0,15,148),IndicPositionalCategory::Bottom),
  ((0,15,149),IndicPositionalCategory::Bottom),
  ((0,15,150),IndicPositionalCategory::Bottom),
  ((0,15,151),IndicPositionalCategory::Bottom),
  ((0,15,153),IndicPositionalCategory::Bottom),
  ((0,15,154),IndicPositionalCategory::Bottom),
  ((0,15,155),IndicPositionalCategory::Bottom),
  ((0,15,156),IndicPositionalCategory::Bottom),
  ((0,15,157),IndicPositionalCategory::Bottom),
  ((0,15,158),IndicPositionalCategory::Bottom),
  ((0,15,159),IndicPositionalCategory::Bottom),
  ((0,15,160),IndicPositionalCategory::Bottom),
  ((0,15,161),IndicPositionalCategory::Bottom),
  ((0,15,162),IndicPositionalCategory::Bottom),
  ((0,15,163),IndicPositionalCategory::Bottom),
  ((0,15,164),IndicPositionalCategory::Bottom),
  ((0,15,165),IndicPositionalCategory::Bottom),
  ((0,15,166),IndicPositionalCategory::Bottom),
  ((0,15,167),IndicPositionalCategory::Bottom),
  ((0,15,168),IndicPositionalCategory::Bottom),
  ((0,15,169),IndicPositionalCategory::Bottom),
  ((0,15,170),IndicPositionalCategory::Bottom),
  ((0,15,171),IndicPositionalCategory::Bottom),
  ((0,15,172),IndicPositionalCategory::Bottom),
  ((0,15,173),IndicPositionalCategory::Bottom),
  ((0,15,174),IndicPositionalCategory::Bottom),
  ((0,15,175),IndicPositionalCategory::Bottom),
  ((0,15,176),IndicPositionalCategory::Bottom),
  ((0,15,177),IndicPositionalCategory::Bottom),
  ((0,15,178),IndicPositionalCategory::Bottom),
  ((0,15,179),IndicPositionalCategory::Bottom),
  ((0,15,180),IndicPositionalCategory::Bottom),
  ((0,15,181),IndicPositionalCategory::Bottom),
  ((0,15,182),IndicPositionalCategory::Bottom),
  ((0,15,183),IndicPositionalCategory::Bottom),
  ((0,15,184),IndicPositionalCategory::Bottom),
  ((0,15,185),IndicPositionalCategory::Bottom),
  ((0,15,186),IndicPositionalCategory::Bottom),
  ((0,15,187),IndicPositionalCategory::Bottom),
  ((0,15,188),IndicPositionalCategory::Bottom),
  ((0,15,198),IndicPositionalCategory::Bottom),
  ((0,16,43),IndicPositionalCategory::Right),
  ((0,16,44),IndicPositionalCategory::Right),
  ((0,16,45),IndicPositionalCategory::Top),
  ((0,16,46),IndicPositionalCategory::Top),
  ((0,16,47),IndicPositionalCategory::Bottom),
  ((0,16,48),IndicPositionalCategory::Bottom),
  ((0,16,49),IndicPositionalCategory::Left),
  ((0,16,50),IndicPositionalCategory::Top),
  ((0,16,51),IndicPositionalCategory::Top),
  ((0,16,52),IndicPositionalCategory::Top),
  ((0,16,53),IndicPositionalCategory::Top),
  ((0,16,54),IndicPositionalCategory::Top),
  ((0,16,55),IndicPositionalCategory::Bottom),
  ((0,16,56),IndicPositionalCategory::Right),
  ((0,16,58),IndicPositionalCategory::Top),
  ((0,16,59),IndicPositionalCategory::Right),
  ((0,16,61),IndicPositionalCategory::Bottom),
  ((0,16,62),IndicPositionalCategory::Bottom),
  ((0,16,86),IndicPositionalCategory::Right),
  ((0,16,87),IndicPositionalCategory::Right),
  ((0,16,88),IndicPositionalCategory::Bottom),
  ((0,16,89),IndicPositionalCategory::Bottom),
  ((0,16,94),IndicPositionalCategory::Bottom),
  ((0,16,95),IndicPositionalCategory::Bottom),
  ((0,16,96),IndicPositionalCategory::Bottom),
  ((0,16,98),IndicPositionalCategory::Right),
  ((0,16,99),IndicPositionalCategory::Right),
  ((0,16,100),IndicPositionalCategory::Right),
  ((0,16,103),IndicPositionalCategory::Right),
  ((0,16,104),IndicPositionalCategory::Right),
  ((0,16,105),IndicPositionalCategory::Right),
  ((0,16,106),IndicPositionalCategory::Right),
  ((0,16,107),IndicPositionalCategory::Right),
  ((0,16,108),IndicPositionalCategory::Right),
  ((0,16,109),IndicPositionalCategory::Right),
  ((0,16,113),IndicPositionalCategory::Top),
  ((0,16,114),IndicPositionalCategory::Top),
  ((0,16,115),IndicPositionalCategory::Top),
  ((0,16,116),IndicPositionalCategory::Top),
  ((0,16,130),IndicPositionalCategory::Bottom),
  ((0,16,131),IndicPositionalCategory::Right),
  ((0,16,132),IndicPositionalCategory::Left),
  ((0,16,133),IndicPositionalCategory::Top),
  ((0,16,134),IndicPositionalCategory::Top),
  ((0,16,135),IndicPositionalCategory::Right),
  ((0,16,136),IndicPositionalCategory::Right),
  ((0,16,137),IndicPositionalCategory::Right),
  ((0,16,138),IndicPositionalCategory::Right),
  ((0,16,139),IndicPositionalCategory::Right),
  ((0,16,140),IndicPositionalCategory::Right),
  ((0,16,141),IndicPositionalCategory::Bottom),
  ((0,16,143),IndicPositionalCategory::Right),
  ((0,16,154),IndicPositionalCategory::Right),
  ((0,16,155),IndicPositionalCategory::Right),
  ((0,16,156),IndicPositionalCategory::Right),
  ((0,16,157),IndicPositionalCategory::Top),
  ((0,23,18),IndicPositionalCategory::Top),
  ((0,23,19),IndicPositionalCategory::Bottom),
  ((0,23,20),IndicPositionalCategory::Bottom),
  ((0,23,50),IndicPositionalCategory::Top),
  ((0,23,51),IndicPositionalCategory::Bottom),
  ((0,23,52),IndicPositionalCategory::Bottom),
  ((0,23,82),IndicPositionalCategory::Top),
  ((0,23,83),IndicPositionalCategory::Bottom),
  ((0,23,114),IndicPositionalCategory::Top),
  ((0,23,115),IndicPositionalCategory::Bottom),
  ((0,23,182),IndicPositionalCategory::Right),
  ((0,23,183),IndicPositionalCategory::Top),
  ((0,23,184),IndicPositionalCategory::Top),
  ((0,23,185),IndicPositionalCategory::Top),
  ((0,23,186),IndicPositionalCategory::Top),
  ((0,23,187),IndicPositionalCategory::Bottom),
  ((0,23,188),IndicPositionalCategory::Bottom),
  ((0,23,189),IndicPositionalCategory::Bottom),
  ((0,23,190),IndicPositionalCategory::TopAndLeft),
  ((0,23,191),IndicPositionalCategory::TopAndLeftAndRight),
  ((0,23,192),IndicPositionalCategory::LeftAndRight),
  ((0,23,193),IndicPositionalCategory::Left),
  ((0,23,194),IndicPositionalCategory::Left),
  ((0,23,195),IndicPositionalCategory::Left),
  ((0,23,196),IndicPositionalCategory::LeftAndRight),
  ((0,23,197),IndicPositionalCategory::LeftAndRight),
  ((0,23,198),IndicPositionalCategory::Top),
  ((0,23,199),IndicPositionalCategory::Right),
  ((0,23,200),IndicPositionalCategory::Right),
  ((0,23,201),IndicPositionalCategory::Top),
  ((0,23,202),IndicPositionalCategory::Top),
  ((0,23,203),IndicPositionalCategory::Top),
  ((0,23,204),IndicPositionalCategory::Top),
  ((0,23,205),IndicPositionalCategory::Top),
  ((0,23,206),IndicPositionalCategory::Top),
  ((0,23,207),IndicPositionalCategory::Top),
  ((0,23,208),IndicPositionalCategory::Top),
  ((0,23,209),IndicPositionalCategory::Top),
  ((0,23,211),IndicPositionalCategory::Top),
  ((0,23,221),IndicPositionalCategory::Top),
  ((0,25,32),IndicPositionalCategory::Top),
  ((0,25,33),IndicPositionalCategory::Top),
  ((0,25,34),IndicPositionalCategory::Bottom),
  ((0,25,35),IndicPositionalCategory::Right),
  ((0,25,36),IndicPositionalCategory::Right),
  ((0,25,37),IndicPositionalCategory::TopAndRight),
  ((0,25,38),IndicPositionalCategory::TopAndRight),
  ((0,25,39),IndicPositionalCategory::Top),
  ((0,25,40),IndicPositionalCategory::Top),
  ((0,25,41),IndicPositionalCategory::Right),
  ((0,25,42),IndicPositionalCategory::Right),
  ((0,25,43),IndicPositionalCategory::Right),
  ((0,25,48),IndicPositionalCategory::Right),
  ((0,25,49),IndicPositionalCategory::Right),
  ((0,25,50),IndicPositionalCategory::Bottom),
  ((0,25,51),IndicPositionalCategory::Right),
  ((0,25,52),IndicPositionalCategory::Right),
  ((0,25,53),IndicPositionalCategory::Right),
  ((0,25,54),IndicPositionalCategory::Right),
  ((0,25,55),IndicPositionalCategory::Right),
  ((0,25,56),IndicPositionalCategory::Right),
  ((0,25,57),IndicPositionalCategory::Bottom),
  ((0,25,58),IndicPositionalCategory::Top),
  ((0,25,59),IndicPositionalCategory::Bottom),
  ((0,25,176),IndicPositionalCategory::Right),
  ((0,25,177),IndicPositionalCategory::Right),
  ((0,25,178),IndicPositionalCategory::Right),
  ((0,25,179),IndicPositionalCategory::Right),
  ((0,25,180),IndicPositionalCategory::Right),
  ((0,25,181),IndicPositionalCategory::VisualOrderLeft),
  ((0,25,182),IndicPositionalCategory::VisualOrderLeft),
  ((0,25,183),IndicPositionalCategory::VisualOrderLeft),
  ((0,25,184),IndicPositionalCategory::Right),
  ((0,25,185),IndicPositionalCategory::Right),
  ((0,25,186),IndicPositionalCategory::VisualOrderLeft),
  ((0,25,187),IndicPositionalCategory::Right),
  ((0,25,188),IndicPositionalCategory::Right),
  ((0,25,189),IndicPositionalCategory::Right),
  ((0,25,190),IndicPositionalCategory::Right),
  ((0,25,191),IndicPositionalCategory::Right),
  ((0,25,192),IndicPositionalCategory::Right),
  ((0,25,200),IndicPositionalCategory::Right),
  ((0,25,201),IndicPositionalCategory::Right),
  ((0,26,23),IndicPositionalCategory::Top),
  ((0,26,24),IndicPositionalCategory::Bottom),
  ((0,26,25),IndicPositionalCategory::Left),
  ((0,26,26),IndicPositionalCategory::Right),
  ((0,26,27),IndicPositionalCategory::Top),
  ((0,26,85),IndicPositionalCategory::Left),
  ((0,26,86),IndicPositionalCategory::Bottom),
  ((0,26,87),IndicPositionalCategory::Right),
  ((0,26,88),IndicPositionalCategory::Top),
  ((0,26,89),IndicPositionalCategory::Top),
  ((0,26,90),IndicPositionalCategory::Top),
  ((0,26,91),IndicPositionalCategory::Bottom),
  ((0,26,92),IndicPositionalCategory::Bottom),
  ((0,26,93),IndicPositionalCategory::Bottom),
  ((0,26,94),IndicPositionalCategory::Bottom),
  ((0,26,97),IndicPositionalCategory::Right),
  ((0,26,98),IndicPositionalCategory::Top),
  ((0,26,99),IndicPositionalCategory::Right),
  ((0,26,100),IndicPositionalCategory::Right),
  ((0,26,101),IndicPositionalCategory::Top),
  ((0,26,102),IndicPositionalCategory::Top),
  ((0,26,103),IndicPositionalCategory::Top),
  ((0,26,104),IndicPositionalCategory::Top),
  ((0,26,105),IndicPositionalCategory::Bottom),
  ((0,26,106),IndicPositionalCategory::Bottom),
  ((0,26,107),IndicPositionalCategory::Top),
  ((0,26,108),IndicPositionalCategory::Bottom),
  ((0,26,109),IndicPositionalCategory::Right),
  ((0,26,110),IndicPositionalCategory::Left),
  ((0,26,111),IndicPositionalCategory::Left),
  ((0,26,112),IndicPositionalCategory::Left),
  ((0,26,113),IndicPositionalCategory::Left),
  ((0,26,114),IndicPositionalCategory::Left),
  ((0,26,115),IndicPositionalCategory::Top),
  ((0,26,116),IndicPositionalCategory::Top),
  ((0,26,117),IndicPositionalCategory::Top),
  ((0,26,118),IndicPositionalCategory::Top),
  ((0,26,119),IndicPositionalCategory::Top),
  ((0,26,120),IndicPositionalCategory::Top),
  ((0,26,121),IndicPositionalCategory::Top),
  ((0,26,122),IndicPositionalCategory::Top),
  ((0,26,123),IndicPositionalCategory::Top),
  ((0,26,124),IndicPositionalCategory::Top),
  ((0,26,127),IndicPositionalCategory::Bottom),
  ((0,27,0),IndicPositionalCategory::Top),
  ((0,27,1),IndicPositionalCategory::Top),
  ((0,27,2),IndicPositionalCategory::Top),
  ((0,27,3),IndicPositionalCategory::Top),
  ((0,27,4),IndicPositionalCategory::Right),
  ((0,27,52),IndicPositionalCategory::Top),
  ((0,27,53),IndicPositionalCategory::Right),
  ((0,27,54),IndicPositionalCategory::Top),
  ((0,27,55),IndicPositionalCategory::Top),
  ((0,27,56),IndicPositionalCategory::Bottom),
  ((0,27,57),IndicPositionalCategory::Bottom),
  ((0,27,58),IndicPositionalCategory::Bottom),
  ((0,27,59),IndicPositionalCategory::BottomAndRight),
  ((0,27,60),IndicPositionalCategory::TopAndBottom),
  ((0,27,61),IndicPositionalCategory::TopAndBottomAndRight),
  ((0,27,62),IndicPositionalCategory::Left),
  ((0,27,63),IndicPositionalCategory::Left),
  ((0,27,64),IndicPositionalCategory::LeftAndRight),
  ((0,27,65),IndicPositionalCategory::LeftAndRight),
  ((0,27,66),IndicPositionalCategory::Top),
  ((0,27,67),IndicPositionalCategory::TopAndRight),
  ((0,27,68),IndicPositionalCategory::Right),
  ((0,27,107),IndicPositionalCategory::Top),
  ((0,27,108),IndicPositionalCategory::Bottom),
  ((0,27,109),IndicPositionalCategory::Top),
  ((0,27,110),IndicPositionalCategory::Top),
  ((0,27,111),IndicPositionalCategory::Top),
  ((0,27,112),IndicPositionalCategory::Top),
  ((0,27,113),IndicPositionalCategory::Top),
  ((0,27,114),IndicPositionalCategory::Top),
  ((0,27,115),IndicPositionalCategory::Top),
  ((0,27,128),IndicPositionalCategory::Top),
  ((0,27,129),IndicPositionalCategory::Top),
  ((0,27,130),IndicPositionalCategory::Right),
  ((0,27,161),IndicPositionalCategory::Right),
  ((0,27,162),IndicPositionalCategory::Bottom),
  ((0,27,163),IndicPositionalCategory::Bottom),
  ((0,27,164),IndicPositionalCategory::Top),
  ((0,27,165),IndicPositionalCategory::Bottom),
  ((0,27,166),IndicPositionalCategory::Left),
  ((0,27,167),IndicPositionalCategory::Right),
  ((0,27,168),IndicPositionalCategory::Top),
  ((0,27,169),IndicPositionalCategory::Top),
  ((0,27,170),IndicPositionalCategory::Right),
  ((0,27,172),IndicPositionalCategory::Bottom),
  ((0,27,173),IndicPositionalCategory::Bottom),
  ((0,27,230),IndicPositionalCategory::Top),
  ((0,27,231),IndicPositionalCategory::Right),
  ((0,27,232),IndicPositionalCategory::Top),
  ((0,27,233),IndicPositionalCategory::Top),
  ((0,27,234),IndicPositionalCategory::Right),
  ((0,27,235),IndicPositionalCategory::Right),
  ((0,27,236),IndicPositionalCategory::Right),
  ((0,27,237),IndicPositionalCategory::Top),
  ((0,27,238),IndicPositionalCategory::Right),
  ((0,27,239),IndicPositionalCategory::Top),
  ((0,27,240),IndicPositionalCategory::Top),
  ((0,27,241),IndicPositionalCategory::Top),
  ((0,27,242),IndicPositionalCategory::Right),
  ((0,27,243),IndicPositionalCategory::Right),
  ((0,28,36),IndicPositionalCategory::Right),
  ((0,28,37),IndicPositionalCategory::Right),
  ((0,28,38),IndicPositionalCategory::Right),
  ((0,28,39),IndicPositionalCategory::Left),
  ((0,28,40),IndicPositionalCategory::Left),
  ((0,28,41),IndicPositionalCategory::TopAndLeft),
  ((0,28,42),IndicPositionalCategory::Right),
  ((0,28,43),IndicPositionalCategory::Right),
  ((0,28,44),IndicPositionalCategory::Bottom),
  ((0,28,45),IndicPositionalCategory::Top),
  ((0,28,46),IndicPositionalCategory::Top),
  ((0,28,47),IndicPositionalCategory::Top),
  ((0,28,48),IndicPositionalCategory::Top),
  ((0,28,49),IndicPositionalCategory::Top),
  ((0,28,50),IndicPositionalCategory::Top),
  ((0,28,51),IndicPositionalCategory::Top),
  ((0,28,52),IndicPositionalCategory::Left),
  ((0,28,53),IndicPositionalCategory::Left),
  ((0,28,54),IndicPositionalCategory::Top),
  ((0,28,55),IndicPositionalCategory::Bottom),
  ((0,28,208),IndicPositionalCategory::Top),
  ((0,28,209),IndicPositionalCategory::Top),
  ((0,28,210),IndicPositionalCategory::Top),
  ((0,28,212),IndicPositionalCategory::Overstruck),
  ((0,28,213),IndicPositionalCategory::Bottom),
  ((0,28,214),IndicPositionalCategory::Bottom),
  ((0,28,215),IndicPositionalCategory::Bottom),
  ((0,28,216),IndicPositionalCategory::Bottom),
  ((0,28,217),IndicPositionalCategory::Bottom),
  ((0,28,218),IndicPositionalCategory::Top),
  ((0,28,219),IndicPositionalCategory::Top),
  ((0,28,220),IndicPositionalCategory::Bottom),
  ((0,28,221),IndicPositionalCategory::Bottom),
  ((0,28,222),IndicPositionalCategory::Bottom),
  ((0,28,223),IndicPositionalCategory::Bottom),
  ((0,28,224),IndicPositionalCategory::Top),
  ((0,28,225),IndicPositionalCategory::Right),
  ((0,28,226),IndicPositionalCategory::Overstruck),
  ((0,28,227),IndicPositionalCategory::Overstruck),
  ((0,28,228),IndicPositionalCategory::Overstruck),
  ((0,28,229),IndicPositionalCategory::Overstruck),
  ((0,28,230),IndicPositionalCategory::Overstruck),
  ((0,28,231),IndicPositionalCategory::Overstruck),
  ((0,28,232),IndicPositionalCategory::Overstruck),
  ((0,28,237),IndicPositionalCategory::Bottom),
  ((0,28,244),IndicPositionalCategory::Top),
  ((0,29,251),IndicPositionalCategory::Top),
  ((0,168,6),IndicPositionalCategory::Top),
  ((0,168,11),IndicPositionalCategory::Top),
  ((0,168,35),IndicPositionalCategory::Right),
  ((0,168,36),IndicPositionalCategory::Right),
  ((0,168,37),IndicPositionalCategory::Bottom),
  ((0,168,38),IndicPositionalCategory::Top),
  ((0,168,39),IndicPositionalCategory::Right),
  ((0,168,128),IndicPositionalCategory::Right),
  ((0,168,129),IndicPositionalCategory::Right),
  ((0,168,180),IndicPositionalCategory::Right),
  ((0,168,181),IndicPositionalCategory::Right),
  ((0,168,182),IndicPositionalCategory::Right),
  ((0,168,183),IndicPositionalCategory::Right),
  ((0,168,184),IndicPositionalCategory::Right),
  ((0,168,185),IndicPositionalCategory::Right),
  ((0,168,186),IndicPositionalCategory::Right),
  ((0,168,187),IndicPositionalCategory::Right),
  ((0,168,188),IndicPositionalCategory::Right),
  ((0,168,189),IndicPositionalCategory::Right),
  ((0,168,190),IndicPositionalCategory::Right),
  ((0,168,191),IndicPositionalCategory::Right),
  ((0,168,192),IndicPositionalCategory::Right),
  ((0,168,193),IndicPositionalCategory::Right),
  ((0,168,194),IndicPositionalCategory::Right),
  ((0,168,195),IndicPositionalCategory::Right),
  ((0,168,196),IndicPositionalCategory::Bottom),
  ((0,168,197),IndicPositionalCategory::Top),
  ((0,168,224),IndicPositionalCategory::Top),
  ((0,168,225),IndicPositionalCategory::Top),
  ((0,168,226),IndicPositionalCategory::Top),
  ((0,168,227),IndicPositionalCategory::Top),
  ((0,168,228),IndicPositionalCategory::Top),
  ((0,168,229),IndicPositionalCategory::Top),
  ((0,168,230),IndicPositionalCategory::Top),
  ((0,168,231),IndicPositionalCategory::Top),
  ((0,168,232),IndicPositionalCategory::Top),
  ((0,168,233),IndicPositionalCategory::Top),
  ((0,168,234),IndicPositionalCategory::Top),
  ((0,168,235),IndicPositionalCategory::Top),
  ((0,168,236),IndicPositionalCategory::Top),
  ((0,168,237),IndicPositionalCategory::Top),
  ((0,168,238),IndicPositionalCategory::Top),
  ((0,168,239),IndicPositionalCategory::Top),
  ((0,168,240),IndicPositionalCategory::Top),
  ((0,168,241),IndicPositionalCategory::Top),
  ((0,169,43),IndicPositionalCategory::Bottom),
  ((0,169,44),IndicPositionalCategory::Bottom),
  ((0,169,45),IndicPositionalCategory::Bottom),
  ((0,169,71),IndicPositionalCategory::Bottom),
  ((0,169,72),IndicPositionalCategory::Bottom),
  ((0,169,73),IndicPositionalCategory::Bottom),
  ((0,169,74),IndicPositionalCategory::Top),
  ((0,169,75),IndicPositionalCategory::Bottom),
  ((0,169,76),IndicPositionalCategory::Bottom),
  ((0,169,77),IndicPositionalCategory::Bottom),
  ((0,169,78),IndicPositionalCategory::Bottom),
  ((0,169,79),IndicPositionalCategory::Top),
  ((0,169,80),IndicPositionalCategory::Top),
  ((0,169,81),IndicPositionalCategory::Top),
  ((0,169,82),IndicPositionalCategory::Right),
  ((0,169,83),IndicPositionalCategory::Right),
  ((0,169,128),IndicPositionalCategory::Top),
  ((0,169,129),IndicPositionalCategory::Top),
  ((0,169,130),IndicPositionalCategory::Top),
  ((0,169,131),IndicPositionalCategory::Right),
  ((0,169,179),IndicPositionalCategory::Top),
  ((0,169,180),IndicPositionalCategory::Right),
  ((0,169,181),IndicPositionalCategory::Right),
  ((0,169,182),IndicPositionalCategory::Top),
  ((0,169,183),IndicPositionalCategory::Top),
  ((0,169,184),IndicPositionalCategory::Bottom),
  ((0,169,185),IndicPositionalCategory::Bottom),
  ((0,169,186),IndicPositionalCategory::Left),
  ((0,169,187),IndicPositionalCategory::Left),
  ((0,169,188),IndicPositionalCategory::Top),
  ((0,169,189),IndicPositionalCategory::Right),
  ((0,169,190),IndicPositionalCategory::Right),
  ((0,169,191),IndicPositionalCategory::Right),
  ((0,169,192),IndicPositionalCategory::BottomAndRight),
  ((0,169,229),IndicPositionalCategory::Top),
  ((0,170,41),IndicPositionalCategory::Top),
  ((0,170,42),IndicPositionalCategory::Top),
  ((0,170,43),IndicPositionalCategory::Top),
  ((0,170,44),IndicPositionalCategory::Top),
  ((0,170,45),IndicPositionalCategory::Bottom),
  ((0,170,46),IndicPositionalCategory::Top),
  ((0,170,47),IndicPositionalCategory::Left),
  ((0,170,48),IndicPositionalCategory::Left),
  ((0,170,49),IndicPositionalCategory::Top),
  ((0,170,50),IndicPositionalCategory::Bottom),
  ((0,170,51),IndicPositionalCategory::Right),
  ((0,170,52),IndicPositionalCategory::Left),
  ((0,170,53),IndicPositionalCategory::Bottom),
  ((0,170,54),IndicPositionalCategory::Bottom),
  ((0,170,67),IndicPositionalCategory::Top),
  ((0,170,76),IndicPositionalCategory::Top),
  ((0,170,77),IndicPositionalCategory::Right),
  ((0,170,123),IndicPositionalCategory::Right),
  ((0,170,124),IndicPositionalCategory::Top),
  ((0,170,125),IndicPositionalCategory::Right),
  ((0,170,176),IndicPositionalCategory::Top),
  ((0,170,177),IndicPositionalCategory::Right),
  ((0,170,178),IndicPositionalCategory::Top),
  ((0,170,179),IndicPositionalCategory::Top),
  ((0,170,180),IndicPositionalCategory::Bottom),
  ((0,170,181),IndicPositionalCategory::VisualOrderLeft),
  ((0,170,182),IndicPositionalCategory::VisualOrderLeft),
  ((0,170,183),IndicPositionalCategory::Top),
  ((0,170,184),IndicPositionalCategory::Top),
  ((0,170,185),IndicPositionalCategory::VisualOrderLeft),
  ((0,170,186),IndicPositionalCategory::Right),
  ((0,170,187),IndicPositionalCategory::VisualOrderLeft),
  ((0,170,188),IndicPositionalCategory::VisualOrderLeft),
  ((0,170,189),IndicPositionalCategory::Right),
  ((0,170,190),IndicPositionalCategory::Top),
  ((0,170,191),IndicPositionalCategory::Top),
  ((0,170,193),IndicPositionalCategory::Top),
  ((0,170,235),IndicPositionalCategory::Left),
  ((0,170,236),IndicPositionalCategory::Bottom),
  ((0,170,237),IndicPositionalCategory::Top),
  ((0,170,238),IndicPositionalCategory::Left),
  ((0,170,239),IndicPositionalCategory::Right),
  ((0,170,245),IndicPositionalCategory::Right),
  ((0,171,227),IndicPositionalCategory::Right),
  ((0,171,228),IndicPositionalCategory::Right),
  ((0,171,229),IndicPositionalCategory::Top),
  ((0,171,230),IndicPositionalCategory::Right),
  ((0,171,231),IndicPositionalCategory::Right),
  ((0,171,232),IndicPositionalCategory::Bottom),
  ((0,171,233),IndicPositionalCategory::Right),
  ((0,171,234),IndicPositionalCategory::Right),
  ((0,171,236),IndicPositionalCategory::Right),
  ((0,171,237),IndicPositionalCategory::Bottom),
  ((1,10,1),IndicPositionalCategory::Overstruck),
  ((1,10,2),IndicPositionalCategory::Bottom),
  ((1,10,3),IndicPositionalCategory::Bottom),
  ((1,10,5),IndicPositionalCategory::Top),
  ((1,10,6),IndicPositionalCategory::Overstruck),
  ((1,10,12),IndicPositionalCategory::Bottom),
  ((1,10,13),IndicPositionalCategory::Bottom),
  ((1,10,14),IndicPositionalCategory::Bottom),
  ((1,10,15),IndicPositionalCategory::Top),
  ((1,10,56),IndicPositionalCategory::Top),
  ((1,10,57),IndicPositionalCategory::Bottom),
  ((1,10,58),IndicPositionalCategory::Bottom),
  ((1,16,0),IndicPositionalCategory::Right),
  ((1,16,1),IndicPositionalCategory::Top),
  ((1,16,2),IndicPositionalCategory::Right),
  ((1,16,56),IndicPositionalCategory::Top),
  ((1,16,57),IndicPositionalCategory::Top),
  ((1,16,58),IndicPositionalCategory::Top),
  ((1,16,59),IndicPositionalCategory::Top),
  ((1,16,60),IndicPositionalCategory::Bottom),
  ((1,16,61),IndicPositionalCategory::Bottom),
  ((1,16,62),IndicPositionalCategory::Bottom),
  ((1,16,63),IndicPositionalCategory::Bottom),
  ((1,16,64),IndicPositionalCategory::Bottom),
  ((1,16,65),IndicPositionalCategory::Bottom),
  ((1,16,66),IndicPositionalCategory::Top),
  ((1,16,67),IndicPositionalCategory::Top),
  ((1,16,68),IndicPositionalCategory::Top),
  ((1,16,69),IndicPositionalCategory::Top),
  ((1,16,70),IndicPositionalCategory::Top),
  ((1,16,128),IndicPositionalCategory::Top),
  ((1,16,129),IndicPositionalCategory::Top),
  ((1,16,130),IndicPositionalCategory::Right),
  ((1,16,176),IndicPositionalCategory::Right),
  ((1,16,177),IndicPositionalCategory::Left),
  ((1,16,178),IndicPositionalCategory::Right),
  ((1,16,179),IndicPositionalCategory::Bottom),
  ((1,16,180),IndicPositionalCategory::Bottom),
  ((1,16,181),IndicPositionalCategory::Top),
  ((1,16,182),IndicPositionalCategory::Top),
  ((1,16,183),IndicPositionalCategory::Right),
  ((1,16,184),IndicPositionalCategory::Right),
  ((1,16,185),IndicPositionalCategory::Bottom),
  ((1,16,186),IndicPositionalCategory::Bottom),
  ((1,17,0),IndicPositionalCategory::Top),
  ((1,17,1),IndicPositionalCategory::Top),
  ((1,17,2),IndicPositionalCategory::Top),
  ((1,17,39),IndicPositionalCategory::Top),
  ((1,17,40),IndicPositionalCategory::Top),
  ((1,17,41),IndicPositionalCategory::Top),
  ((1,17,42),IndicPositionalCategory::Bottom),
  ((1,17,43),IndicPositionalCategory::Bottom),
  ((1,17,44),IndicPositionalCategory::Left),
  ((1,17,45),IndicPositionalCategory::Top),
  ((1,17,46),IndicPositionalCategory::TopAndBottom),
  ((1,17,47),IndicPositionalCategory::TopAndBottom),
  ((1,17,48),IndicPositionalCategory::Top),
  ((1,17,49),IndicPositionalCategory::Bottom),
  ((1,17,50),IndicPositionalCategory::Bottom),
  ((1,17,52),IndicPositionalCategory::Top),
  ((1,17,115),IndicPositionalCategory::Bottom),
  ((1,17,128),IndicPositionalCategory::Top),
  ((1,17,129),IndicPositionalCategory::Top),
  ((1,17,130),IndicPositionalCategory::Right),
  ((1,17,179),IndicPositionalCategory::Right),
  ((1,17,180),IndicPositionalCategory::Left),
  ((1,17,181),IndicPositionalCategory::Right),
  ((1,17,182),IndicPositionalCategory::Bottom),
  ((1,17,183),IndicPositionalCategory::Bottom),
  ((1,17,184),IndicPositionalCategory::Bottom),
  ((1,17,185),IndicPositionalCategory::Bottom),
  ((1,17,186),IndicPositionalCategory::Bottom),
  ((1,17,187),IndicPositionalCategory::Bottom),
  ((1,17,188),IndicPositionalCategory::Top),
  ((1,17,189),IndicPositionalCategory::Top),
  ((1,17,190),IndicPositionalCategory::Top),
  ((1,17,191),IndicPositionalCategory::TopAndRight),
  ((1,17,192),IndicPositionalCategory::Right),
  ((1,17,203),IndicPositionalCategory::Top),
  ((1,17,204),IndicPositionalCategory::Bottom),
  ((1,18,44),IndicPositionalCategory::Right),
  ((1,18,45),IndicPositionalCategory::Right),
  ((1,18,46),IndicPositionalCategory::Right),
  ((1,18,47),IndicPositionalCategory::Bottom),
  ((1,18,48),IndicPositionalCategory::Top),
  ((1,18,49),IndicPositionalCategory::Top),
  ((1,18,50),IndicPositionalCategory::TopAndRight),
  ((1,18,51),IndicPositionalCategory::TopAndRight),
  ((1,18,52),IndicPositionalCategory::Top),
  ((1,18,53),IndicPositionalCategory::Right),
  ((1,18,54),IndicPositionalCategory::Top),
  ((1,18,55),IndicPositionalCategory::Top),
  ((1,18,62),IndicPositionalCategory::Top),
  ((1,18,223),IndicPositionalCategory::Top),
  ((1,18,224),IndicPositionalCategory::Right),
  ((1,18,225),IndicPositionalCategory::Left),
  ((1,18,226),IndicPositionalCategory::Right),
  ((1,18,227),IndicPositionalCategory::Bottom),
  ((1,18,228),IndicPositionalCategory::Bottom),
  ((1,18,229),IndicPositionalCategory::Top),
  ((1,18,230),IndicPositionalCategory::Top),
  ((1,18,231),IndicPositionalCategory::Top),
  ((1,18,232),IndicPositionalCategory::Top),
  ((1,18,233),IndicPositionalCategory::Bottom),
  ((1,18,234),IndicPositionalCategory::Bottom),
  ((1,19,1),IndicPositionalCategory::Top),
  ((1,19,2),IndicPositionalCategory::Right),
  ((1,19,3),IndicPositionalCategory::Right),
  ((1,19,62),IndicPositionalCategory::Right),
  ((1,19,63),IndicPositionalCategory::Right),
  ((1,19,64),IndicPositionalCategory::Top),
  ((1,19,65),IndicPositionalCategory::Right),
  ((1,19,66),IndicPositionalCategory::Right),
  ((1,19,67),IndicPositionalCategory::Right),
  ((1,19,68),IndicPositionalCategory::Right),
  ((1,19,71),IndicPositionalCategory::Left),
  ((1,19,72),IndicPositionalCategory::Left),
  ((1,19,75),IndicPositionalCategory::LeftAndRight),
  ((1,19,76),IndicPositionalCategory::LeftAndRight),
  ((1,19,77),IndicPositionalCategory::Right),
  ((1,19,87),IndicPositionalCategory::Right),
  ((1,19,98),IndicPositionalCategory::Right),
  ((1,19,99),IndicPositionalCategory::Right),
  ((1,19,102),IndicPositionalCategory::Top),
  ((1,19,103),IndicPositionalCategory::Top),
  ((1,19,104),IndicPositionalCategory::Top),
  ((1,19,105),IndicPositionalCategory::Top),
  ((1,19,106),IndicPositionalCategory::Top),
  ((1,19,107),IndicPositionalCategory::Top),
  ((1,19,108),IndicPositionalCategory::Top),
  ((1,19,112),IndicPositionalCategory::Top),
  ((1,19,113),IndicPositionalCategory::Top),
  ((1,19,114),IndicPositionalCategory::Top),
  ((1,19,115),IndicPositionalCategory::Top),
  ((1,19,116),IndicPositionalCategory::Top),
  ((1,20,53),IndicPositionalCategory::Right),
  ((1,20,54),IndicPositionalCategory::Left),
  ((1,20,55),IndicPositionalCategory::Right),
  ((1,20,56),IndicPositionalCategory::Bottom),
  ((1,20,57),IndicPositionalCategory::Bottom),
  ((1,20,58),IndicPositionalCategory::Bottom),
  ((1,20,59),IndicPositionalCategory::Bottom),
  ((1,20,60),IndicPositionalCategory::Bottom),
  ((1,20,61),IndicPositionalCategory::Bottom),
  ((1,20,62),IndicPositionalCategory::Top),
  ((1,20,63),IndicPositionalCategory::Top),
  ((1,20,64),IndicPositionalCategory::Right),
  ((1,20,65),IndicPositionalCategory::Right),
  ((1,20,66),IndicPositionalCategory::Bottom),
  ((1,20,67),IndicPositionalCategory::Top),
  ((1,20,68),IndicPositionalCategory::Top),
  ((1,20,69),IndicPositionalCategory::Right),
  ((1,20,70),IndicPositionalCategory::Bottom),
  ((1,20,176),IndicPositionalCategory::Right),
  ((1,20,177),IndicPositionalCategory::Left),
  ((1,20,178),IndicPositionalCategory::Right),
  ((1,20,179),IndicPositionalCategory::Bottom),
  ((1,20,180),IndicPositionalCategory::Bottom),
  ((1,20,181),IndicPositionalCategory::Bottom),
  ((1,20,182),IndicPositionalCategory::Bottom),
  ((1,20,183),IndicPositionalCategory::Bottom),
  ((1,20,184),IndicPositionalCategory::Bottom),
  ((1,20,185),IndicPositionalCategory::Left),
  ((1,20,186),IndicPositionalCategory::Top),
  ((1,20,187),IndicPositionalCategory::TopAndLeft),
  ((1,20,188),IndicPositionalCategory::LeftAndRight),
  ((1,20,189),IndicPositionalCategory::Right),
  ((1,20,190),IndicPositionalCategory::LeftAndRight),
  ((1,20,191),IndicPositionalCategory::Top),
  ((1,20,192),IndicPositionalCategory::Top),
  ((1,20,193),IndicPositionalCategory::Right),
  ((1,20,194),IndicPositionalCategory::Bottom),
  ((1,20,195),IndicPositionalCategory::Bottom),
  ((1,21,175),IndicPositionalCategory::Right),
  ((1,21,176),IndicPositionalCategory::Left),
  ((1,21,177),IndicPositionalCategory::Right),
  ((1,21,178),IndicPositionalCategory::Bottom),
  ((1,21,179),IndicPositionalCategory::Bottom),
  ((1,21,180),IndicPositionalCategory::Bottom),
  ((1,21,181),IndicPositionalCategory::Bottom),
  ((1,21,184),IndicPositionalCategory::Left),
  ((1,21,185),IndicPositionalCategory::TopAndLeft),
  ((1,21,186),IndicPositionalCategory::LeftAndRight),
  ((1,21,187),IndicPositionalCategory::TopAndLeftAndRight),
  ((1,21,188),IndicPositionalCategory::Top),
  ((1,21,189),IndicPositionalCategory::Top),
  ((1,21,190),IndicPositionalCategory::Right),
  ((1,21,191),IndicPositionalCategory::Bottom),
  ((1,21,192),IndicPositionalCategory::Bottom),
  ((1,21,220),IndicPositionalCategory::Bottom),
  ((1,21,221),IndicPositionalCategory::Bottom),
  ((1,22,48),IndicPositionalCategory::Right),
  ((1,22,49),IndicPositionalCategory::Right),
  ((1,22,50),IndicPositionalCategory::Right),
  ((1,22,51),IndicPositionalCategory::Bottom),
  ((1,22,52),IndicPositionalCategory::Bottom),
  ((1,22,53),IndicPositionalCategory::Bottom),
  ((1,22,54),IndicPositionalCategory::Bottom),
  ((1,22,55),IndicPositionalCategory::Bottom),
  ((1,22,56),IndicPositionalCategory::Bottom),
  ((1,22,57),IndicPositionalCategory::Top),
  ((1,22,58),IndicPositionalCategory::Top),
  ((1,22,59),IndicPositionalCategory::Right),
  ((1,22,60),IndicPositionalCategory::Right),
  ((1,22,61),IndicPositionalCategory::Top),
  ((1,22,62),IndicPositionalCategory::Right),
  ((1,22,63),IndicPositionalCategory::Bottom),
  ((1,22,64),IndicPositionalCategory::Top),
  ((1,22,171),IndicPositionalCategory::Top),
  ((1,22,172),IndicPositionalCategory::Right),
  ((1,22,173),IndicPositionalCategory::Top),
  ((1,22,174),IndicPositionalCategory::Left),
  ((1,22,175),IndicPositionalCategory::Right),
  ((1,22,176),IndicPositionalCategory::Bottom),
  ((1,22,177),IndicPositionalCategory::Bottom),
  ((1,22,178),IndicPositionalCategory::Top),
  ((1,22,179),IndicPositionalCategory::Top),
  ((1,22,180),IndicPositionalCategory::Top),
  ((1,22,181),IndicPositionalCategory::Top),
  ((1,22,182),IndicPositionalCategory::Right),
  ((1,22,183),IndicPositionalCategory::Bottom),
  ((1,23,29),IndicPositionalCategory::Bottom),
  ((1,23,31),IndicPositionalCategory::Top),
  ((1,23,32),IndicPositionalCategory::Right),
  ((1,23,33),IndicPositionalCategory::Right),
  ((1,23,34),IndicPositionalCategory::Top),
  ((1,23,35),IndicPositionalCategory::Top),
  ((1,23,36),IndicPositionalCategory::Bottom),
  ((1,23,37),IndicPositionalCategory::Bottom),
  ((1,23,38),IndicPositionalCategory::Left),
  ((1,23,39),IndicPositionalCategory::Top),
  ((1,23,40),IndicPositionalCategory::Bottom),
  ((1,23,41),IndicPositionalCategory::Top),
  ((1,23,42),IndicPositionalCategory::Top),
  ((1,23,43),IndicPositionalCategory::Top),
  ((1,28,47),IndicPositionalCategory::Right),
  ((1,28,48),IndicPositionalCategory::Top),
  ((1,28,49),IndicPositionalCategory::Top),
  ((1,28,50),IndicPositionalCategory::Bottom),
  ((1,28,51),IndicPositionalCategory::Bottom),
  ((1,28,52),IndicPositionalCategory::Bottom),
  ((1,28,53),IndicPositionalCategory::Bottom),
  ((1,28,54),IndicPositionalCategory::Bottom),
  ((1,28,56),IndicPositionalCategory::Top),
  ((1,28,57),IndicPositionalCategory::Top),
  ((1,28,58),IndicPositionalCategory::Top),
  ((1,28,59),IndicPositionalCategory::Top),
  ((1,28,60),IndicPositionalCategory::Top),
  ((1,28,61),IndicPositionalCategory::Top),
  ((1,28,62),IndicPositionalCategory::Right),
  ((1,28,63),IndicPositionalCategory::Bottom),
  ((1,28,146),IndicPositionalCategory::Bottom),
  ((1,28,147),IndicPositionalCategory::Bottom),
  ((1,28,148),IndicPositionalCategory::Bottom),
  ((1,28,149),IndicPositionalCategory::Bottom),
  ((1,28,150),IndicPositionalCategory::Bottom),
  ((1,28,151),IndicPositionalCategory::Bottom),
  ((1,28,152),IndicPositionalCategory::Bottom),
  ((1,28,153),IndicPositionalCategory::Bottom),
  ((1,28,154),IndicPositionalCategory::Bottom),
  ((1,28,155),IndicPositionalCategory::Bottom),
  ((1,28,156),IndicPositionalCategory::Bottom),
  ((1,28,157),IndicPositionalCategory::Bottom),
  ((1,28,158),IndicPositionalCategory::Bottom),
  ((1,28,159),IndicPositionalCategory::Bottom),
  ((1,28,160),IndicPositionalCategory::Bottom),
  ((1,28,161),IndicPositionalCategory::Bottom),
  ((1,28,162),IndicPositionalCategory::Bottom),
  ((1,28,163),IndicPositionalCategory::Bottom),
  ((1,28,164),IndicPositionalCategory::Bottom),
  ((1,28,165),IndicPositionalCategory::Bottom),
  ((1,28,166),IndicPositionalCategory::Bottom),
  ((1,28,167),IndicPositionalCategory::Bottom),
  ((1,28,169),IndicPositionalCategory::Right),
  ((1,28,170),IndicPositionalCategory::Bottom),
  ((1,28,171),IndicPositionalCategory::Bottom),
  ((1,28,172),IndicPositionalCategory::Bottom),
  ((1,28,173),IndicPositionalCategory::Bottom),
  ((1,28,174),IndicPositionalCategory::Bottom),
  ((1,28,175),IndicPositionalCategory::Bottom),
  ((1,28,176),IndicPositionalCategory::Bottom),
  ((1,28,177),IndicPositionalCategory::Left),
  ((1,28,178),IndicPositionalCategory::Bottom),
  ((1,28,179),IndicPositionalCategory::Top),
  ((1,28,180),IndicPositionalCategory::Right),
  ((1,28,181),IndicPositionalCategory::Top),
  ((1,28,182),IndicPositionalCategory::Top)
];

