% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ideal.R
\name{ideal}
\alias{ideal}
\alias{ideal.}
\alias{ideal_}
\alias{ideal_.}
\alias{m2_parse_function.m2_ideal}
\alias{m2_parse_function.m2_monomialideal}
\alias{print.m2_ideal}
\alias{print.m2_ideal_list}
\alias{radical}
\alias{radical.}
\alias{saturate}
\alias{saturate.}
\alias{quotient}
\alias{quotient.}
\alias{primary_decomposition}
\alias{primary_decomposition.}
\alias{dimension}
\alias{+.m2_ideal}
\alias{*.m2_ideal}
\alias{==.m2_ideal}
\alias{^.m2_ideal}
\title{Create a new ideal in Macaulay2}
\usage{
ideal(..., raw_chars = FALSE, code = FALSE)

ideal.(..., raw_chars = FALSE, code = FALSE)

ideal_(x, raw_chars = FALSE, code = FALSE, ...)

ideal_.(x, raw_chars = FALSE, code = FALSE, ...)

\method{m2_parse_function}{m2_ideal}(x)

\method{m2_parse_function}{m2_monomialideal}(x)

\method{print}{m2_ideal}(x, ...)

\method{print}{m2_ideal_list}(x, ...)

radical(ideal, ring, code = FALSE, ...)

radical.(ideal, ring, code = FALSE, ...)

saturate(I, J, code = FALSE, ...)

saturate.(I, J, code = FALSE, ...)

quotient(I, J, code = FALSE, ...)

quotient.(I, J, code = FALSE, ...)

primary_decomposition(ideal, code = FALSE, ...)

primary_decomposition.(ideal, code = FALSE, ...)

dimension(ideal, code = FALSE, ...)

\method{+}{m2_ideal}(e1, e2)

\method{*}{m2_ideal}(e1, e2)

\method{==}{m2_ideal}(e1, e2)

\method{^}{m2_ideal}(e1, e2)
}
\arguments{
\item{...}{...}

\item{raw_chars}{if \code{TRUE}, the character vector will not be parsed by
\code{\link[mpoly:mp]{mpoly::mp()}}, saving time (default: \code{FALSE}). the down-side is that
the strings must be formated for M2 use directly, as opposed to for
\code{\link[mpoly:mp]{mpoly::mp()}}. (e.g. \code{"x*y+3"} instead of \code{"x y + 3"})}

\item{code}{return only the M2 code? (default: \code{FALSE})}

\item{x}{a listing of polynomials. several formats are accepted, see
examples.}

\item{ideal}{an ideal object of class \code{m2_ideal} or
\code{m2_ideal_pointer}}

\item{ring}{the referent ring in Macaulay2}

\item{I, J}{ideals or objects parsable into ideals}

\item{e1, e2}{ideals for arithmetic}
}
\value{
a reference to a Macaulay2 ideal
}
\description{
Create a new ideal in Macaulay2
}
\examples{

\dontrun{ requires Macaulay2


##### basic usage
########################################

ring("x", "y", coefring = "QQ")
ideal("x + y", "x^2 + y^2")



##### different versions of gb
########################################

# standard evaluation version
poly_chars <- c("x + y", "x^2 + y^2")
ideal_(poly_chars)

# reference nonstandard evaluation version
ideal.("x + y", "x^2 + y^2")

# reference standard evaluation version
ideal_.(poly_chars)



##### different inputs to gb
########################################

ideal_(   c("x + y", "x^2 + y^2") )
ideal_(mp(c("x + y", "x^2 + y^2")))
ideal_(list("x + y", "x^2 + y^2") )



##### predicate functions
########################################

I  <- ideal ("x + y", "x^2 + y^2")
I. <- ideal.("x + y", "x^2 + y^2")
is.m2_ideal(I)
is.m2_ideal(I.)
is.m2_ideal_pointer(I)
is.m2_ideal_pointer(I.)



##### ideal radical
########################################

I <- ideal("(x^2 + 1)^2 y", "y + 1")
radical(I)
radical.(I)



##### ideal dimension
########################################

I <- ideal_(c("(x^2 + 1)^2 y", "y + 1"))
dimension(I)

# dimension of a line
ring("x", "y", coefring = "QQ")
I <- ideal("y - (x+1)")
dimension(I)

# dimension of a plane
ring("x", "y", "z", coefring = "QQ")
I <- ideal("z - (x+y+1)")
dimension(I)



##### ideal quotients and saturation
########################################

ring("x", "y", "z", coefring = "QQ")
(I <- ideal("x^2", "y^4", "z + 1"))
(J <- ideal("x^6"))

quotient(I, J)
quotient.(I, J)

saturate(I)
saturate.(I)
saturate(I, J)
saturate(I, mp("x"))
saturate(I, "x")


ring("x", "y", coefring = "QQ")
saturate(ideal("x y"), "x^2")

# saturation removes parts of varieties
# solution over R is x = -1, 0, 1
ring("x", coefring = "QQ")
I <- ideal("(x-1) x (x+1)")
saturate(I, "x") # remove x = 0 from solution
ideal("(x-1) (x+1)")



##### primary decomposition
########################################

ring("x", "y", "z", coefring = "QQ")
I <- ideal("(x^2 + 1) (x^2 + 2)", "y + 1")
primary_decomposition(I)
primary_decomposition.(I)

I <- ideal("x (x + 1)", "y")
primary_decomposition(I)

# variety = z axis union x-y plane
(I <- ideal("x z", "y z"))
dimension(I) # =  max dimension of irreducible components
(Is <- primary_decomposition(I))
dimension(Is)



##### ideal arithmetic
########################################

ring("x", "y", "z", coefring = "RR")

# sums (cox et al., 184)
(I <- ideal("x^2 + y"))
(J <- ideal("z"))
I + J

# products (cox et al., 185)
(I <- ideal("x", "y"))
(J <- ideal("z"))
I * J

# equality
(I <- ideal("x", "y"))
(J <- ideal("z"))
I == J
I == I

# powers
(I <- ideal("x", "y"))
I^3

}
}
